//jshint esversion: 9

//Logic Controller
const LogicCtrl = (function () {
 let currentDetails = "";

 function getValue(arr, amount) {
  if (arr[2]) {
   for (let i = arr[2]; i < arr[1]; i++) {
    if (amount == i) {
     return arr[2];
    }
   }
  }

  for (let i = arr[1]; i < arr[0]; i++) {
   if (amount === i) return arr[1];
  }

  if (amount >= arr[0]) {
   return arr[0];
  }
 }

 return {
  getCurrentDetails: function () {
   return currentDetails;
  },
  setCurrentDetails(value) {
   currentDetails = value;
  },
  sorter: function (arr) {
   //sorter function
   return arr.sort((a, b) => {
    if (arr === businessType) getSortBy = "business_type";
    if (arr === ekTowns) getSortBy = "town";
    let typeA = a[getSortBy].trim().toLowerCase(),
     typeB = b[getSortBy].trim().toLowerCase();
    if (typeA < typeB) return -1; //sort string ascending
    if (typeA > typeB) return 1;
    return 0; //default return value  (no sorting)
   });
  },
  likelyAmount: (arr, amount) => {
   let result;
   for (let i = 0; i < arr.length; i++) {
    if (arr[i].includes(amount)) {
     result = arr[i];
     return result;
    }
   }
  },

  evaluteVal: (valArr, amount) => {
   let firstVal = [];
   let value;
   Array.isArray(valArr) &&
    firstVal.push(
     valArr[0][0],
     valArr[1][0],
     parseInt(`${valArr[2] && valArr[2][0]}`)
    );
   if (firstVal.length !== 0) {
    value = getValue(firstVal, parseInt(amount));
   }
   return value;
  },

  isUrban: (town) => {
   return town === "Ado-Ekiti" || town === "Ikere-Ekiti" ? true : false;
  },
  getAmount: (isUrban, someAmounts) =>
   isUrban ? someAmounts[1] : someAmounts[2],
 };
})();

const UICtrl = (function () {
 //Priate functions and variables
 //dom selectors
 const UISelectors = {
  businessData: "business",
  locations: "locations",
  display: "display",
  noOfRooms: "rooms",
  sqMeters: "sq",
  alert: "alert",
 };

 //Public functions
 return {
  getSelectors: () => {
   const businessData = document.getElementById(UISelectors.businessData);
   const locations = document.getElementById(UISelectors.locations);
   const display = document.getElementById(UISelectors.display);
   const noOfRooms = document.getElementById(UISelectors.noOfRooms);
   const sqMeters = document.getElementById(UISelectors.sqMeters);
   const alert = document.getElementById(UISelectors.alert);
   return {
    businessData,
    locations,
    display,
    noOfRooms,
    sqMeters,
    alert,
   };
  },
  checkFields: () => {
   const {
    businessData,
    locations,
    noOfRooms,
    sqMeters,
   } = UICtrl.getSelectors();
   if (businessData.selectedIndex === 0) {
    UICtrl.displayAlert("Enter Business Field");
    return false;
   } else UICtrl.clearAlert();
   if (locations.selectedIndex === 0) {
    UICtrl.displayAlert("Enter location Field");
    return false;
   }
   if (noOfRooms.value === "" && sqMeters.value === "") return false;
   return true;
  },
  populateUI: function (fieldData) {
   //map and populate the ui
   fieldData === businessType &&
    fieldData
     .map(
      (el) => `<option value="${el.business_type}">${el.business_type}</option>`
     )
     .forEach((el) => (business.innerHTML += el));

   fieldData === ekTowns &&
    ekTowns
     .map(
      (el) =>
       `<option data-name=${el.town.toLowerCase().split("-")[0]} value = "${
        el.reg_rural
       }">${el.town}</option>`
     )
     .forEach((el) => (locations.innerHTML += el));
  },
  clearAlert: function () {
   UICtrl.getSelectors().alert.innerHTML = "";
   UICtrl.getSelectors().alert.style.display = "none";
  },
  clearFields: function () {
   UICtrl.getSelectors().noOfRooms.value = "";
   UICtrl.getSelectors().sqMeters.value = "";
   UICtrl.getSelectors().display.value = "";
  },

  displayAlert: function (message) {
   UICtrl.clearAlert();
   UICtrl.getSelectors().alert.style.display = "block";
   UICtrl.getSelectors().alert.innerHTML = message;
   UICtrl.getSelectors().alert;
  },
  displayAmount: function (amount) {
   UICtrl.getSelectors().display.value = amount;
  },
 };
})();

const App = (function () {
 //Priate functions and variables
 const { businessData, locations, sqMeters, noOfRooms } = UICtrl.getSelectors();

 let roomsTracker = false,
  sqTracker = false;

 //Sort and Populate Business field
 const sortedBusiness = LogicCtrl.sorter(businessType);
 UICtrl.populateUI(sortedBusiness);

 //Sort and Populate location field
 const sortedLocations = LogicCtrl.sorter(ekTowns);
 UICtrl.populateUI(sortedLocations);

 const loadEventListners = () => {
  document.addEventListener("keyup", keyHandler);
  document.addEventListener("change", changeHandler);
 };

 const keyHandler = (e) => {
  e.preventDefault();

  if (e.target === sqMeters || e.target === noOfRooms) {
   if (UICtrl.checkFields()) {
    const details = LogicCtrl.getCurrentDetails();

    // console.log(details);

    if (!Array.isArray(details)) {
     getAllLogicDone(details);
    }
   } else {
    setTimeout(() => {
     UICtrl.displayAlert("Fill all fields");
    }, 1500);
   }
  }
 };

 const changeHandler = (e) => {
  e.preventDefault();

  if (e.target === businessData) {
   UICtrl.clearFields();
   //if all passed, proceed
   UICtrl.clearAlert();
   //check if business type is selected
   const index = businessData["selectedIndex"];
   //Get the selected business details
   const selectedBusiness = sortedBusiness[index - 1];
   //Destructure no of rooms
   const {
    reg_urban,
    reg_rural,
    reg_no_of_rooms,
    reg_sq_metres,
   } = selectedBusiness;

   if (reg_urban && reg_rural) {
    LogicCtrl.setCurrentDetails([reg_urban, reg_rural]);
   } else if (reg_no_of_rooms || reg_sq_metres) {
    if (reg_sq_metres && !reg_no_of_rooms) {
     LogicCtrl.setCurrentDetails(reg_sq_metres);
     sqTracker = true;
     roomsTracker = false;
    } else {
     LogicCtrl.setCurrentDetails(reg_no_of_rooms);
     sqTracker = false;
     roomsTracker = true;
    }
   }

   locations["selectedIndex"] = 0;
  }

  if (e.target === locations) {
   //clear field
   UICtrl.clearFields();
   // ["20,000", "10,000"];
   const details = LogicCtrl.getCurrentDetails();
   //  console.log(details);
   if (Array.isArray(details)) {
    getAllLogicDone2(details);
   }
  }
 };

 function getAllLogicDone(dataObj) {
  let inputVal;
  if (dataObj) {
   //Get Object values
   const values = Object.values(dataObj);

   //Get the actual value based on input
   if (sqTracker) {
    inputVal = sqMeters.value;
   } else {
    inputVal = noOfRooms.value;
   }

   const value = LogicCtrl.evaluteVal(values, inputVal);
   //Get an array of amounts
   const someAmounts = LogicCtrl.likelyAmount(values, value);
   //Now based on location
   const selectedLocation =
    locations["options"][locations["selectedIndex"]].innerText;
   //check if it's urban
   const isUrban = LogicCtrl.isUrban(selectedLocation);

   const actualAmount = LogicCtrl.getAmount(isUrban, someAmounts);

   UICtrl.displayAmount(actualAmount);
  }
 }

 function getAllLogicDone2([data1, data2]) {
  // if (reg_urban || reg_rural) {
  const selectedLocation =
   locations["options"][locations["selectedIndex"]].innerText;
  //check if it's urban
  const isUrban = LogicCtrl.isUrban(selectedLocation);

  const someAmounts = [null, data1, data2];

  const actualAmount = LogicCtrl.getAmount(isUrban, someAmounts);

  UICtrl.displayAmount(actualAmount);
  // }
 }

 //Public functions
 return {
  init: () => {
   loadEventListners();
  },
 };
})();

//Start App
App.init();
