<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Slim\App;
use Slim\Routing\RouteCollectorProxy;

// Handle Routes
return function (App $app) {
    // locationtbl
    $app->any('/locationtbllist[/{Locationid}]', LocationtblController::class . ':list')->add(PermissionMiddleware::class)->setName('locationtbllist-locationtbl-list'); // list
    $app->any('/locationtbladd[/{Locationid}]', LocationtblController::class . ':add')->add(PermissionMiddleware::class)->setName('locationtbladd-locationtbl-add'); // add
    $app->any('/locationtblview[/{Locationid}]', LocationtblController::class . ':view')->add(PermissionMiddleware::class)->setName('locationtblview-locationtbl-view'); // view
    $app->any('/locationtbledit[/{Locationid}]', LocationtblController::class . ':edit')->add(PermissionMiddleware::class)->setName('locationtbledit-locationtbl-edit'); // edit
    $app->any('/locationtbldelete[/{Locationid}]', LocationtblController::class . ':delete')->add(PermissionMiddleware::class)->setName('locationtbldelete-locationtbl-delete'); // delete
    $app->group(
        '/locationtbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Locationid}]', LocationtblController::class . ':list')->add(PermissionMiddleware::class)->setName('locationtbl/list-locationtbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{Locationid}]', LocationtblController::class . ':add')->add(PermissionMiddleware::class)->setName('locationtbl/add-locationtbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{Locationid}]', LocationtblController::class . ':view')->add(PermissionMiddleware::class)->setName('locationtbl/view-locationtbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{Locationid}]', LocationtblController::class . ':edit')->add(PermissionMiddleware::class)->setName('locationtbl/edit-locationtbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{Locationid}]', LocationtblController::class . ':delete')->add(PermissionMiddleware::class)->setName('locationtbl/delete-locationtbl-delete-2'); // delete
        }
    );

    // assetstbl
    $app->any('/assetstbllist[/{Assetsid}]', AssetstblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetstbllist-assetstbl-list'); // list
    $app->any('/assetstbladd[/{Assetsid}]', AssetstblController::class . ':add')->add(PermissionMiddleware::class)->setName('assetstbladd-assetstbl-add'); // add
    $app->any('/assetstblview[/{Assetsid}]', AssetstblController::class . ':view')->add(PermissionMiddleware::class)->setName('assetstblview-assetstbl-view'); // view
    $app->any('/assetstbledit[/{Assetsid}]', AssetstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('assetstbledit-assetstbl-edit'); // edit
    $app->group(
        '/assetstbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Assetsid}]', AssetstblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetstbl/list-assetstbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{Assetsid}]', AssetstblController::class . ':add')->add(PermissionMiddleware::class)->setName('assetstbl/add-assetstbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{Assetsid}]', AssetstblController::class . ':view')->add(PermissionMiddleware::class)->setName('assetstbl/view-assetstbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{Assetsid}]', AssetstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('assetstbl/edit-assetstbl-edit-2'); // edit
        }
    );

    // categorydetailstbl
    $app->any('/categorydetailstbllist[/{Categorydetailsid}]', CategorydetailstblController::class . ':list')->add(PermissionMiddleware::class)->setName('categorydetailstbllist-categorydetailstbl-list'); // list
    $app->any('/categorydetailstbladd[/{Categorydetailsid}]', CategorydetailstblController::class . ':add')->add(PermissionMiddleware::class)->setName('categorydetailstbladd-categorydetailstbl-add'); // add
    $app->any('/categorydetailstblview[/{Categorydetailsid}]', CategorydetailstblController::class . ':view')->add(PermissionMiddleware::class)->setName('categorydetailstblview-categorydetailstbl-view'); // view
    $app->any('/categorydetailstbledit[/{Categorydetailsid}]', CategorydetailstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('categorydetailstbledit-categorydetailstbl-edit'); // edit
    $app->any('/categorydetailstbldelete[/{Categorydetailsid}]', CategorydetailstblController::class . ':delete')->add(PermissionMiddleware::class)->setName('categorydetailstbldelete-categorydetailstbl-delete'); // delete
    $app->group(
        '/categorydetailstbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Categorydetailsid}]', CategorydetailstblController::class . ':list')->add(PermissionMiddleware::class)->setName('categorydetailstbl/list-categorydetailstbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{Categorydetailsid}]', CategorydetailstblController::class . ':add')->add(PermissionMiddleware::class)->setName('categorydetailstbl/add-categorydetailstbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{Categorydetailsid}]', CategorydetailstblController::class . ':view')->add(PermissionMiddleware::class)->setName('categorydetailstbl/view-categorydetailstbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{Categorydetailsid}]', CategorydetailstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('categorydetailstbl/edit-categorydetailstbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{Categorydetailsid}]', CategorydetailstblController::class . ':delete')->add(PermissionMiddleware::class)->setName('categorydetailstbl/delete-categorydetailstbl-delete-2'); // delete
        }
    );

    // categorytbl
    $app->any('/categorytbllist[/{Categoryid}]', CategorytblController::class . ':list')->add(PermissionMiddleware::class)->setName('categorytbllist-categorytbl-list'); // list
    $app->any('/categorytbladd[/{Categoryid}]', CategorytblController::class . ':add')->add(PermissionMiddleware::class)->setName('categorytbladd-categorytbl-add'); // add
    $app->any('/categorytblview[/{Categoryid}]', CategorytblController::class . ':view')->add(PermissionMiddleware::class)->setName('categorytblview-categorytbl-view'); // view
    $app->any('/categorytbledit[/{Categoryid}]', CategorytblController::class . ':edit')->add(PermissionMiddleware::class)->setName('categorytbledit-categorytbl-edit'); // edit
    $app->any('/categorytbldelete[/{Categoryid}]', CategorytblController::class . ':delete')->add(PermissionMiddleware::class)->setName('categorytbldelete-categorytbl-delete'); // delete
    $app->group(
        '/categorytbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Categoryid}]', CategorytblController::class . ':list')->add(PermissionMiddleware::class)->setName('categorytbl/list-categorytbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{Categoryid}]', CategorytblController::class . ':add')->add(PermissionMiddleware::class)->setName('categorytbl/add-categorytbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{Categoryid}]', CategorytblController::class . ':view')->add(PermissionMiddleware::class)->setName('categorytbl/view-categorytbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{Categoryid}]', CategorytblController::class . ':edit')->add(PermissionMiddleware::class)->setName('categorytbl/edit-categorytbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{Categoryid}]', CategorytblController::class . ':delete')->add(PermissionMiddleware::class)->setName('categorytbl/delete-categorytbl-delete-2'); // delete
        }
    );

    // reportuserstbl
    $app->any('/reportuserstbllist[/{_userid}]', ReportuserstblController::class . ':list')->add(PermissionMiddleware::class)->setName('reportuserstbllist-reportuserstbl-list'); // list
    $app->any('/reportuserstbladd[/{_userid}]', ReportuserstblController::class . ':add')->add(PermissionMiddleware::class)->setName('reportuserstbladd-reportuserstbl-add'); // add
    $app->any('/reportuserstblview[/{_userid}]', ReportuserstblController::class . ':view')->add(PermissionMiddleware::class)->setName('reportuserstblview-reportuserstbl-view'); // view
    $app->any('/reportuserstbledit[/{_userid}]', ReportuserstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('reportuserstbledit-reportuserstbl-edit'); // edit
    $app->any('/reportuserstbldelete[/{_userid}]', ReportuserstblController::class . ':delete')->add(PermissionMiddleware::class)->setName('reportuserstbldelete-reportuserstbl-delete'); // delete
    $app->group(
        '/reportuserstbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{_userid}]', ReportuserstblController::class . ':list')->add(PermissionMiddleware::class)->setName('reportuserstbl/list-reportuserstbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{_userid}]', ReportuserstblController::class . ':add')->add(PermissionMiddleware::class)->setName('reportuserstbl/add-reportuserstbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{_userid}]', ReportuserstblController::class . ':view')->add(PermissionMiddleware::class)->setName('reportuserstbl/view-reportuserstbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{_userid}]', ReportuserstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('reportuserstbl/edit-reportuserstbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{_userid}]', ReportuserstblController::class . ':delete')->add(PermissionMiddleware::class)->setName('reportuserstbl/delete-reportuserstbl-delete-2'); // delete
        }
    );

    // custodianstbl
    $app->any('/custodianstbllist[/{id}]', CustodianstblController::class . ':list')->add(PermissionMiddleware::class)->setName('custodianstbllist-custodianstbl-list'); // list
    $app->any('/custodianstbladd[/{id}]', CustodianstblController::class . ':add')->add(PermissionMiddleware::class)->setName('custodianstbladd-custodianstbl-add'); // add
    $app->any('/custodianstblview[/{id}]', CustodianstblController::class . ':view')->add(PermissionMiddleware::class)->setName('custodianstblview-custodianstbl-view'); // view
    $app->any('/custodianstbledit[/{id}]', CustodianstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('custodianstbledit-custodianstbl-edit'); // edit
    $app->any('/custodianstbldelete[/{id}]', CustodianstblController::class . ':delete')->add(PermissionMiddleware::class)->setName('custodianstbldelete-custodianstbl-delete'); // delete
    $app->group(
        '/custodianstbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{id}]', CustodianstblController::class . ':list')->add(PermissionMiddleware::class)->setName('custodianstbl/list-custodianstbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{id}]', CustodianstblController::class . ':add')->add(PermissionMiddleware::class)->setName('custodianstbl/add-custodianstbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{id}]', CustodianstblController::class . ':view')->add(PermissionMiddleware::class)->setName('custodianstbl/view-custodianstbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{id}]', CustodianstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('custodianstbl/edit-custodianstbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{id}]', CustodianstblController::class . ':delete')->add(PermissionMiddleware::class)->setName('custodianstbl/delete-custodianstbl-delete-2'); // delete
        }
    );

    // mdatbl
    $app->any('/mdatbllist[/{MDAID}]', MdatblController::class . ':list')->add(PermissionMiddleware::class)->setName('mdatbllist-mdatbl-list'); // list
    $app->any('/mdatbladd[/{MDAID}]', MdatblController::class . ':add')->add(PermissionMiddleware::class)->setName('mdatbladd-mdatbl-add'); // add
    $app->any('/mdatblview[/{MDAID}]', MdatblController::class . ':view')->add(PermissionMiddleware::class)->setName('mdatblview-mdatbl-view'); // view
    $app->any('/mdatbledit[/{MDAID}]', MdatblController::class . ':edit')->add(PermissionMiddleware::class)->setName('mdatbledit-mdatbl-edit'); // edit
    $app->any('/mdatbldelete[/{MDAID}]', MdatblController::class . ':delete')->add(PermissionMiddleware::class)->setName('mdatbldelete-mdatbl-delete'); // delete
    $app->group(
        '/mdatbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{MDAID}]', MdatblController::class . ':list')->add(PermissionMiddleware::class)->setName('mdatbl/list-mdatbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{MDAID}]', MdatblController::class . ':add')->add(PermissionMiddleware::class)->setName('mdatbl/add-mdatbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{MDAID}]', MdatblController::class . ':view')->add(PermissionMiddleware::class)->setName('mdatbl/view-mdatbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{MDAID}]', MdatblController::class . ':edit')->add(PermissionMiddleware::class)->setName('mdatbl/edit-mdatbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{MDAID}]', MdatblController::class . ':delete')->add(PermissionMiddleware::class)->setName('mdatbl/delete-mdatbl-delete-2'); // delete
        }
    );

    // condition_of_assettbl
    $app->any('/conditionofassettbllist[/{statusid}]', ConditionOfAssettblController::class . ':list')->add(PermissionMiddleware::class)->setName('conditionofassettbllist-condition_of_assettbl-list'); // list
    $app->any('/conditionofassettbladd[/{statusid}]', ConditionOfAssettblController::class . ':add')->add(PermissionMiddleware::class)->setName('conditionofassettbladd-condition_of_assettbl-add'); // add
    $app->any('/conditionofassettblview[/{statusid}]', ConditionOfAssettblController::class . ':view')->add(PermissionMiddleware::class)->setName('conditionofassettblview-condition_of_assettbl-view'); // view
    $app->any('/conditionofassettbledit[/{statusid}]', ConditionOfAssettblController::class . ':edit')->add(PermissionMiddleware::class)->setName('conditionofassettbledit-condition_of_assettbl-edit'); // edit
    $app->any('/conditionofassettbldelete[/{statusid}]', ConditionOfAssettblController::class . ':delete')->add(PermissionMiddleware::class)->setName('conditionofassettbldelete-condition_of_assettbl-delete'); // delete
    $app->group(
        '/condition_of_assettbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{statusid}]', ConditionOfAssettblController::class . ':list')->add(PermissionMiddleware::class)->setName('condition_of_assettbl/list-condition_of_assettbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{statusid}]', ConditionOfAssettblController::class . ':add')->add(PermissionMiddleware::class)->setName('condition_of_assettbl/add-condition_of_assettbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{statusid}]', ConditionOfAssettblController::class . ':view')->add(PermissionMiddleware::class)->setName('condition_of_assettbl/view-condition_of_assettbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{statusid}]', ConditionOfAssettblController::class . ':edit')->add(PermissionMiddleware::class)->setName('condition_of_assettbl/edit-condition_of_assettbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{statusid}]', ConditionOfAssettblController::class . ':delete')->add(PermissionMiddleware::class)->setName('condition_of_assettbl/delete-condition_of_assettbl-delete-2'); // delete
        }
    );

    // allremarkstbl
    $app->any('/allremarkstbllist[/{allremarksid}]', AllremarkstblController::class . ':list')->add(PermissionMiddleware::class)->setName('allremarkstbllist-allremarkstbl-list'); // list
    $app->any('/allremarkstblview[/{allremarksid}]', AllremarkstblController::class . ':view')->add(PermissionMiddleware::class)->setName('allremarkstblview-allremarkstbl-view'); // view
    $app->any('/allremarkstbledit[/{allremarksid}]', AllremarkstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('allremarkstbledit-allremarkstbl-edit'); // edit
    $app->group(
        '/allremarkstbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{allremarksid}]', AllremarkstblController::class . ':list')->add(PermissionMiddleware::class)->setName('allremarkstbl/list-allremarkstbl-list-2'); // list
            $group->any('/' . Config("VIEW_ACTION") . '[/{allremarksid}]', AllremarkstblController::class . ':view')->add(PermissionMiddleware::class)->setName('allremarkstbl/view-allremarkstbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{allremarksid}]', AllremarkstblController::class . ':edit')->add(PermissionMiddleware::class)->setName('allremarkstbl/edit-allremarkstbl-edit-2'); // edit
        }
    );

    // asset_staustbl
    $app->any('/assetstaustbllist[/{Statusid}]', AssetStaustblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetstaustbllist-asset_staustbl-list'); // list
    $app->any('/assetstaustbladd[/{Statusid}]', AssetStaustblController::class . ':add')->add(PermissionMiddleware::class)->setName('assetstaustbladd-asset_staustbl-add'); // add
    $app->any('/assetstaustblview[/{Statusid}]', AssetStaustblController::class . ':view')->add(PermissionMiddleware::class)->setName('assetstaustblview-asset_staustbl-view'); // view
    $app->any('/assetstaustbledit[/{Statusid}]', AssetStaustblController::class . ':edit')->add(PermissionMiddleware::class)->setName('assetstaustbledit-asset_staustbl-edit'); // edit
    $app->any('/assetstaustbldelete[/{Statusid}]', AssetStaustblController::class . ':delete')->add(PermissionMiddleware::class)->setName('assetstaustbldelete-asset_staustbl-delete'); // delete
    $app->group(
        '/asset_staustbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Statusid}]', AssetStaustblController::class . ':list')->add(PermissionMiddleware::class)->setName('asset_staustbl/list-asset_staustbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{Statusid}]', AssetStaustblController::class . ':add')->add(PermissionMiddleware::class)->setName('asset_staustbl/add-asset_staustbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{Statusid}]', AssetStaustblController::class . ':view')->add(PermissionMiddleware::class)->setName('asset_staustbl/view-asset_staustbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{Statusid}]', AssetStaustblController::class . ':edit')->add(PermissionMiddleware::class)->setName('asset_staustbl/edit-asset_staustbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{Statusid}]', AssetStaustblController::class . ':delete')->add(PermissionMiddleware::class)->setName('asset_staustbl/delete-asset_staustbl-delete-2'); // delete
        }
    );

    // SummaryReport
    $app->any('/summaryreport', SummaryReportController::class)->add(PermissionMiddleware::class)->setName('summaryreport-SummaryReport-summary'); // summary

    // assetconditionvaluationtbl
    $app->any('/assetconditionvaluationtbllist[/{AssetConditionValuationid}]', AssetconditionvaluationtblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetconditionvaluationtbllist-assetconditionvaluationtbl-list'); // list
    $app->any('/assetconditionvaluationtbladd[/{AssetConditionValuationid}]', AssetconditionvaluationtblController::class . ':add')->add(PermissionMiddleware::class)->setName('assetconditionvaluationtbladd-assetconditionvaluationtbl-add'); // add
    $app->any('/assetconditionvaluationtbledit[/{AssetConditionValuationid}]', AssetconditionvaluationtblController::class . ':edit')->add(PermissionMiddleware::class)->setName('assetconditionvaluationtbledit-assetconditionvaluationtbl-edit'); // edit
    $app->group(
        '/assetconditionvaluationtbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{AssetConditionValuationid}]', AssetconditionvaluationtblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetconditionvaluationtbl/list-assetconditionvaluationtbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{AssetConditionValuationid}]', AssetconditionvaluationtblController::class . ':add')->add(PermissionMiddleware::class)->setName('assetconditionvaluationtbl/add-assetconditionvaluationtbl-add-2'); // add
            $group->any('/' . Config("EDIT_ACTION") . '[/{AssetConditionValuationid}]', AssetconditionvaluationtblController::class . ':edit')->add(PermissionMiddleware::class)->setName('assetconditionvaluationtbl/edit-assetconditionvaluationtbl-edit-2'); // edit
        }
    );

    // inflationratestbl
    $app->any('/inflationratestbllist[/{InflationRatesid}]', InflationratestblController::class . ':list')->add(PermissionMiddleware::class)->setName('inflationratestbllist-inflationratestbl-list'); // list
    $app->any('/inflationratestbladd[/{InflationRatesid}]', InflationratestblController::class . ':add')->add(PermissionMiddleware::class)->setName('inflationratestbladd-inflationratestbl-add'); // add
    $app->any('/inflationratestblview[/{InflationRatesid}]', InflationratestblController::class . ':view')->add(PermissionMiddleware::class)->setName('inflationratestblview-inflationratestbl-view'); // view
    $app->any('/inflationratestbledit[/{InflationRatesid}]', InflationratestblController::class . ':edit')->add(PermissionMiddleware::class)->setName('inflationratestbledit-inflationratestbl-edit'); // edit
    $app->any('/inflationratestbldelete[/{InflationRatesid}]', InflationratestblController::class . ':delete')->add(PermissionMiddleware::class)->setName('inflationratestbldelete-inflationratestbl-delete'); // delete
    $app->group(
        '/inflationratestbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{InflationRatesid}]', InflationratestblController::class . ':list')->add(PermissionMiddleware::class)->setName('inflationratestbl/list-inflationratestbl-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{InflationRatesid}]', InflationratestblController::class . ':add')->add(PermissionMiddleware::class)->setName('inflationratestbl/add-inflationratestbl-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{InflationRatesid}]', InflationratestblController::class . ':view')->add(PermissionMiddleware::class)->setName('inflationratestbl/view-inflationratestbl-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{InflationRatesid}]', InflationratestblController::class . ':edit')->add(PermissionMiddleware::class)->setName('inflationratestbl/edit-inflationratestbl-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{InflationRatesid}]', InflationratestblController::class . ':delete')->add(PermissionMiddleware::class)->setName('inflationratestbl/delete-inflationratestbl-delete-2'); // delete
        }
    );

    // DetailedReport
    $app->any('/detailedreport', DetailedReportController::class)->add(PermissionMiddleware::class)->setName('detailedreport-DetailedReport-summary'); // summary

    // reassignasset
    $app->any('/reassignassetlist[/{Assetsid}]', ReassignassetController::class . ':list')->add(PermissionMiddleware::class)->setName('reassignassetlist-reassignasset-list'); // list
    $app->any('/reassignassetupdate', ReassignassetController::class . ':update')->add(PermissionMiddleware::class)->setName('reassignassetupdate-reassignasset-update'); // update
    $app->group(
        '/reassignasset',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Assetsid}]', ReassignassetController::class . ':list')->add(PermissionMiddleware::class)->setName('reassignasset/list-reassignasset-list-2'); // list
            $group->any('/' . Config("UPDATE_ACTION") . '', ReassignassetController::class . ':update')->add(PermissionMiddleware::class)->setName('reassignasset/update-reassignasset-update-2'); // update
        }
    );

    // MotorVehicleReport2
    $app->any('/motorvehiclereport2', MotorVehicleReport2Controller::class)->add(PermissionMiddleware::class)->setName('motorvehiclereport2-MotorVehicleReport2-summary'); // summary

    // moveasset
    $app->any('/moveassetlist[/{Assetsid}]', MoveassetController::class . ':list')->add(PermissionMiddleware::class)->setName('moveassetlist-moveasset-list'); // list
    $app->any('/moveassetupdate', MoveassetController::class . ':update')->add(PermissionMiddleware::class)->setName('moveassetupdate-moveasset-update'); // update
    $app->group(
        '/moveasset',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Assetsid}]', MoveassetController::class . ':list')->add(PermissionMiddleware::class)->setName('moveasset/list-moveasset-list-2'); // list
            $group->any('/' . Config("UPDATE_ACTION") . '', MoveassetController::class . ':update')->add(PermissionMiddleware::class)->setName('moveasset/update-moveasset-update-2'); // update
        }
    );

    // assetsaudittrailtbl
    $app->any('/assetsaudittrailtbllist[/{Assetlogid}]', AssetsaudittrailtblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetsaudittrailtbllist-assetsaudittrailtbl-list'); // list
    $app->any('/assetsaudittrailtblview[/{Assetlogid}]', AssetsaudittrailtblController::class . ':view')->add(PermissionMiddleware::class)->setName('assetsaudittrailtblview-assetsaudittrailtbl-view'); // view
    $app->group(
        '/assetsaudittrailtbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Assetlogid}]', AssetsaudittrailtblController::class . ':list')->add(PermissionMiddleware::class)->setName('assetsaudittrailtbl/list-assetsaudittrailtbl-list-2'); // list
            $group->any('/' . Config("VIEW_ACTION") . '[/{Assetlogid}]', AssetsaudittrailtblController::class . ':view')->add(PermissionMiddleware::class)->setName('assetsaudittrailtbl/view-assetsaudittrailtbl-view-2'); // view
        }
    );

    // Assetlog
    $app->any('/assetlog', AssetlogController::class)->add(PermissionMiddleware::class)->setName('assetlog-Assetlog-summary'); // summary

    // make
    $app->any('/makelist[/{id}]', MakeController::class . ':list')->add(PermissionMiddleware::class)->setName('makelist-make-list'); // list
    $app->any('/makeadd[/{id}]', MakeController::class . ':add')->add(PermissionMiddleware::class)->setName('makeadd-make-add'); // add
    $app->any('/makeview[/{id}]', MakeController::class . ':view')->add(PermissionMiddleware::class)->setName('makeview-make-view'); // view
    $app->any('/makeedit[/{id}]', MakeController::class . ':edit')->add(PermissionMiddleware::class)->setName('makeedit-make-edit'); // edit
    $app->any('/makedelete[/{id}]', MakeController::class . ':delete')->add(PermissionMiddleware::class)->setName('makedelete-make-delete'); // delete
    $app->group(
        '/make',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{id}]', MakeController::class . ':list')->add(PermissionMiddleware::class)->setName('make/list-make-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{id}]', MakeController::class . ':add')->add(PermissionMiddleware::class)->setName('make/add-make-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{id}]', MakeController::class . ':view')->add(PermissionMiddleware::class)->setName('make/view-make-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{id}]', MakeController::class . ':edit')->add(PermissionMiddleware::class)->setName('make/edit-make-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{id}]', MakeController::class . ':delete')->add(PermissionMiddleware::class)->setName('make/delete-make-delete-2'); // delete
        }
    );

    // model
    $app->any('/modellist[/{id}]', ModelController::class . ':list')->add(PermissionMiddleware::class)->setName('modellist-model-list'); // list
    $app->any('/modeladd[/{id}]', ModelController::class . ':add')->add(PermissionMiddleware::class)->setName('modeladd-model-add'); // add
    $app->any('/modelview[/{id}]', ModelController::class . ':view')->add(PermissionMiddleware::class)->setName('modelview-model-view'); // view
    $app->any('/modeledit[/{id}]', ModelController::class . ':edit')->add(PermissionMiddleware::class)->setName('modeledit-model-edit'); // edit
    $app->any('/modeldelete[/{id}]', ModelController::class . ':delete')->add(PermissionMiddleware::class)->setName('modeldelete-model-delete'); // delete
    $app->group(
        '/model',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{id}]', ModelController::class . ':list')->add(PermissionMiddleware::class)->setName('model/list-model-list-2'); // list
            $group->any('/' . Config("ADD_ACTION") . '[/{id}]', ModelController::class . ':add')->add(PermissionMiddleware::class)->setName('model/add-model-add-2'); // add
            $group->any('/' . Config("VIEW_ACTION") . '[/{id}]', ModelController::class . ':view')->add(PermissionMiddleware::class)->setName('model/view-model-view-2'); // view
            $group->any('/' . Config("EDIT_ACTION") . '[/{id}]', ModelController::class . ':edit')->add(PermissionMiddleware::class)->setName('model/edit-model-edit-2'); // edit
            $group->any('/' . Config("DELETE_ACTION") . '[/{id}]', ModelController::class . ':delete')->add(PermissionMiddleware::class)->setName('model/delete-model-delete-2'); // delete
        }
    );

    // Dashboard2
    $app->any('/dashboard2[/{params:.*}]', Dashboard2Controller::class)->add(PermissionMiddleware::class)->setName('dashboard2-Dashboard2-custom'); // custom

    // custodianmovementtbl
    $app->any('/custodianmovementtbllist[/{verifyassetid}]', CustodianmovementtblController::class . ':list')->add(PermissionMiddleware::class)->setName('custodianmovementtbllist-custodianmovementtbl-list'); // list
    $app->any('/custodianmovementtbledit[/{verifyassetid}]', CustodianmovementtblController::class . ':edit')->add(PermissionMiddleware::class)->setName('custodianmovementtbledit-custodianmovementtbl-edit'); // edit
    $app->group(
        '/custodianmovementtbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{verifyassetid}]', CustodianmovementtblController::class . ':list')->add(PermissionMiddleware::class)->setName('custodianmovementtbl/list-custodianmovementtbl-list-2'); // list
            $group->any('/' . Config("EDIT_ACTION") . '[/{verifyassetid}]', CustodianmovementtblController::class . ':edit')->add(PermissionMiddleware::class)->setName('custodianmovementtbl/edit-custodianmovementtbl-edit-2'); // edit
        }
    );

    // SelectedMDAs
    $app->any('/selectedmdas', SelectedMdAsController::class)->add(PermissionMiddleware::class)->setName('selectedmdas-SelectedMDAs-summary'); // summary

    // print2
    $app->any('/print2[/{params:.*}]', Print2Controller::class)->add(PermissionMiddleware::class)->setName('print2-print2-custom'); // custom

    // verifyassets
    $app->any('/verifyassetslist[/{Assetsid}]', VerifyassetsController::class . ':list')->add(PermissionMiddleware::class)->setName('verifyassetslist-verifyassets-list'); // list
    $app->any('/verifyassetsview[/{Assetsid}]', VerifyassetsController::class . ':view')->add(PermissionMiddleware::class)->setName('verifyassetsview-verifyassets-view'); // view
    $app->group(
        '/verifyassets',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Assetsid}]', VerifyassetsController::class . ':list')->add(PermissionMiddleware::class)->setName('verifyassets/list-verifyassets-list-2'); // list
            $group->any('/' . Config("VIEW_ACTION") . '[/{Assetsid}]', VerifyassetsController::class . ':view')->add(PermissionMiddleware::class)->setName('verifyassets/view-verifyassets-view-2'); // view
        }
    );

    // directorytbl
    $app->any('/directorytbllist[/{Directoryid}]', DirectorytblController::class . ':list')->add(PermissionMiddleware::class)->setName('directorytbllist-directorytbl-list'); // list
    $app->any('/directorytblview[/{Directoryid}]', DirectorytblController::class . ':view')->add(PermissionMiddleware::class)->setName('directorytblview-directorytbl-view'); // view
    $app->group(
        '/directorytbl',
        function (RouteCollectorProxy $group) {
            $group->any('/' . Config("LIST_ACTION") . '[/{Directoryid}]', DirectorytblController::class . ':list')->add(PermissionMiddleware::class)->setName('directorytbl/list-directorytbl-list-2'); // list
            $group->any('/' . Config("VIEW_ACTION") . '[/{Directoryid}]', DirectorytblController::class . ':view')->add(PermissionMiddleware::class)->setName('directorytbl/view-directorytbl-view-2'); // view
        }
    );

    // printassets
    $app->any('/printassets[/{params:.*}]', PrintassetsController::class)->add(PermissionMiddleware::class)->setName('printassets-printassets-custom'); // custom

    // error
    $app->any('/error', OthersController::class . ':error')->add(PermissionMiddleware::class)->setName('error');

    // personal_data
    $app->any('/personaldata', OthersController::class . ':personaldata')->add(PermissionMiddleware::class)->setName('personaldata');

    // login
    $app->any('/login', OthersController::class . ':login')->add(PermissionMiddleware::class)->setName('login');

    // change_password
    $app->any('/changepassword', OthersController::class . ':changepassword')->add(PermissionMiddleware::class)->setName('changepassword');

    // logout
    $app->any('/logout', OthersController::class . ':logout')->add(PermissionMiddleware::class)->setName('logout');

    // Swagger
    $app->get('/' . Config("SWAGGER_ACTION"), OthersController::class . ':swagger')->setName(Config("SWAGGER_ACTION")); // Swagger

    // Index
    $app->any('/[index]', OthersController::class . ':index')->add(PermissionMiddleware::class)->setName('index');

    // Route Action event
    if (function_exists(PROJECT_NAMESPACE . "Route_Action")) {
        Route_Action($app);
    }

    /**
     * Catch-all route to serve a 404 Not Found page if none of the routes match
     * NOTE: Make sure this route is defined last.
     */
    $app->map(
        ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
        '/{routes:.+}',
        function ($request, $response, $params) {
            $error = [
                "statusCode" => "404",
                "error" => [
                    "class" => "text-warning",
                    "type" => Container("language")->phrase("Error"),
                    "description" => str_replace("%p", $params["routes"], Container("language")->phrase("PageNotFound")),
                ],
            ];
            Container("flash")->addMessage("error", $error);
            return $response->withStatus(302)->withHeader("Location", GetUrl("error")); // Redirect to error page
        }
    );
};
