<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class AssetsaudittrailtblList extends Assetsaudittrailtbl
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'assetsaudittrailtbl';

    // Page object name
    public $PageObjName = "AssetsaudittrailtblList";

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fassetsaudittrailtbllist";
    public $FormActionName = "k_action";
    public $FormBlankRowName = "k_blankrow";
    public $FormKeyCountName = "key_count";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Export URLs
    public $ExportPrintUrl;
    public $ExportHtmlUrl;
    public $ExportExcelUrl;
    public $ExportWordUrl;
    public $ExportXmlUrl;
    public $ExportCsvUrl;
    public $ExportPdfUrl;

    // Custom export
    public $ExportExcelCustom = false;
    public $ExportWordCustom = false;
    public $ExportPdfCustom = false;
    public $ExportEmailCustom = false;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (assetsaudittrailtbl)
        if (!isset($GLOBALS["assetsaudittrailtbl"]) || get_class($GLOBALS["assetsaudittrailtbl"]) == PROJECT_NAMESPACE . "assetsaudittrailtbl") {
            $GLOBALS["assetsaudittrailtbl"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Initialize URLs
        $this->ExportPrintUrl = $pageUrl . "export=print";
        $this->ExportExcelUrl = $pageUrl . "export=excel";
        $this->ExportWordUrl = $pageUrl . "export=word";
        $this->ExportPdfUrl = $pageUrl . "export=pdf";
        $this->ExportHtmlUrl = $pageUrl . "export=html";
        $this->ExportXmlUrl = $pageUrl . "export=xml";
        $this->ExportCsvUrl = $pageUrl . "export=csv";
        $this->AddUrl = "assetsaudittrailtbladd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiDeleteUrl = "assetsaudittrailtbldelete";
        $this->MultiUpdateUrl = "assetsaudittrailtblupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'assetsaudittrailtbl');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions();
        $this->ListOptions->TableVar = $this->TableVar;

        // Export options
        $this->ExportOptions = new ListOptions("div");
        $this->ExportOptions->TagClassName = "ew-export-option";

        // Import options
        $this->ImportOptions = new ListOptions("div");
        $this->ImportOptions->TagClassName = "ew-import-option";

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }
        $this->OtherOptions["addedit"] = new ListOptions("div");
        $this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
        $this->OtherOptions["detail"] = new ListOptions("div");
        $this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
        $this->OtherOptions["action"] = new ListOptions("div");
        $this->OtherOptions["action"]->TagClassName = "ew-action-option";

        // Filter options
        $this->FilterOptions = new ListOptions("div");
        $this->FilterOptions->TagClassName = "ew-filter-option fassetsaudittrailtbllistsrch";

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("assetsaudittrailtbl"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['Assetlogid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->Assetlogid->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchRowCount = 0; // For extended search
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $EditRowCount;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $RowAction = ""; // Row action
    public $MultiColumnClass = "col-sm";
    public $MultiColumnEditClass = "w-100";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $OldRecordset;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } elseif (IsPost()) {
            if (Post("exporttype") !== null) {
                $this->Export = Post("exporttype");
            }
            $custom = Post("custom", "");
        } elseif (Get("cmd") == "json") {
            $this->Export = Get("cmd");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportFileName = $this->TableVar; // Get export file, used in header

        // Get custom export parameters
        if ($this->isExport() && $custom != "") {
            $this->CustomExport = $this->Export;
            $this->Export = "print";
        }
        $CustomExportType = $this->CustomExport;
        $ExportType = $this->Export; // Get export parameter, used in header

        // Update Export URLs
        if (Config("USE_PHPEXCEL")) {
            $this->ExportExcelCustom = false;
        }
        if (Config("USE_PHPWORD")) {
            $this->ExportWordCustom = false;
        }
        if ($this->ExportExcelCustom) {
            $this->ExportExcelUrl .= "&amp;custom=1";
        }
        if ($this->ExportWordCustom) {
            $this->ExportWordUrl .= "&amp;custom=1";
        }
        if ($this->ExportPdfCustom) {
            $this->ExportPdfUrl .= "&amp;custom=1";
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->Assetlogid->Visible = false;
        $this->Asset_id->setVisibility();
        $this->Asset_No->setVisibility();
        $this->Details_of_Asset->setVisibility();
        $this->Asset_Status->setVisibility();
        $this->Condition_Of_Asset->setVisibility();
        $this->Location_id->setVisibility();
        $this->MDA_id->setVisibility();
        $this->Category->setVisibility();
        $this->Category_Details->setVisibility();
        $this->Make->setVisibility();
        $this->Model->setVisibility();
        $this->YearofManufacture->setVisibility();
        $this->Colour->setVisibility();
        $this->EngineNumber->setVisibility();
        $this->ChasisNumber->setVisibility();
        $this->CivilianPlateNumber->setVisibility();
        $this->GovtPlateNumber->setVisibility();
        $this->Custodian_id->setVisibility();
        $this->Date_of_Acquisition->setVisibility();
        $this->Aquistion_Cost->setVisibility();
        $this->Additional_Cost->setVisibility();
        $this->Revaluation_Cost->setVisibility();
        $this->Remarks->Visible = false;
        $this->Created_By->setVisibility();
        $this->Created_on->setVisibility();
        $this->hideFieldsForAddEdit();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Show checkbox column if multiple action
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
                $this->ListOptions["checkbox"]->Visible = true;
                break;
            }
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Location_id);
        $this->setupLookupOptions($this->MDA_id);
        $this->setupLookupOptions($this->Category);
        $this->setupLookupOptions($this->Custodian_id);
        $this->setupLookupOptions($this->Created_By);

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = "";

        // Get command
        $this->Command = strtolower(Get("cmd"));
        if ($this->isPageRequest()) {
            // Process list action first
            if ($this->processListAction()) { // Ajax request
                $this->terminate();
                return;
            }

            // Set up records per page
            $this->setupDisplayRecords();

            // Handle reset command
            $this->resetCmd();

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb();
            }

            // Hide list options
            if ($this->isExport()) {
                $this->ListOptions->hideAllOptions(["sequence"]);
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            } elseif ($this->isGridAdd() || $this->isGridEdit()) {
                $this->ListOptions->hideAllOptions();
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            }

            // Hide options
            if ($this->isExport() || $this->CurrentAction) {
                $this->ExportOptions->hideAllOptions();
                $this->FilterOptions->hideAllOptions();
                $this->ImportOptions->hideAllOptions();
            }

            // Hide other options
            if ($this->isExport()) {
                $this->OtherOptions->hideAllOptions();
            }

            // Get default search criteria
            AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

            // Get and validate search values for advanced search
            $this->loadSearchValues(); // Get search values

            // Process filter list
            if ($this->processFilterList()) {
                $this->terminate();
                return;
            }
            if (!$this->validateSearch()) {
                // Nothing to do
            }

            // Restore search parms from Session if not searching / reset / export
            if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
                $this->restoreSearchParms();
            }

            // Call Recordset SearchValidated event
            $this->recordsetSearchValidated();

            // Set up sorting order
            $this->setupSortOrder();

            // Get search criteria for advanced search
            if (!$this->hasInvalidFields()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load Sorting Order
        if ($this->Command != "json") {
            $this->loadSortOrder();
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms()) {
            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        AddFilter($this->SearchWhere, $srchAdvanced);
        AddFilter($this->SearchWhere, $srchBasic);

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json") {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }

        // Export data only
        if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
            $this->exportData();
            $this->terminate();
            return;
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if (!$this->CurrentAction && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Normal return
        if (IsApi()) {
            $rows = $this->getRecordsFromRecordset($this->Recordset);
            $this->Recordset->close();
            WriteJson(["success" => true, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
            $this->terminate(true);
            return;
        }

        // Set up pager
        $this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fassetsaudittrailtbllistsrch");
        }
        $filterList = Concat($filterList, $this->Assetlogid->AdvancedSearch->toJson(), ","); // Field Assetlogid
        $filterList = Concat($filterList, $this->Asset_id->AdvancedSearch->toJson(), ","); // Field Asset_id
        $filterList = Concat($filterList, $this->Asset_No->AdvancedSearch->toJson(), ","); // Field Asset_No
        $filterList = Concat($filterList, $this->Details_of_Asset->AdvancedSearch->toJson(), ","); // Field Details_of_Asset
        $filterList = Concat($filterList, $this->Asset_Status->AdvancedSearch->toJson(), ","); // Field Asset_Status
        $filterList = Concat($filterList, $this->Condition_Of_Asset->AdvancedSearch->toJson(), ","); // Field Condition_Of_Asset
        $filterList = Concat($filterList, $this->Location_id->AdvancedSearch->toJson(), ","); // Field Location_id
        $filterList = Concat($filterList, $this->MDA_id->AdvancedSearch->toJson(), ","); // Field MDA_id
        $filterList = Concat($filterList, $this->Category->AdvancedSearch->toJson(), ","); // Field Category
        $filterList = Concat($filterList, $this->Category_Details->AdvancedSearch->toJson(), ","); // Field Category_Details
        $filterList = Concat($filterList, $this->Make->AdvancedSearch->toJson(), ","); // Field Make
        $filterList = Concat($filterList, $this->Model->AdvancedSearch->toJson(), ","); // Field Model
        $filterList = Concat($filterList, $this->YearofManufacture->AdvancedSearch->toJson(), ","); // Field Year of Manufacture
        $filterList = Concat($filterList, $this->Colour->AdvancedSearch->toJson(), ","); // Field Colour
        $filterList = Concat($filterList, $this->EngineNumber->AdvancedSearch->toJson(), ","); // Field Engine Number
        $filterList = Concat($filterList, $this->ChasisNumber->AdvancedSearch->toJson(), ","); // Field Chasis Number
        $filterList = Concat($filterList, $this->CivilianPlateNumber->AdvancedSearch->toJson(), ","); // Field Civilian Plate Number
        $filterList = Concat($filterList, $this->GovtPlateNumber->AdvancedSearch->toJson(), ","); // Field Govt Plate Number
        $filterList = Concat($filterList, $this->Custodian_id->AdvancedSearch->toJson(), ","); // Field Custodian_id
        $filterList = Concat($filterList, $this->Date_of_Acquisition->AdvancedSearch->toJson(), ","); // Field Date_of_Acquisition
        $filterList = Concat($filterList, $this->Aquistion_Cost->AdvancedSearch->toJson(), ","); // Field Aquistion_Cost
        $filterList = Concat($filterList, $this->Additional_Cost->AdvancedSearch->toJson(), ","); // Field Additional_Cost
        $filterList = Concat($filterList, $this->Revaluation_Cost->AdvancedSearch->toJson(), ","); // Field Revaluation_Cost
        $filterList = Concat($filterList, $this->Remarks->AdvancedSearch->toJson(), ","); // Field Remarks
        $filterList = Concat($filterList, $this->Created_By->AdvancedSearch->toJson(), ","); // Field Created_By
        $filterList = Concat($filterList, $this->Created_on->AdvancedSearch->toJson(), ","); // Field Created_on

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fassetsaudittrailtbllistsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field Assetlogid
        $this->Assetlogid->AdvancedSearch->SearchValue = @$filter["x_Assetlogid"];
        $this->Assetlogid->AdvancedSearch->SearchOperator = @$filter["z_Assetlogid"];
        $this->Assetlogid->AdvancedSearch->SearchCondition = @$filter["v_Assetlogid"];
        $this->Assetlogid->AdvancedSearch->SearchValue2 = @$filter["y_Assetlogid"];
        $this->Assetlogid->AdvancedSearch->SearchOperator2 = @$filter["w_Assetlogid"];
        $this->Assetlogid->AdvancedSearch->save();

        // Field Asset_id
        $this->Asset_id->AdvancedSearch->SearchValue = @$filter["x_Asset_id"];
        $this->Asset_id->AdvancedSearch->SearchOperator = @$filter["z_Asset_id"];
        $this->Asset_id->AdvancedSearch->SearchCondition = @$filter["v_Asset_id"];
        $this->Asset_id->AdvancedSearch->SearchValue2 = @$filter["y_Asset_id"];
        $this->Asset_id->AdvancedSearch->SearchOperator2 = @$filter["w_Asset_id"];
        $this->Asset_id->AdvancedSearch->save();

        // Field Asset_No
        $this->Asset_No->AdvancedSearch->SearchValue = @$filter["x_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchOperator = @$filter["z_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchCondition = @$filter["v_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchValue2 = @$filter["y_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchOperator2 = @$filter["w_Asset_No"];
        $this->Asset_No->AdvancedSearch->save();

        // Field Details_of_Asset
        $this->Details_of_Asset->AdvancedSearch->SearchValue = @$filter["x_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchOperator = @$filter["z_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchCondition = @$filter["v_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchValue2 = @$filter["y_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchOperator2 = @$filter["w_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->save();

        // Field Asset_Status
        $this->Asset_Status->AdvancedSearch->SearchValue = @$filter["x_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchOperator = @$filter["z_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchCondition = @$filter["v_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchValue2 = @$filter["y_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchOperator2 = @$filter["w_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->save();

        // Field Condition_Of_Asset
        $this->Condition_Of_Asset->AdvancedSearch->SearchValue = @$filter["x_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchOperator = @$filter["z_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchCondition = @$filter["v_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchValue2 = @$filter["y_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchOperator2 = @$filter["w_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->save();

        // Field Location_id
        $this->Location_id->AdvancedSearch->SearchValue = @$filter["x_Location_id"];
        $this->Location_id->AdvancedSearch->SearchOperator = @$filter["z_Location_id"];
        $this->Location_id->AdvancedSearch->SearchCondition = @$filter["v_Location_id"];
        $this->Location_id->AdvancedSearch->SearchValue2 = @$filter["y_Location_id"];
        $this->Location_id->AdvancedSearch->SearchOperator2 = @$filter["w_Location_id"];
        $this->Location_id->AdvancedSearch->save();

        // Field MDA_id
        $this->MDA_id->AdvancedSearch->SearchValue = @$filter["x_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchOperator = @$filter["z_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchCondition = @$filter["v_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchValue2 = @$filter["y_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchOperator2 = @$filter["w_MDA_id"];
        $this->MDA_id->AdvancedSearch->save();

        // Field Category
        $this->Category->AdvancedSearch->SearchValue = @$filter["x_Category"];
        $this->Category->AdvancedSearch->SearchOperator = @$filter["z_Category"];
        $this->Category->AdvancedSearch->SearchCondition = @$filter["v_Category"];
        $this->Category->AdvancedSearch->SearchValue2 = @$filter["y_Category"];
        $this->Category->AdvancedSearch->SearchOperator2 = @$filter["w_Category"];
        $this->Category->AdvancedSearch->save();

        // Field Category_Details
        $this->Category_Details->AdvancedSearch->SearchValue = @$filter["x_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchOperator = @$filter["z_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchCondition = @$filter["v_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchValue2 = @$filter["y_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchOperator2 = @$filter["w_Category_Details"];
        $this->Category_Details->AdvancedSearch->save();

        // Field Make
        $this->Make->AdvancedSearch->SearchValue = @$filter["x_Make"];
        $this->Make->AdvancedSearch->SearchOperator = @$filter["z_Make"];
        $this->Make->AdvancedSearch->SearchCondition = @$filter["v_Make"];
        $this->Make->AdvancedSearch->SearchValue2 = @$filter["y_Make"];
        $this->Make->AdvancedSearch->SearchOperator2 = @$filter["w_Make"];
        $this->Make->AdvancedSearch->save();

        // Field Model
        $this->Model->AdvancedSearch->SearchValue = @$filter["x_Model"];
        $this->Model->AdvancedSearch->SearchOperator = @$filter["z_Model"];
        $this->Model->AdvancedSearch->SearchCondition = @$filter["v_Model"];
        $this->Model->AdvancedSearch->SearchValue2 = @$filter["y_Model"];
        $this->Model->AdvancedSearch->SearchOperator2 = @$filter["w_Model"];
        $this->Model->AdvancedSearch->save();

        // Field Year of Manufacture
        $this->YearofManufacture->AdvancedSearch->SearchValue = @$filter["x_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchOperator = @$filter["z_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchCondition = @$filter["v_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchValue2 = @$filter["y_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchOperator2 = @$filter["w_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->save();

        // Field Colour
        $this->Colour->AdvancedSearch->SearchValue = @$filter["x_Colour"];
        $this->Colour->AdvancedSearch->SearchOperator = @$filter["z_Colour"];
        $this->Colour->AdvancedSearch->SearchCondition = @$filter["v_Colour"];
        $this->Colour->AdvancedSearch->SearchValue2 = @$filter["y_Colour"];
        $this->Colour->AdvancedSearch->SearchOperator2 = @$filter["w_Colour"];
        $this->Colour->AdvancedSearch->save();

        // Field Engine Number
        $this->EngineNumber->AdvancedSearch->SearchValue = @$filter["x_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchOperator = @$filter["z_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchCondition = @$filter["v_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchValue2 = @$filter["y_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchOperator2 = @$filter["w_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->save();

        // Field Chasis Number
        $this->ChasisNumber->AdvancedSearch->SearchValue = @$filter["x_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchOperator = @$filter["z_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchCondition = @$filter["v_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchValue2 = @$filter["y_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchOperator2 = @$filter["w_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->save();

        // Field Civilian Plate Number
        $this->CivilianPlateNumber->AdvancedSearch->SearchValue = @$filter["x_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchOperator = @$filter["z_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchCondition = @$filter["v_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchValue2 = @$filter["y_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchOperator2 = @$filter["w_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->save();

        // Field Govt Plate Number
        $this->GovtPlateNumber->AdvancedSearch->SearchValue = @$filter["x_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchOperator = @$filter["z_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchCondition = @$filter["v_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchValue2 = @$filter["y_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchOperator2 = @$filter["w_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->save();

        // Field Custodian_id
        $this->Custodian_id->AdvancedSearch->SearchValue = @$filter["x_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchOperator = @$filter["z_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchCondition = @$filter["v_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchValue2 = @$filter["y_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchOperator2 = @$filter["w_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->save();

        // Field Date_of_Acquisition
        $this->Date_of_Acquisition->AdvancedSearch->SearchValue = @$filter["x_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchOperator = @$filter["z_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchCondition = @$filter["v_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchValue2 = @$filter["y_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchOperator2 = @$filter["w_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->save();

        // Field Aquistion_Cost
        $this->Aquistion_Cost->AdvancedSearch->SearchValue = @$filter["x_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchOperator = @$filter["z_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchCondition = @$filter["v_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchValue2 = @$filter["y_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchOperator2 = @$filter["w_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->save();

        // Field Additional_Cost
        $this->Additional_Cost->AdvancedSearch->SearchValue = @$filter["x_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchOperator = @$filter["z_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchCondition = @$filter["v_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchValue2 = @$filter["y_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchOperator2 = @$filter["w_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->save();

        // Field Revaluation_Cost
        $this->Revaluation_Cost->AdvancedSearch->SearchValue = @$filter["x_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchOperator = @$filter["z_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchCondition = @$filter["v_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchValue2 = @$filter["y_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchOperator2 = @$filter["w_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->save();

        // Field Remarks
        $this->Remarks->AdvancedSearch->SearchValue = @$filter["x_Remarks"];
        $this->Remarks->AdvancedSearch->SearchOperator = @$filter["z_Remarks"];
        $this->Remarks->AdvancedSearch->SearchCondition = @$filter["v_Remarks"];
        $this->Remarks->AdvancedSearch->SearchValue2 = @$filter["y_Remarks"];
        $this->Remarks->AdvancedSearch->SearchOperator2 = @$filter["w_Remarks"];
        $this->Remarks->AdvancedSearch->save();

        // Field Created_By
        $this->Created_By->AdvancedSearch->SearchValue = @$filter["x_Created_By"];
        $this->Created_By->AdvancedSearch->SearchOperator = @$filter["z_Created_By"];
        $this->Created_By->AdvancedSearch->SearchCondition = @$filter["v_Created_By"];
        $this->Created_By->AdvancedSearch->SearchValue2 = @$filter["y_Created_By"];
        $this->Created_By->AdvancedSearch->SearchOperator2 = @$filter["w_Created_By"];
        $this->Created_By->AdvancedSearch->save();

        // Field Created_on
        $this->Created_on->AdvancedSearch->SearchValue = @$filter["x_Created_on"];
        $this->Created_on->AdvancedSearch->SearchOperator = @$filter["z_Created_on"];
        $this->Created_on->AdvancedSearch->SearchCondition = @$filter["v_Created_on"];
        $this->Created_on->AdvancedSearch->SearchValue2 = @$filter["y_Created_on"];
        $this->Created_on->AdvancedSearch->SearchOperator2 = @$filter["w_Created_on"];
        $this->Created_on->AdvancedSearch->save();
    }

    // Advanced search WHERE clause based on QueryString
    protected function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->Assetlogid, $default, false); // Assetlogid
        $this->buildSearchSql($where, $this->Asset_id, $default, false); // Asset_id
        $this->buildSearchSql($where, $this->Asset_No, $default, false); // Asset_No
        $this->buildSearchSql($where, $this->Details_of_Asset, $default, false); // Details_of_Asset
        $this->buildSearchSql($where, $this->Asset_Status, $default, false); // Asset_Status
        $this->buildSearchSql($where, $this->Condition_Of_Asset, $default, false); // Condition_Of_Asset
        $this->buildSearchSql($where, $this->Location_id, $default, false); // Location_id
        $this->buildSearchSql($where, $this->MDA_id, $default, false); // MDA_id
        $this->buildSearchSql($where, $this->Category, $default, false); // Category
        $this->buildSearchSql($where, $this->Category_Details, $default, false); // Category_Details
        $this->buildSearchSql($where, $this->Make, $default, false); // Make
        $this->buildSearchSql($where, $this->Model, $default, false); // Model
        $this->buildSearchSql($where, $this->YearofManufacture, $default, false); // Year of Manufacture
        $this->buildSearchSql($where, $this->Colour, $default, false); // Colour
        $this->buildSearchSql($where, $this->EngineNumber, $default, false); // Engine Number
        $this->buildSearchSql($where, $this->ChasisNumber, $default, false); // Chasis Number
        $this->buildSearchSql($where, $this->CivilianPlateNumber, $default, false); // Civilian Plate Number
        $this->buildSearchSql($where, $this->GovtPlateNumber, $default, false); // Govt Plate Number
        $this->buildSearchSql($where, $this->Custodian_id, $default, false); // Custodian_id
        $this->buildSearchSql($where, $this->Date_of_Acquisition, $default, false); // Date_of_Acquisition
        $this->buildSearchSql($where, $this->Aquistion_Cost, $default, false); // Aquistion_Cost
        $this->buildSearchSql($where, $this->Additional_Cost, $default, false); // Additional_Cost
        $this->buildSearchSql($where, $this->Revaluation_Cost, $default, false); // Revaluation_Cost
        $this->buildSearchSql($where, $this->Remarks, $default, false); // Remarks
        $this->buildSearchSql($where, $this->Created_By, $default, false); // Created_By
        $this->buildSearchSql($where, $this->Created_on, $default, false); // Created_on

        // Set up search parm
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->Assetlogid->AdvancedSearch->save(); // Assetlogid
            $this->Asset_id->AdvancedSearch->save(); // Asset_id
            $this->Asset_No->AdvancedSearch->save(); // Asset_No
            $this->Details_of_Asset->AdvancedSearch->save(); // Details_of_Asset
            $this->Asset_Status->AdvancedSearch->save(); // Asset_Status
            $this->Condition_Of_Asset->AdvancedSearch->save(); // Condition_Of_Asset
            $this->Location_id->AdvancedSearch->save(); // Location_id
            $this->MDA_id->AdvancedSearch->save(); // MDA_id
            $this->Category->AdvancedSearch->save(); // Category
            $this->Category_Details->AdvancedSearch->save(); // Category_Details
            $this->Make->AdvancedSearch->save(); // Make
            $this->Model->AdvancedSearch->save(); // Model
            $this->YearofManufacture->AdvancedSearch->save(); // Year of Manufacture
            $this->Colour->AdvancedSearch->save(); // Colour
            $this->EngineNumber->AdvancedSearch->save(); // Engine Number
            $this->ChasisNumber->AdvancedSearch->save(); // Chasis Number
            $this->CivilianPlateNumber->AdvancedSearch->save(); // Civilian Plate Number
            $this->GovtPlateNumber->AdvancedSearch->save(); // Govt Plate Number
            $this->Custodian_id->AdvancedSearch->save(); // Custodian_id
            $this->Date_of_Acquisition->AdvancedSearch->save(); // Date_of_Acquisition
            $this->Aquistion_Cost->AdvancedSearch->save(); // Aquistion_Cost
            $this->Additional_Cost->AdvancedSearch->save(); // Additional_Cost
            $this->Revaluation_Cost->AdvancedSearch->save(); // Revaluation_Cost
            $this->Remarks->AdvancedSearch->save(); // Remarks
            $this->Created_By->AdvancedSearch->save(); // Created_By
            $this->Created_on->AdvancedSearch->save(); // Created_on
        }
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldOpr = strtoupper(trim($fldOpr));
        if ($fldOpr == "") {
            $fldOpr = "=";
        }
        $fldOpr2 = strtoupper(trim($fldOpr2));
        if ($fldOpr2 == "") {
            $fldOpr2 = "=";
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            $wrk = $wrk1; // Build final SQL
            if ($wrk2 != "") {
                $wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
            }
        } else {
            $fldVal = $this->convertSearchValue($fld, $fldVal);
            $fldVal2 = $this->convertSearchValue($fld, $fldVal2);
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        AddFilter($where, $wrk);
    }

    // Convert search value
    protected function convertSearchValue(&$fld, $fldVal)
    {
        if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE")) {
            return $fldVal;
        }
        $value = $fldVal;
        if ($fld->isBoolean()) {
            if ($fldVal != "") {
                $value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
            }
        } elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
            if ($fldVal != "") {
                $value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
            }
        }
        return $value;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        if ($this->Assetlogid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Asset_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Asset_No->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Details_of_Asset->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Asset_Status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Condition_Of_Asset->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Location_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->MDA_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Category_Details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Make->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Model->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->YearofManufacture->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Colour->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->EngineNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ChasisNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->CivilianPlateNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->GovtPlateNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Custodian_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Date_of_Acquisition->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Aquistion_Cost->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Additional_Cost->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Revaluation_Cost->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Created_By->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Created_on->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
                $this->Assetlogid->AdvancedSearch->unsetSession();
                $this->Asset_id->AdvancedSearch->unsetSession();
                $this->Asset_No->AdvancedSearch->unsetSession();
                $this->Details_of_Asset->AdvancedSearch->unsetSession();
                $this->Asset_Status->AdvancedSearch->unsetSession();
                $this->Condition_Of_Asset->AdvancedSearch->unsetSession();
                $this->Location_id->AdvancedSearch->unsetSession();
                $this->MDA_id->AdvancedSearch->unsetSession();
                $this->Category->AdvancedSearch->unsetSession();
                $this->Category_Details->AdvancedSearch->unsetSession();
                $this->Make->AdvancedSearch->unsetSession();
                $this->Model->AdvancedSearch->unsetSession();
                $this->YearofManufacture->AdvancedSearch->unsetSession();
                $this->Colour->AdvancedSearch->unsetSession();
                $this->EngineNumber->AdvancedSearch->unsetSession();
                $this->ChasisNumber->AdvancedSearch->unsetSession();
                $this->CivilianPlateNumber->AdvancedSearch->unsetSession();
                $this->GovtPlateNumber->AdvancedSearch->unsetSession();
                $this->Custodian_id->AdvancedSearch->unsetSession();
                $this->Date_of_Acquisition->AdvancedSearch->unsetSession();
                $this->Aquistion_Cost->AdvancedSearch->unsetSession();
                $this->Additional_Cost->AdvancedSearch->unsetSession();
                $this->Revaluation_Cost->AdvancedSearch->unsetSession();
                $this->Remarks->AdvancedSearch->unsetSession();
                $this->Created_By->AdvancedSearch->unsetSession();
                $this->Created_on->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore advanced search values
                $this->Assetlogid->AdvancedSearch->load();
                $this->Asset_id->AdvancedSearch->load();
                $this->Asset_No->AdvancedSearch->load();
                $this->Details_of_Asset->AdvancedSearch->load();
                $this->Asset_Status->AdvancedSearch->load();
                $this->Condition_Of_Asset->AdvancedSearch->load();
                $this->Location_id->AdvancedSearch->load();
                $this->MDA_id->AdvancedSearch->load();
                $this->Category->AdvancedSearch->load();
                $this->Category_Details->AdvancedSearch->load();
                $this->Make->AdvancedSearch->load();
                $this->Model->AdvancedSearch->load();
                $this->YearofManufacture->AdvancedSearch->load();
                $this->Colour->AdvancedSearch->load();
                $this->EngineNumber->AdvancedSearch->load();
                $this->ChasisNumber->AdvancedSearch->load();
                $this->CivilianPlateNumber->AdvancedSearch->load();
                $this->GovtPlateNumber->AdvancedSearch->load();
                $this->Custodian_id->AdvancedSearch->load();
                $this->Date_of_Acquisition->AdvancedSearch->load();
                $this->Aquistion_Cost->AdvancedSearch->load();
                $this->Additional_Cost->AdvancedSearch->load();
                $this->Revaluation_Cost->AdvancedSearch->load();
                $this->Remarks->AdvancedSearch->load();
                $this->Created_By->AdvancedSearch->load();
                $this->Created_on->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->Asset_id); // Asset_id
            $this->updateSort($this->Asset_No); // Asset_No
            $this->updateSort($this->Details_of_Asset); // Details_of_Asset
            $this->updateSort($this->Asset_Status); // Asset_Status
            $this->updateSort($this->Condition_Of_Asset); // Condition_Of_Asset
            $this->updateSort($this->Location_id); // Location_id
            $this->updateSort($this->MDA_id); // MDA_id
            $this->updateSort($this->Category); // Category
            $this->updateSort($this->Category_Details); // Category_Details
            $this->updateSort($this->Make); // Make
            $this->updateSort($this->Model); // Model
            $this->updateSort($this->YearofManufacture); // Year of Manufacture
            $this->updateSort($this->Colour); // Colour
            $this->updateSort($this->EngineNumber); // Engine Number
            $this->updateSort($this->ChasisNumber); // Chasis Number
            $this->updateSort($this->CivilianPlateNumber); // Civilian Plate Number
            $this->updateSort($this->GovtPlateNumber); // Govt Plate Number
            $this->updateSort($this->Custodian_id); // Custodian_id
            $this->updateSort($this->Date_of_Acquisition); // Date_of_Acquisition
            $this->updateSort($this->Aquistion_Cost); // Aquistion_Cost
            $this->updateSort($this->Additional_Cost); // Additional_Cost
            $this->updateSort($this->Revaluation_Cost); // Revaluation_Cost
            $this->updateSort($this->Created_By); // Created_By
            $this->updateSort($this->Created_on); // Created_on
            $this->setStartRecordNumber(1); // Reset start position
        }
    }

    // Load sort order parameters
    protected function loadSortOrder()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        if ($orderBy == "") {
            $this->DefaultSort = "";
            if ($this->getSqlOrderBy() != "") {
                $useDefaultSort = true;
                if ($useDefaultSort) {
                    $orderBy = $this->getSqlOrderBy();
                    $this->setSessionOrderBy($orderBy);
                } else {
                    $this->setSessionOrderBy("");
                }
            }
        }
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->Assetlogid->setSort("");
                $this->Asset_id->setSort("");
                $this->Asset_No->setSort("");
                $this->Details_of_Asset->setSort("");
                $this->Asset_Status->setSort("");
                $this->Condition_Of_Asset->setSort("");
                $this->Location_id->setSort("");
                $this->MDA_id->setSort("");
                $this->Category->setSort("");
                $this->Category_Details->setSort("");
                $this->Make->setSort("");
                $this->Model->setSort("");
                $this->YearofManufacture->setSort("");
                $this->Colour->setSort("");
                $this->EngineNumber->setSort("");
                $this->ChasisNumber->setSort("");
                $this->CivilianPlateNumber->setSort("");
                $this->GovtPlateNumber->setSort("");
                $this->Custodian_id->setSort("");
                $this->Date_of_Acquisition->setSort("");
                $this->Aquistion_Cost->setSort("");
                $this->Additional_Cost->setSort("");
                $this->Revaluation_Cost->setSort("");
                $this->Remarks->setSort("");
                $this->Created_By->setSort("");
                $this->Created_on->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item
        $item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
        $item->moveTo(0);
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl();
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
                    $action = $listaction->Action;
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a></li>";
                    if (count($links) == 1) { // Single button
                        $body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a>";
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
                $opt->Visible = true;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->Assetlogid->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Set up options default
        foreach ($options as $option) {
            $option->UseDropDownButton = false;
            $option->UseButtonGroup = true;
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->add($option->GroupOptionName);
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fassetsaudittrailtbllistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fassetsaudittrailtbllistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listaction->Action);
                $caption = $listaction->Caption;
                $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<a class="ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" href="#" onclick="return ew.submitAction(event,jQuery.extend({f:document.fassetsaudittrailtbllist},' . $listaction->toJson(true) . '));">' . $icon . '</a>';
                $item->Visible = $listaction->Allow;
            }
        }

        // Hide grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("useraction", "");
        if ($filter != "" && $userAction != "") {
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn, \PDO::FETCH_ASSOC);
            $this->CurrentAction = $userAction;

            // Call row action event
            if ($rs) {
                $conn->beginTransaction();
                $this->SelectedCount = $rs->recordCount();
                $this->SelectedIndex = 0;
                while (!$rs->EOF) {
                    $this->SelectedIndex++;
                    $row = $rs->fields;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                    $rs->moveNext();
                }
                if ($processed) {
                    $conn->commit(); // Commit the changes
                    if ($this->getSuccessMessage() == "" && !ob_get_length()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    $conn->rollback(); // Rollback changes

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if ($rs) {
                $rs->close();
            }
            $this->CurrentAction = ""; // Clear action
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up list options (extended codes)
    protected function setupListOptionsExt()
    {
    }

    // Render list options (extended codes)
    protected function renderListOptionsExt()
    {
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Assetlogid
        if (!$this->isAddOrEdit() && $this->Assetlogid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Assetlogid->AdvancedSearch->SearchValue != "" || $this->Assetlogid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Asset_id
        if (!$this->isAddOrEdit() && $this->Asset_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Asset_id->AdvancedSearch->SearchValue != "" || $this->Asset_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Asset_No
        if (!$this->isAddOrEdit() && $this->Asset_No->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Asset_No->AdvancedSearch->SearchValue != "" || $this->Asset_No->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Details_of_Asset
        if (!$this->isAddOrEdit() && $this->Details_of_Asset->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Details_of_Asset->AdvancedSearch->SearchValue != "" || $this->Details_of_Asset->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Asset_Status
        if (!$this->isAddOrEdit() && $this->Asset_Status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Asset_Status->AdvancedSearch->SearchValue != "" || $this->Asset_Status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Condition_Of_Asset
        if (!$this->isAddOrEdit() && $this->Condition_Of_Asset->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Condition_Of_Asset->AdvancedSearch->SearchValue != "" || $this->Condition_Of_Asset->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Location_id
        if (!$this->isAddOrEdit() && $this->Location_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Location_id->AdvancedSearch->SearchValue != "" || $this->Location_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // MDA_id
        if (!$this->isAddOrEdit() && $this->MDA_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->MDA_id->AdvancedSearch->SearchValue != "" || $this->MDA_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Category
        if (!$this->isAddOrEdit() && $this->Category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Category->AdvancedSearch->SearchValue != "" || $this->Category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->Category->AdvancedSearch->SearchValue)) {
            $this->Category->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue);
        }
        if (is_array($this->Category->AdvancedSearch->SearchValue2)) {
            $this->Category->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue2);
        }

        // Category_Details
        if (!$this->isAddOrEdit() && $this->Category_Details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Category_Details->AdvancedSearch->SearchValue != "" || $this->Category_Details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Make
        if (!$this->isAddOrEdit() && $this->Make->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Make->AdvancedSearch->SearchValue != "" || $this->Make->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Model
        if (!$this->isAddOrEdit() && $this->Model->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Model->AdvancedSearch->SearchValue != "" || $this->Model->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Year of Manufacture
        if (!$this->isAddOrEdit() && $this->YearofManufacture->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->YearofManufacture->AdvancedSearch->SearchValue != "" || $this->YearofManufacture->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Colour
        if (!$this->isAddOrEdit() && $this->Colour->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Colour->AdvancedSearch->SearchValue != "" || $this->Colour->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Engine Number
        if (!$this->isAddOrEdit() && $this->EngineNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->EngineNumber->AdvancedSearch->SearchValue != "" || $this->EngineNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Chasis Number
        if (!$this->isAddOrEdit() && $this->ChasisNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ChasisNumber->AdvancedSearch->SearchValue != "" || $this->ChasisNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Civilian Plate Number
        if (!$this->isAddOrEdit() && $this->CivilianPlateNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->CivilianPlateNumber->AdvancedSearch->SearchValue != "" || $this->CivilianPlateNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Govt Plate Number
        if (!$this->isAddOrEdit() && $this->GovtPlateNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->GovtPlateNumber->AdvancedSearch->SearchValue != "" || $this->GovtPlateNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Custodian_id
        if (!$this->isAddOrEdit() && $this->Custodian_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Custodian_id->AdvancedSearch->SearchValue != "" || $this->Custodian_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Date_of_Acquisition
        if (!$this->isAddOrEdit() && $this->Date_of_Acquisition->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Date_of_Acquisition->AdvancedSearch->SearchValue != "" || $this->Date_of_Acquisition->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Aquistion_Cost
        if (!$this->isAddOrEdit() && $this->Aquistion_Cost->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Aquistion_Cost->AdvancedSearch->SearchValue != "" || $this->Aquistion_Cost->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Additional_Cost
        if (!$this->isAddOrEdit() && $this->Additional_Cost->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Additional_Cost->AdvancedSearch->SearchValue != "" || $this->Additional_Cost->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Revaluation_Cost
        if (!$this->isAddOrEdit() && $this->Revaluation_Cost->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Revaluation_Cost->AdvancedSearch->SearchValue != "" || $this->Revaluation_Cost->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Remarks
        if (!$this->isAddOrEdit() && $this->Remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Remarks->AdvancedSearch->SearchValue != "" || $this->Remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Created_By
        if (!$this->isAddOrEdit() && $this->Created_By->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Created_By->AdvancedSearch->SearchValue != "" || $this->Created_By->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Created_on
        if (!$this->isAddOrEdit() && $this->Created_on->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Created_on->AdvancedSearch->SearchValue != "" || $this->Created_on->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $stmt = $sql->execute();
        $rs = new Recordset($stmt, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->Assetlogid->setDbValue($row['Assetlogid']);
        $this->Asset_id->setDbValue($row['Asset_id']);
        $this->Asset_No->setDbValue($row['Asset_No']);
        $this->Details_of_Asset->setDbValue($row['Details_of_Asset']);
        $this->Asset_Status->setDbValue($row['Asset_Status']);
        $this->Condition_Of_Asset->setDbValue($row['Condition_Of_Asset']);
        $this->Location_id->setDbValue($row['Location_id']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Category->setDbValue($row['Category']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Make->setDbValue($row['Make']);
        $this->Model->setDbValue($row['Model']);
        $this->YearofManufacture->setDbValue($row['Year of Manufacture']);
        $this->Colour->setDbValue($row['Colour']);
        $this->EngineNumber->setDbValue($row['Engine Number']);
        $this->ChasisNumber->setDbValue($row['Chasis Number']);
        $this->CivilianPlateNumber->setDbValue($row['Civilian Plate Number']);
        $this->GovtPlateNumber->setDbValue($row['Govt Plate Number']);
        $this->Custodian_id->setDbValue($row['Custodian_id']);
        $this->Date_of_Acquisition->setDbValue($row['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($row['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($row['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($row['Revaluation_Cost']);
        $this->Remarks->setDbValue($row['Remarks']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Created_on->setDbValue($row['Created_on']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['Assetlogid'] = null;
        $row['Asset_id'] = null;
        $row['Asset_No'] = null;
        $row['Details_of_Asset'] = null;
        $row['Asset_Status'] = null;
        $row['Condition_Of_Asset'] = null;
        $row['Location_id'] = null;
        $row['MDA_id'] = null;
        $row['Category'] = null;
        $row['Category_Details'] = null;
        $row['Make'] = null;
        $row['Model'] = null;
        $row['Year of Manufacture'] = null;
        $row['Colour'] = null;
        $row['Engine Number'] = null;
        $row['Chasis Number'] = null;
        $row['Civilian Plate Number'] = null;
        $row['Govt Plate Number'] = null;
        $row['Custodian_id'] = null;
        $row['Date_of_Acquisition'] = null;
        $row['Aquistion_Cost'] = null;
        $row['Additional_Cost'] = null;
        $row['Revaluation_Cost'] = null;
        $row['Remarks'] = null;
        $row['Created_By'] = null;
        $row['Created_on'] = null;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Convert decimal values if posted back
        if ($this->Aquistion_Cost->FormValue == $this->Aquistion_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Aquistion_Cost->CurrentValue))) {
            $this->Aquistion_Cost->CurrentValue = ConvertToFloatString($this->Aquistion_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Additional_Cost->FormValue == $this->Additional_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Additional_Cost->CurrentValue))) {
            $this->Additional_Cost->CurrentValue = ConvertToFloatString($this->Additional_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Revaluation_Cost->FormValue == $this->Revaluation_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Revaluation_Cost->CurrentValue))) {
            $this->Revaluation_Cost->CurrentValue = ConvertToFloatString($this->Revaluation_Cost->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Assetlogid

        // Asset_id

        // Asset_No

        // Details_of_Asset

        // Asset_Status

        // Condition_Of_Asset

        // Location_id

        // MDA_id

        // Category

        // Category_Details

        // Make

        // Model

        // Year of Manufacture

        // Colour

        // Engine Number

        // Chasis Number

        // Civilian Plate Number

        // Govt Plate Number

        // Custodian_id

        // Date_of_Acquisition

        // Aquistion_Cost

        // Additional_Cost

        // Revaluation_Cost

        // Remarks

        // Created_By

        // Created_on
        if ($this->RowType == ROWTYPE_VIEW) {
            // Assetlogid
            $this->Assetlogid->ViewValue = $this->Assetlogid->CurrentValue;
            $this->Assetlogid->ViewCustomAttributes = "";

            // Asset_id
            $this->Asset_id->ViewValue = $this->Asset_id->CurrentValue;
            $this->Asset_id->ViewValue = FormatNumber($this->Asset_id->ViewValue, 0, -2, -2, -2);
            $this->Asset_id->ViewCustomAttributes = "";

            // Asset_No
            $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
            $this->Asset_No->ViewCustomAttributes = "";

            // Details_of_Asset
            $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Asset_Status
            $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
            $this->Asset_Status->ViewCustomAttributes = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
            $this->Condition_Of_Asset->ViewCustomAttributes = "";

            // Location_id
            $curVal = trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->ViewValue = null;
            }
            $this->Location_id->ViewCustomAttributes = "";

            // MDA_id
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->ViewValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";

            // Category
            $curVal = trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Category->Lookup->renderViewRow($row);
                            $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                        }
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }
            $this->Category->ViewCustomAttributes = "";

            // Category_Details
            $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
            $this->Category_Details->ViewCustomAttributes = "";

            // Make
            $this->Make->ViewValue = $this->Make->CurrentValue;
            $this->Make->ViewCustomAttributes = "";

            // Model
            $this->Model->ViewValue = $this->Model->CurrentValue;
            $this->Model->ViewCustomAttributes = "";

            // Year of Manufacture
            $this->YearofManufacture->ViewValue = $this->YearofManufacture->CurrentValue;
            $this->YearofManufacture->ViewValue = FormatNumber($this->YearofManufacture->ViewValue, 0, -2, -2, -2);
            $this->YearofManufacture->ViewCustomAttributes = "";

            // Colour
            $this->Colour->ViewValue = $this->Colour->CurrentValue;
            $this->Colour->ViewCustomAttributes = "";

            // Engine Number
            $this->EngineNumber->ViewValue = $this->EngineNumber->CurrentValue;
            $this->EngineNumber->ViewCustomAttributes = "";

            // Chasis Number
            $this->ChasisNumber->ViewValue = $this->ChasisNumber->CurrentValue;
            $this->ChasisNumber->ViewCustomAttributes = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->ViewValue = $this->CivilianPlateNumber->CurrentValue;
            $this->CivilianPlateNumber->ViewCustomAttributes = "";

            // Govt Plate Number
            $this->GovtPlateNumber->ViewValue = $this->GovtPlateNumber->CurrentValue;
            $this->GovtPlateNumber->ViewCustomAttributes = "";

            // Custodian_id
            $curVal = trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
                if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                    } else {
                        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                    }
                }
            } else {
                $this->Custodian_id->ViewValue = null;
            }
            $this->Custodian_id->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // Created_By
            $curVal = trim(strval($this->Created_By->CurrentValue));
            if ($curVal != "") {
                $this->Created_By->ViewValue = $this->Created_By->lookupCacheOption($curVal);
                if ($this->Created_By->ViewValue === null) { // Lookup from database
                    $filterWrk = "`userid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Created_By->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Created_By->Lookup->renderViewRow($rswrk[0]);
                        $this->Created_By->ViewValue = $this->Created_By->displayValue($arwrk);
                    } else {
                        $this->Created_By->ViewValue = $this->Created_By->CurrentValue;
                    }
                }
            } else {
                $this->Created_By->ViewValue = null;
            }
            $this->Created_By->ViewCustomAttributes = "";

            // Created_on
            $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
            $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 111);
            $this->Created_on->ViewCustomAttributes = "";

            // Asset_id
            $this->Asset_id->LinkCustomAttributes = "";
            $this->Asset_id->HrefValue = "";
            $this->Asset_id->TooltipValue = "";

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";
            $this->Asset_No->TooltipValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";
            $this->Asset_Status->TooltipValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";
            $this->Condition_Of_Asset->TooltipValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Make
            $this->Make->LinkCustomAttributes = "";
            $this->Make->HrefValue = "";
            $this->Make->TooltipValue = "";

            // Model
            $this->Model->LinkCustomAttributes = "";
            $this->Model->HrefValue = "";
            $this->Model->TooltipValue = "";

            // Year of Manufacture
            $this->YearofManufacture->LinkCustomAttributes = "";
            $this->YearofManufacture->HrefValue = "";
            $this->YearofManufacture->TooltipValue = "";

            // Colour
            $this->Colour->LinkCustomAttributes = "";
            $this->Colour->HrefValue = "";
            $this->Colour->TooltipValue = "";

            // Engine Number
            $this->EngineNumber->LinkCustomAttributes = "";
            $this->EngineNumber->HrefValue = "";
            $this->EngineNumber->TooltipValue = "";

            // Chasis Number
            $this->ChasisNumber->LinkCustomAttributes = "";
            $this->ChasisNumber->HrefValue = "";
            $this->ChasisNumber->TooltipValue = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->LinkCustomAttributes = "";
            $this->CivilianPlateNumber->HrefValue = "";
            $this->CivilianPlateNumber->TooltipValue = "";

            // Govt Plate Number
            $this->GovtPlateNumber->LinkCustomAttributes = "";
            $this->GovtPlateNumber->HrefValue = "";
            $this->GovtPlateNumber->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";
            $this->Custodian_id->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";

            // Created_By
            $this->Created_By->LinkCustomAttributes = "";
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
            $this->Created_on->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // Asset_id
            $this->Asset_id->EditAttrs["class"] = "form-control";
            $this->Asset_id->EditCustomAttributes = "";
            $this->Asset_id->EditValue = HtmlEncode($this->Asset_id->AdvancedSearch->SearchValue);
            $this->Asset_id->PlaceHolder = RemoveHtml($this->Asset_id->caption());

            // Asset_No
            $this->Asset_No->EditAttrs["class"] = "form-control";
            $this->Asset_No->EditCustomAttributes = "";
            if (!$this->Asset_No->Raw) {
                $this->Asset_No->AdvancedSearch->SearchValue = HtmlDecode($this->Asset_No->AdvancedSearch->SearchValue);
            }
            $this->Asset_No->EditValue = HtmlEncode($this->Asset_No->AdvancedSearch->SearchValue);
            $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

            // Details_of_Asset
            $this->Details_of_Asset->EditAttrs["class"] = "form-control";
            $this->Details_of_Asset->EditCustomAttributes = "";
            if (!$this->Details_of_Asset->Raw) {
                $this->Details_of_Asset->AdvancedSearch->SearchValue = HtmlDecode($this->Details_of_Asset->AdvancedSearch->SearchValue);
            }
            $this->Details_of_Asset->EditValue = HtmlEncode($this->Details_of_Asset->AdvancedSearch->SearchValue);
            $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            if (!$this->Asset_Status->Raw) {
                $this->Asset_Status->AdvancedSearch->SearchValue = HtmlDecode($this->Asset_Status->AdvancedSearch->SearchValue);
            }
            $this->Asset_Status->EditValue = HtmlEncode($this->Asset_Status->AdvancedSearch->SearchValue);
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            if (!$this->Condition_Of_Asset->Raw) {
                $this->Condition_Of_Asset->AdvancedSearch->SearchValue = HtmlDecode($this->Condition_Of_Asset->AdvancedSearch->SearchValue);
            }
            $this->Condition_Of_Asset->EditValue = HtmlEncode($this->Condition_Of_Asset->AdvancedSearch->SearchValue);
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());

            // Category
            $this->Category->EditCustomAttributes = "";
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            if (!$this->Category_Details->Raw) {
                $this->Category_Details->AdvancedSearch->SearchValue = HtmlDecode($this->Category_Details->AdvancedSearch->SearchValue);
            }
            $this->Category_Details->EditValue = HtmlEncode($this->Category_Details->AdvancedSearch->SearchValue);
            $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

            // Make
            $this->Make->EditAttrs["class"] = "form-control";
            $this->Make->EditCustomAttributes = "";
            if (!$this->Make->Raw) {
                $this->Make->AdvancedSearch->SearchValue = HtmlDecode($this->Make->AdvancedSearch->SearchValue);
            }
            $this->Make->EditValue = HtmlEncode($this->Make->AdvancedSearch->SearchValue);
            $this->Make->PlaceHolder = RemoveHtml($this->Make->caption());

            // Model
            $this->Model->EditAttrs["class"] = "form-control";
            $this->Model->EditCustomAttributes = "";
            if (!$this->Model->Raw) {
                $this->Model->AdvancedSearch->SearchValue = HtmlDecode($this->Model->AdvancedSearch->SearchValue);
            }
            $this->Model->EditValue = HtmlEncode($this->Model->AdvancedSearch->SearchValue);
            $this->Model->PlaceHolder = RemoveHtml($this->Model->caption());

            // Year of Manufacture
            $this->YearofManufacture->EditAttrs["class"] = "form-control";
            $this->YearofManufacture->EditCustomAttributes = "";
            $this->YearofManufacture->EditValue = HtmlEncode($this->YearofManufacture->AdvancedSearch->SearchValue);
            $this->YearofManufacture->PlaceHolder = RemoveHtml($this->YearofManufacture->caption());

            // Colour
            $this->Colour->EditAttrs["class"] = "form-control";
            $this->Colour->EditCustomAttributes = "";
            if (!$this->Colour->Raw) {
                $this->Colour->AdvancedSearch->SearchValue = HtmlDecode($this->Colour->AdvancedSearch->SearchValue);
            }
            $this->Colour->EditValue = HtmlEncode($this->Colour->AdvancedSearch->SearchValue);
            $this->Colour->PlaceHolder = RemoveHtml($this->Colour->caption());

            // Engine Number
            $this->EngineNumber->EditAttrs["class"] = "form-control";
            $this->EngineNumber->EditCustomAttributes = "";
            if (!$this->EngineNumber->Raw) {
                $this->EngineNumber->AdvancedSearch->SearchValue = HtmlDecode($this->EngineNumber->AdvancedSearch->SearchValue);
            }
            $this->EngineNumber->EditValue = HtmlEncode($this->EngineNumber->AdvancedSearch->SearchValue);
            $this->EngineNumber->PlaceHolder = RemoveHtml($this->EngineNumber->caption());

            // Chasis Number
            $this->ChasisNumber->EditAttrs["class"] = "form-control";
            $this->ChasisNumber->EditCustomAttributes = "";
            if (!$this->ChasisNumber->Raw) {
                $this->ChasisNumber->AdvancedSearch->SearchValue = HtmlDecode($this->ChasisNumber->AdvancedSearch->SearchValue);
            }
            $this->ChasisNumber->EditValue = HtmlEncode($this->ChasisNumber->AdvancedSearch->SearchValue);
            $this->ChasisNumber->PlaceHolder = RemoveHtml($this->ChasisNumber->caption());

            // Civilian Plate Number
            $this->CivilianPlateNumber->EditAttrs["class"] = "form-control";
            $this->CivilianPlateNumber->EditCustomAttributes = "";
            if (!$this->CivilianPlateNumber->Raw) {
                $this->CivilianPlateNumber->AdvancedSearch->SearchValue = HtmlDecode($this->CivilianPlateNumber->AdvancedSearch->SearchValue);
            }
            $this->CivilianPlateNumber->EditValue = HtmlEncode($this->CivilianPlateNumber->AdvancedSearch->SearchValue);
            $this->CivilianPlateNumber->PlaceHolder = RemoveHtml($this->CivilianPlateNumber->caption());

            // Govt Plate Number
            $this->GovtPlateNumber->EditAttrs["class"] = "form-control";
            $this->GovtPlateNumber->EditCustomAttributes = "";
            if (!$this->GovtPlateNumber->Raw) {
                $this->GovtPlateNumber->AdvancedSearch->SearchValue = HtmlDecode($this->GovtPlateNumber->AdvancedSearch->SearchValue);
            }
            $this->GovtPlateNumber->EditValue = HtmlEncode($this->GovtPlateNumber->AdvancedSearch->SearchValue);
            $this->GovtPlateNumber->PlaceHolder = RemoveHtml($this->GovtPlateNumber->caption());

            // Custodian_id
            $this->Custodian_id->EditAttrs["class"] = "form-control";
            $this->Custodian_id->EditCustomAttributes = "";
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Date_of_Acquisition->AdvancedSearch->SearchValue, 0), 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = HtmlEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());

            // Additional_Cost
            $this->Additional_Cost->EditAttrs["class"] = "form-control";
            $this->Additional_Cost->EditCustomAttributes = "";
            $this->Additional_Cost->EditValue = HtmlEncode($this->Additional_Cost->AdvancedSearch->SearchValue);
            $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());

            // Revaluation_Cost
            $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
            $this->Revaluation_Cost->EditCustomAttributes = "";
            $this->Revaluation_Cost->EditValue = HtmlEncode($this->Revaluation_Cost->AdvancedSearch->SearchValue);
            $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());

            // Created_By
            $this->Created_By->EditAttrs["class"] = "form-control";
            $this->Created_By->EditCustomAttributes = "";
            $this->Created_By->PlaceHolder = RemoveHtml($this->Created_By->caption());

            // Created_on
            $this->Created_on->EditAttrs["class"] = "form-control";
            $this->Created_on->EditCustomAttributes = "";
            $this->Created_on->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Created_on->AdvancedSearch->SearchValue, 111), 111));
            $this->Created_on->PlaceHolder = RemoveHtml($this->Created_on->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->Asset_id->AdvancedSearch->SearchValue)) {
            $this->Asset_id->addErrorMessage($this->Asset_id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->Assetlogid->AdvancedSearch->load();
        $this->Asset_id->AdvancedSearch->load();
        $this->Asset_No->AdvancedSearch->load();
        $this->Details_of_Asset->AdvancedSearch->load();
        $this->Asset_Status->AdvancedSearch->load();
        $this->Condition_Of_Asset->AdvancedSearch->load();
        $this->Location_id->AdvancedSearch->load();
        $this->MDA_id->AdvancedSearch->load();
        $this->Category->AdvancedSearch->load();
        $this->Category_Details->AdvancedSearch->load();
        $this->Make->AdvancedSearch->load();
        $this->Model->AdvancedSearch->load();
        $this->YearofManufacture->AdvancedSearch->load();
        $this->Colour->AdvancedSearch->load();
        $this->EngineNumber->AdvancedSearch->load();
        $this->ChasisNumber->AdvancedSearch->load();
        $this->CivilianPlateNumber->AdvancedSearch->load();
        $this->GovtPlateNumber->AdvancedSearch->load();
        $this->Custodian_id->AdvancedSearch->load();
        $this->Date_of_Acquisition->AdvancedSearch->load();
        $this->Aquistion_Cost->AdvancedSearch->load();
        $this->Additional_Cost->AdvancedSearch->load();
        $this->Revaluation_Cost->AdvancedSearch->load();
        $this->Remarks->AdvancedSearch->load();
        $this->Created_By->AdvancedSearch->load();
        $this->Created_on->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        $pageUrl = $this->pageUrl();
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.fassetsaudittrailtbllist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
            } else {
                return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.fassetsaudittrailtbllist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
            } else {
                return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.fassetsaudittrailtbllist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
            } else {
                return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ",url:'" . $pageUrl . "export=email&amp;custom=1'" : "";
            return '<button id="emf_assetsaudittrailtbl" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_assetsaudittrailtbl\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.fassetsaudittrailtbllist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to Html
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = true;

        // Export to Xml
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to Csv
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to Pdf
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl();
        $this->SearchOptions = new ListOptions("div");
        $this->SearchOptions->TagClassName = "ew-search-option";

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fassetsaudittrailtbllistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($return = false)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $this->TotalRecords = $this->listRecordCount();
        $this->StartRecord = 1;

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        $this->ExportDoc = GetExportDocument($this, "h");
        $doc = &$this->ExportDoc;
        if (!$doc) {
            $this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
        }
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $this->ExportDoc->ExportCustom = !$this->pageExporting();
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Close recordset
        $rs->close();

        // Call Page Exported server event
        $this->pageExported();

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Clean output buffer (without destroying output buffer)
        $buffer = ob_get_contents(); // Save the output buffer
        if (!Config("DEBUG") && $buffer) {
            ob_clean();
        }

        // Write debug message if enabled
        if (Config("DEBUG") && !$this->isExport("pdf")) {
            echo GetDebugMessage();
        }

        // Output data
        if ($this->isExport("email")) {
            // Export-to-email disabled
        } else {
            $doc->export();
            if ($return) {
                RemoveHeader("Content-Type"); // Remove header
                RemoveHeader("Content-Disposition");
                $content = ob_get_contents();
                if ($content) {
                    ob_clean();
                }
                if ($buffer) {
                    echo $buffer; // Resume the output buffer
                }
                return $content;
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Location_id":
                    break;
                case "x_MDA_id":
                    break;
                case "x_Category":
                    break;
                case "x_Custodian_id":
                    break;
                case "x_Created_By":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Get the current assetid from url
           $vintoassetidaudit=$_GET['x_Asset_id'];

            //echo  $vintoassetidaudit;
            $myaudittrailassetidField = ExecuteScalar("SELECT Asset_id FROM assetsaudittrailtbl WHERE Asset_id='$vintoassetidaudit'");
            $myassetid = ExecuteScalar("SELECT Assetsid FROM assetstbl WHERE Assetsid ='$vintoassetidaudit'");
    if ($myaudittrailassetidField !=$myassetid){
        echo'
        <link rel="stylesheet" href="/ekassets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="/ekassets/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
    <link rel="stylesheet" href="/ekassets/adminlte3/css/adminlte.css">
    <link rel="stylesheet" href="/ekassets/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="/ekassets/css/OverlayScrollbars.min.css">
    <link rel="stylesheet" href="/ekassets/css/ekitiassetsvintoict.css">
    <link rel="shortcut icon" type="image/x-icon" href="/ekassets/logo.ico">
    <link rel="icon" type="image/x-icon" href="/ekassets/logo.ico">
        <div class="card-body">
        <div class="alert alert-primary" role="alert">
      <h4 class="alert-heading">Audit Trail</h4>
      <p>No record found ! The selected Asset currently have no Audit Trail Information. <a class="btn btn-primary btn-sm" onclick="window.history.go(-1); return false;" role="button"><b>Edit Asset !</b></a></p>
      <hr>
      <p class="mb-0">All activities on this Asset will be logged if any changes are made.
       </p>
    </div>
        </div>
        ';
        exit();
    }
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
        echo "<script type='text/javascript'> document.location = 'assetsaudittrailtblview'; </script>";
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $this->ExportDoc = export document object
    public function pageExporting()
    {
        //$this->ExportDoc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $this->ExportDoc = export document object
    public function rowExport($rs)
    {
        //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $this->ExportDoc = export document object
    public function pageExported()
    {
        //$this->ExportDoc->Text .= "my footer"; // Export footer
        //Log($this->ExportDoc->Text);
    }

    // Page Importing event
    public function pageImporting($reader, &$options)
    {
        //var_dump($reader); // Import data reader
        //var_dump($options); // Show all options for importing
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($reader, $results)
    {
        //var_dump($reader); // Import data reader
        //var_dump($results); // Import results
    }
}
