<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class VerifyassettblAdd extends Verifyassettbl
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'verifyassettbl';

    // Page object name
    public $PageObjName = "VerifyassettblAdd";

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (verifyassettbl)
        if (!isset($GLOBALS["verifyassettbl"]) || get_class($GLOBALS["verifyassettbl"]) == PROJECT_NAMESPACE . "verifyassettbl") {
            $GLOBALS["verifyassettbl"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'verifyassettbl');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("verifyassettbl"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "verifyassettblview") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['verifyassetid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->verifyassetid->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $OldRecordset;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->verifyassetid->Visible = false;
        $this->asset_id->setVisibility();
        $this->reassignerid->setVisibility();
        $this->reciverid->setVisibility();
        $this->MDA_id->setVisibility();
        $this->Created_on->setVisibility();
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-add-form ew-horizontal";
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("verifyassetid") ?? Route("verifyassetid")) !== null) {
                $this->verifyassetid->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record / default values
        $loaded = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$loaded) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("verifyassettbllist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($this->OldRecordset)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "verifyassettbllist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "verifyassettblview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->verifyassetid->CurrentValue = null;
        $this->verifyassetid->OldValue = $this->verifyassetid->CurrentValue;
        $this->asset_id->CurrentValue = null;
        $this->asset_id->OldValue = $this->asset_id->CurrentValue;
        $this->reassignerid->CurrentValue = null;
        $this->reassignerid->OldValue = $this->reassignerid->CurrentValue;
        $this->reciverid->CurrentValue = null;
        $this->reciverid->OldValue = $this->reciverid->CurrentValue;
        $this->MDA_id->CurrentValue = CurrentUserID();
        $this->Created_on->CurrentValue = null;
        $this->Created_on->OldValue = $this->Created_on->CurrentValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'asset_id' first before field var 'x_asset_id'
        $val = $CurrentForm->hasValue("asset_id") ? $CurrentForm->getValue("asset_id") : $CurrentForm->getValue("x_asset_id");
        if (!$this->asset_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->asset_id->Visible = false; // Disable update for API request
            } else {
                $this->asset_id->setFormValue($val);
            }
        }

        // Check field name 'reassignerid' first before field var 'x_reassignerid'
        $val = $CurrentForm->hasValue("reassignerid") ? $CurrentForm->getValue("reassignerid") : $CurrentForm->getValue("x_reassignerid");
        if (!$this->reassignerid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reassignerid->Visible = false; // Disable update for API request
            } else {
                $this->reassignerid->setFormValue($val);
            }
        }

        // Check field name 'reciverid' first before field var 'x_reciverid'
        $val = $CurrentForm->hasValue("reciverid") ? $CurrentForm->getValue("reciverid") : $CurrentForm->getValue("x_reciverid");
        if (!$this->reciverid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reciverid->Visible = false; // Disable update for API request
            } else {
                $this->reciverid->setFormValue($val);
            }
        }

        // Check field name 'MDA_id' first before field var 'x_MDA_id'
        $val = $CurrentForm->hasValue("MDA_id") ? $CurrentForm->getValue("MDA_id") : $CurrentForm->getValue("x_MDA_id");
        if (!$this->MDA_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MDA_id->Visible = false; // Disable update for API request
            } else {
                $this->MDA_id->setFormValue($val);
            }
        }

        // Check field name 'Created_on' first before field var 'x_Created_on'
        $val = $CurrentForm->hasValue("Created_on") ? $CurrentForm->getValue("Created_on") : $CurrentForm->getValue("x_Created_on");
        if (!$this->Created_on->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_on->Visible = false; // Disable update for API request
            } else {
                $this->Created_on->setFormValue($val);
            }
            $this->Created_on->CurrentValue = UnFormatDateTime($this->Created_on->CurrentValue, 0);
        }

        // Check field name 'verifyassetid' first before field var 'x_verifyassetid'
        $val = $CurrentForm->hasValue("verifyassetid") ? $CurrentForm->getValue("verifyassetid") : $CurrentForm->getValue("x_verifyassetid");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->asset_id->CurrentValue = $this->asset_id->FormValue;
        $this->reassignerid->CurrentValue = $this->reassignerid->FormValue;
        $this->reciverid->CurrentValue = $this->reciverid->FormValue;
        $this->MDA_id->CurrentValue = $this->MDA_id->FormValue;
        $this->Created_on->CurrentValue = $this->Created_on->FormValue;
        $this->Created_on->CurrentValue = UnFormatDateTime($this->Created_on->CurrentValue, 0);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->verifyassetid->setDbValue($row['verifyassetid']);
        $this->asset_id->setDbValue($row['asset_id']);
        $this->reassignerid->setDbValue($row['reassignerid']);
        $this->reciverid->setDbValue($row['reciverid']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Created_on->setDbValue($row['Created_on']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['verifyassetid'] = $this->verifyassetid->CurrentValue;
        $row['asset_id'] = $this->asset_id->CurrentValue;
        $row['reassignerid'] = $this->reassignerid->CurrentValue;
        $row['reciverid'] = $this->reciverid->CurrentValue;
        $row['MDA_id'] = $this->MDA_id->CurrentValue;
        $row['Created_on'] = $this->Created_on->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // verifyassetid

        // asset_id

        // reassignerid

        // reciverid

        // MDA_id

        // Created_on
        if ($this->RowType == ROWTYPE_VIEW) {
            // verifyassetid
            $this->verifyassetid->ViewValue = $this->verifyassetid->CurrentValue;
            $this->verifyassetid->ViewCustomAttributes = "";

            // asset_id
            $this->asset_id->ViewValue = $this->asset_id->CurrentValue;
            $this->asset_id->ViewValue = FormatNumber($this->asset_id->ViewValue, 0, -2, -2, -2);
            $this->asset_id->ViewCustomAttributes = "";

            // reassignerid
            $this->reassignerid->ViewValue = $this->reassignerid->CurrentValue;
            $this->reassignerid->ViewValue = FormatNumber($this->reassignerid->ViewValue, 0, -2, -2, -2);
            $this->reassignerid->ViewCustomAttributes = "";

            // reciverid
            $this->reciverid->ViewValue = $this->reciverid->CurrentValue;
            $this->reciverid->ViewValue = FormatNumber($this->reciverid->ViewValue, 0, -2, -2, -2);
            $this->reciverid->ViewCustomAttributes = "";

            // MDA_id
            $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
            $this->MDA_id->ViewValue = FormatNumber($this->MDA_id->ViewValue, 0, -2, -2, -2);
            $this->MDA_id->ViewCustomAttributes = "";

            // Created_on
            $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
            $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
            $this->Created_on->ViewCustomAttributes = "";

            // asset_id
            $this->asset_id->LinkCustomAttributes = "";
            $this->asset_id->HrefValue = "";
            $this->asset_id->TooltipValue = "";

            // reassignerid
            $this->reassignerid->LinkCustomAttributes = "";
            $this->reassignerid->HrefValue = "";
            $this->reassignerid->TooltipValue = "";

            // reciverid
            $this->reciverid->LinkCustomAttributes = "";
            $this->reciverid->HrefValue = "";
            $this->reciverid->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
            $this->Created_on->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // asset_id
            $this->asset_id->EditAttrs["class"] = "form-control";
            $this->asset_id->EditCustomAttributes = "";
            $this->asset_id->EditValue = HtmlEncode($this->asset_id->CurrentValue);
            $this->asset_id->PlaceHolder = RemoveHtml($this->asset_id->caption());

            // reassignerid
            $this->reassignerid->EditAttrs["class"] = "form-control";
            $this->reassignerid->EditCustomAttributes = "";
            $this->reassignerid->EditValue = HtmlEncode($this->reassignerid->CurrentValue);
            $this->reassignerid->PlaceHolder = RemoveHtml($this->reassignerid->caption());

            // reciverid
            $this->reciverid->EditAttrs["class"] = "form-control";
            $this->reciverid->EditCustomAttributes = "";
            $this->reciverid->EditValue = HtmlEncode($this->reciverid->CurrentValue);
            $this->reciverid->PlaceHolder = RemoveHtml($this->reciverid->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("add")) { // Non system admin
                $this->MDA_id->CurrentValue = CurrentUserID();
                $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                $this->MDA_id->EditValue = FormatNumber($this->MDA_id->EditValue, 0, -2, -2, -2);
                $this->MDA_id->ViewCustomAttributes = "";
            } else {
                $this->MDA_id->EditValue = HtmlEncode($this->MDA_id->CurrentValue);
                $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
            }

            // Created_on
            $this->Created_on->EditAttrs["class"] = "form-control";
            $this->Created_on->EditCustomAttributes = "";
            $this->Created_on->EditValue = HtmlEncode(FormatDateTime($this->Created_on->CurrentValue, 8));
            $this->Created_on->PlaceHolder = RemoveHtml($this->Created_on->caption());

            // Add refer script

            // asset_id
            $this->asset_id->LinkCustomAttributes = "";
            $this->asset_id->HrefValue = "";

            // reassignerid
            $this->reassignerid->LinkCustomAttributes = "";
            $this->reassignerid->HrefValue = "";

            // reciverid
            $this->reciverid->LinkCustomAttributes = "";
            $this->reciverid->HrefValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->asset_id->Required) {
            if (!$this->asset_id->IsDetailKey && EmptyValue($this->asset_id->FormValue)) {
                $this->asset_id->addErrorMessage(str_replace("%s", $this->asset_id->caption(), $this->asset_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->asset_id->FormValue)) {
            $this->asset_id->addErrorMessage($this->asset_id->getErrorMessage(false));
        }
        if ($this->reassignerid->Required) {
            if (!$this->reassignerid->IsDetailKey && EmptyValue($this->reassignerid->FormValue)) {
                $this->reassignerid->addErrorMessage(str_replace("%s", $this->reassignerid->caption(), $this->reassignerid->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->reassignerid->FormValue)) {
            $this->reassignerid->addErrorMessage($this->reassignerid->getErrorMessage(false));
        }
        if ($this->reciverid->Required) {
            if (!$this->reciverid->IsDetailKey && EmptyValue($this->reciverid->FormValue)) {
                $this->reciverid->addErrorMessage(str_replace("%s", $this->reciverid->caption(), $this->reciverid->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->reciverid->FormValue)) {
            $this->reciverid->addErrorMessage($this->reciverid->getErrorMessage(false));
        }
        if ($this->MDA_id->Required) {
            if (!$this->MDA_id->IsDetailKey && EmptyValue($this->MDA_id->FormValue)) {
                $this->MDA_id->addErrorMessage(str_replace("%s", $this->MDA_id->caption(), $this->MDA_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->MDA_id->FormValue)) {
            $this->MDA_id->addErrorMessage($this->MDA_id->getErrorMessage(false));
        }
        if ($this->Created_on->Required) {
            if (!$this->Created_on->IsDetailKey && EmptyValue($this->Created_on->FormValue)) {
                $this->Created_on->addErrorMessage(str_replace("%s", $this->Created_on->caption(), $this->Created_on->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->Created_on->FormValue)) {
            $this->Created_on->addErrorMessage($this->Created_on->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Check if valid User ID
        $validUser = false;
        if ($Security->currentUserID() != "" && !EmptyValue($this->MDA_id->CurrentValue) && !$Security->isAdmin()) { // Non system admin
            $validUser = $Security->isValidUserID($this->MDA_id->CurrentValue);
            if (!$validUser) {
                $userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
                $userIdMsg = str_replace("%u", $this->MDA_id->CurrentValue, $userIdMsg);
                $this->setFailureMessage($userIdMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // asset_id
        $this->asset_id->setDbValueDef($rsnew, $this->asset_id->CurrentValue, 0, false);

        // reassignerid
        $this->reassignerid->setDbValueDef($rsnew, $this->reassignerid->CurrentValue, 0, false);

        // reciverid
        $this->reciverid->setDbValueDef($rsnew, $this->reciverid->CurrentValue, 0, false);

        // MDA_id
        $this->MDA_id->setDbValueDef($rsnew, $this->MDA_id->CurrentValue, 0, false);

        // Created_on
        $this->Created_on->setDbValueDef($rsnew, UnFormatDateTime($this->Created_on->CurrentValue, 0), null, false);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        $addRow = false;
        if ($insertRow) {
            try {
                $addRow = $this->insert($rsnew);
            } catch (\Exception $e) {
                $this->setFailureMessage($e->getMessage());
            }
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->MDA_id->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("verifyassettbllist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
