<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

// Page object
$AssetlogSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentForm, currentPageID;
var fsummary, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready("head", function () {
    var $ = jQuery;
    // Form object for search
    fsummary = currentForm = new ew.Form("fsummary", "summary");
    currentPageID = ew.PAGE_ID = "summary";

    // Add fields
    var currentTable = <?= JsonEncode(GetClientVar("tables", "Assetlog")) ?>,
        fields = currentTable.fields;
    fsummary.addFields([
        ["Created_on", [ew.Validators.datetime(11)], fields.Created_on.isInvalid],
        ["y_Created_on", [ew.Validators.between], false],
        ["Asset_id", [], fields.Asset_id.isInvalid],
        ["Asset_No", [], fields.Asset_No.isInvalid],
        ["Details_of_Asset", [], fields.Details_of_Asset.isInvalid],
        ["Asset_Status", [], fields.Asset_Status.isInvalid],
        ["Condition_Of_Asset", [], fields.Condition_Of_Asset.isInvalid],
        ["MDA_id", [], fields.MDA_id.isInvalid],
        ["Location_id", [], fields.Location_id.isInvalid],
        ["Custodian_id", [], fields.Custodian_id.isInvalid],
        ["Category", [], fields.Category.isInvalid],
        ["Category_Details", [], fields.Category_Details.isInvalid],
        ["Date_of_Acquisition", [], fields.Date_of_Acquisition.isInvalid],
        ["Aquistion_Cost", [], fields.Aquistion_Cost.isInvalid],
        ["Additional_Cost", [], fields.Additional_Cost.isInvalid],
        ["Revaluation_Cost", [], fields.Revaluation_Cost.isInvalid],
        ["Remarks", [], fields.Remarks.isInvalid],
        ["Created_By", [], fields.Created_By.isInvalid]
    ]);

    // Set invalid fields
    $(function() {
        fsummary.setInvalid();
    });

    // Validate form
    fsummary.validate = function () {
        if (!this.validateRequired)
            return true; // Ignore validation
        var fobj = this.getForm(),
            $fobj = $(fobj),
            rowIndex = "";
        $fobj.data("rowindex", rowIndex);

        // Validate fields
        if (!this.validateFields(rowIndex))
            return false;

        // Call Form_CustomValidate event
        if (!this.customValidate(fobj)) {
            this.focus();
            return false;
        }
        return true;
    }

    // Form_CustomValidate
    fsummary.customValidate = function(fobj) { // DO NOT CHANGE THIS LINE!
        // Your custom validation code here, return false if invalid.
        return true;
    }

    // Use JavaScript validation or not
    fsummary.validateRequired = <?= Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

    // Dynamic selection lists
    fsummary.lists.MDA_id = <?= $Page->MDA_id->toClientList($Page) ?>;
    fsummary.lists.Location_id = <?= $Page->Location_id->toClientList($Page) ?>;
    fsummary.lists.Created_By = <?= $Page->Created_By->toClientList($Page) ?>;

    // Filters
    fsummary.filterList = <?= $Page->getFilterList() ?>;
    loadjs.done("fsummary");
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<a id="top"></a>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<div class="row">
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Center Container -->
<div id="ew-center" class="<?= $Page->CenterContentClass ?>">
<?php } ?>
<!-- Summary report (begin) -->
<?php if (!$Page->isExport("pdf")) { ?>
<div id="report_summary">
<?php } ?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !$Page->CurrentAction) { ?>
<form name="fsummary" id="fsummary" class="form-inline ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>">
<div id="fsummary-search-panel" class="<?= $Page->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Assetlog">
    <div class="ew-extended-search">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->Created_on->Visible) { // Created_on ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Created_on" class="ew-cell form-group">
        <label for="x_Created_on" class="ew-search-caption ew-label"><?= $Page->Created_on->caption() ?></label>
        <span class="ew-search-operator">
<?= $Language->phrase("BETWEEN") ?>
<input type="hidden" name="z_Created_on" id="z_Created_on" value="BETWEEN">
</span>
        <span id="el_Assetlog_Created_on" class="ew-search-field">
<input type="<?= $Page->Created_on->getInputTextType() ?>" data-table="Assetlog" data-field="x_Created_on" data-format="11" name="x_Created_on" id="x_Created_on" placeholder="<?= HtmlEncode($Page->Created_on->getPlaceHolder()) ?>" value="<?= $Page->Created_on->EditValue ?>"<?= $Page->Created_on->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_on->getErrorMessage() ?></div>
<?php if (!$Page->Created_on->ReadOnly && !$Page->Created_on->Disabled && !isset($Page->Created_on->EditAttrs["readonly"]) && !isset($Page->Created_on->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsummary", "datetimepicker"], function() {
    ew.createDateTimePicker("fsummary", "x_Created_on", {"ignoreReadonly":true,"useCurrent":false,"format":11});
});
</script>
<?php } ?>
</span>
        <span class="ew-search-and"><label><?= $Language->phrase("AND") ?></label></span>
        <span id="el2_Assetlog_Created_on" class="ew-search-field2">
<input type="<?= $Page->Created_on->getInputTextType() ?>" data-table="Assetlog" data-field="x_Created_on" data-format="11" name="y_Created_on" id="y_Created_on" placeholder="<?= HtmlEncode($Page->Created_on->getPlaceHolder()) ?>" value="<?= $Page->Created_on->EditValue2 ?>"<?= $Page->Created_on->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_on->getErrorMessage() ?></div>
<?php if (!$Page->Created_on->ReadOnly && !$Page->Created_on->Disabled && !isset($Page->Created_on->EditAttrs["readonly"]) && !isset($Page->Created_on->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsummary", "datetimepicker"], function() {
    ew.createDateTimePicker("fsummary", "y_Created_on", {"ignoreReadonly":true,"useCurrent":false,"format":11});
});
</script>
<?php } ?>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { // Asset_No ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Asset_No" class="ew-cell form-group">
        <label for="x_Asset_No" class="ew-search-caption ew-label"><?= $Page->Asset_No->caption() ?></label>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Asset_No" id="z_Asset_No" value="=">
</span>
        <span id="el_Assetlog_Asset_No" class="ew-search-field">
<input type="<?= $Page->Asset_No->getInputTextType() ?>" data-table="Assetlog" data-field="x_Asset_No" name="x_Asset_No" id="x_Asset_No" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Asset_No->getPlaceHolder()) ?>" value="<?= $Page->Asset_No->EditValue ?>"<?= $Page->Asset_No->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Asset_No->getErrorMessage() ?></div>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { // MDA_id ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_MDA_id" class="ew-cell form-group">
        <label for="x_MDA_id" class="ew-search-caption ew-label"><?= $Page->MDA_id->caption() ?></label>
        <span id="el_Assetlog_MDA_id" class="ew-search-field">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$Page->userIDAllow("summary")) { // Non system admin ?>
<span<?= $Page->MDA_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->MDA_id->getDisplayValue($Page->MDA_id->EditValue))) ?>"></span>
<input type="hidden" data-table="Assetlog" data-field="x_MDA_id" data-hidden="1" name="x_MDA_id" id="x_MDA_id" value="<?= HtmlEncode($Page->MDA_id->AdvancedSearch->SearchValue) ?>">
<?php } else { ?>
<?php $Page->MDA_id->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x_MDA_id"
        name="x_MDA_id"
        class="form-control ew-select<?= $Page->MDA_id->isInvalidClass() ?>"
        data-select2-id="Assetlog_x_MDA_id"
        data-table="Assetlog"
        data-field="x_MDA_id"
        data-value-separator="<?= $Page->MDA_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MDA_id->getPlaceHolder()) ?>"
        <?= $Page->MDA_id->editAttributes() ?>>
        <?= $Page->MDA_id->selectOptionListHtml("x_MDA_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MDA_id->getErrorMessage() ?></div>
<?= $Page->MDA_id->Lookup->getParamTag($Page, "p_x_MDA_id") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='Assetlog_x_MDA_id']"),
        options = { name: "x_MDA_id", selectId: "Assetlog_x_MDA_id", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.Assetlog.fields.MDA_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Location_id->Visible) { // Location_id ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Location_id" class="ew-cell form-group">
        <label for="x_Location_id" class="ew-search-caption ew-label"><?= $Page->Location_id->caption() ?></label>
        <span id="el_Assetlog_Location_id" class="ew-search-field">
    <select
        id="x_Location_id"
        name="x_Location_id"
        class="form-control ew-select<?= $Page->Location_id->isInvalidClass() ?>"
        data-select2-id="Assetlog_x_Location_id"
        data-table="Assetlog"
        data-field="x_Location_id"
        data-value-separator="<?= $Page->Location_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Location_id->getPlaceHolder()) ?>"
        <?= $Page->Location_id->editAttributes() ?>>
        <?= $Page->Location_id->selectOptionListHtml("x_Location_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Location_id->getErrorMessage() ?></div>
<?= $Page->Location_id->Lookup->getParamTag($Page, "p_x_Location_id") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='Assetlog_x_Location_id']"),
        options = { name: "x_Location_id", selectId: "Assetlog_x_Location_id", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.Assetlog.fields.Location_id.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Created_By" class="ew-cell form-group">
        <label for="x_Created_By" class="ew-search-caption ew-label"><?= $Page->Created_By->caption() ?></label>
        <span id="el_Assetlog_Created_By" class="ew-search-field">
    <select
        id="x_Created_By"
        name="x_Created_By"
        class="form-control ew-select<?= $Page->Created_By->isInvalidClass() ?>"
        data-select2-id="Assetlog_x_Created_By"
        data-table="Assetlog"
        data-field="x_Created_By"
        data-value-separator="<?= $Page->Created_By->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>"
        <?= $Page->Created_By->editAttributes() ?>>
        <?= $Page->Created_By->selectOptionListHtml("x_Created_By") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage() ?></div>
<?= $Page->Created_By->Lookup->getParamTag($Page, "p_x_Created_By") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='Assetlog_x_Created_By']"),
        options = { name: "x_Created_By", selectId: "Assetlog_x_Created_By", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.Assetlog.fields.Created_By.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow > 0) { ?>
</div>
    <?php } ?>
<div id="xsr_<?= $Page->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
    <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
</div>
    </div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php } ?>
<?php
while ($Page->RecordCount < count($Page->DetailRecords) && $Page->RecordCount < $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if (!$Page->isExport("pdf")) { ?>
<div class="<?php if (!$Page->isExport("word") && !$Page->isExport("excel")) { ?>card ew-card <?php } ?>ew-grid"<?= $Page->ReportTableStyle ?>>
<?php } ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0)) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?= CurrentPageUrl(false) ?>">
<?= $Page->Pager->render() ?>
</form>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$Page->isExport("pdf")) { ?>
<!-- Report grid (begin) -->
<div id="gmp_Assetlog" class="<?= ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php } ?>
<table class="<?= $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->Created_on->Visible) { ?>
    <th data-name="Created_on" class="<?= $Page->Created_on->headerCellClass() ?>"><div class="Assetlog_Created_on"><?= $Page->renderSort($Page->Created_on) ?></div></th>
<?php } ?>
<?php if ($Page->Asset_id->Visible) { ?>
    <th data-name="Asset_id" class="<?= $Page->Asset_id->headerCellClass() ?>"><div class="Assetlog_Asset_id"><?= $Page->renderSort($Page->Asset_id) ?></div></th>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { ?>
    <th data-name="Asset_No" class="<?= $Page->Asset_No->headerCellClass() ?>"><div class="Assetlog_Asset_No"><?= $Page->renderSort($Page->Asset_No) ?></div></th>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
    <th data-name="Details_of_Asset" class="<?= $Page->Details_of_Asset->headerCellClass() ?>"><div class="Assetlog_Details_of_Asset"><?= $Page->renderSort($Page->Details_of_Asset) ?></div></th>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
    <th data-name="Asset_Status" class="<?= $Page->Asset_Status->headerCellClass() ?>"><div class="Assetlog_Asset_Status"><?= $Page->renderSort($Page->Asset_Status) ?></div></th>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
    <th data-name="Condition_Of_Asset" class="<?= $Page->Condition_Of_Asset->headerCellClass() ?>"><div class="Assetlog_Condition_Of_Asset"><?= $Page->renderSort($Page->Condition_Of_Asset) ?></div></th>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
    <th data-name="MDA_id" class="<?= $Page->MDA_id->headerCellClass() ?>"><div class="Assetlog_MDA_id"><?= $Page->renderSort($Page->MDA_id) ?></div></th>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
    <th data-name="Location_id" class="<?= $Page->Location_id->headerCellClass() ?>"><div class="Assetlog_Location_id"><?= $Page->renderSort($Page->Location_id) ?></div></th>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
    <th data-name="Custodian_id" class="<?= $Page->Custodian_id->headerCellClass() ?>"><div class="Assetlog_Custodian_id"><?= $Page->renderSort($Page->Custodian_id) ?></div></th>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
    <th data-name="Category" class="<?= $Page->Category->headerCellClass() ?>"><div class="Assetlog_Category"><?= $Page->renderSort($Page->Category) ?></div></th>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
    <th data-name="Category_Details" class="<?= $Page->Category_Details->headerCellClass() ?>"><div class="Assetlog_Category_Details"><?= $Page->renderSort($Page->Category_Details) ?></div></th>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
    <th data-name="Date_of_Acquisition" class="<?= $Page->Date_of_Acquisition->headerCellClass() ?>"><div class="Assetlog_Date_of_Acquisition"><?= $Page->renderSort($Page->Date_of_Acquisition) ?></div></th>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
    <th data-name="Aquistion_Cost" class="<?= $Page->Aquistion_Cost->headerCellClass() ?>"><div class="Assetlog_Aquistion_Cost"><?= $Page->renderSort($Page->Aquistion_Cost) ?></div></th>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
    <th data-name="Additional_Cost" class="<?= $Page->Additional_Cost->headerCellClass() ?>"><div class="Assetlog_Additional_Cost"><?= $Page->renderSort($Page->Additional_Cost) ?></div></th>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
    <th data-name="Revaluation_Cost" class="<?= $Page->Revaluation_Cost->headerCellClass() ?>"><div class="Assetlog_Revaluation_Cost"><?= $Page->renderSort($Page->Revaluation_Cost) ?></div></th>
<?php } ?>
<?php if ($Page->Remarks->Visible) { ?>
    <th data-name="Remarks" class="<?= $Page->Remarks->headerCellClass() ?>"><div class="Assetlog_Remarks"><?= $Page->renderSort($Page->Remarks) ?></div></th>
<?php } ?>
<?php if ($Page->Created_By->Visible) { ?>
    <th data-name="Created_By" class="<?= $Page->Created_By->headerCellClass() ?>"><div class="Assetlog_Created_By"><?= $Page->renderSort($Page->Created_By) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php
    $Page->loadRowValues($Page->DetailRecords[$Page->RecordCount]);
    $Page->RecordCount++;
    $Page->RecordIndex++;
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = ROWTYPE_DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Created_on->Visible) { ?>
        <td data-field="Created_on"<?= $Page->Created_on->cellAttributes() ?>>
<span<?= $Page->Created_on->viewAttributes() ?>>
<?= $Page->Created_on->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Asset_id->Visible) { ?>
        <td data-field="Asset_id"<?= $Page->Asset_id->cellAttributes() ?>>
<span<?= $Page->Asset_id->viewAttributes() ?>>
<?= $Page->Asset_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { ?>
        <td data-field="Asset_No"<?= $Page->Asset_No->cellAttributes() ?>>
<span<?= $Page->Asset_No->viewAttributes() ?>>
<?= $Page->Asset_No->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>>
<span<?= $Page->Details_of_Asset->viewAttributes() ?>>
<?= $Page->Details_of_Asset->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>>
<span<?= $Page->Asset_Status->viewAttributes() ?>>
<?= $Page->Asset_Status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>>
<span<?= $Page->Condition_Of_Asset->viewAttributes() ?>>
<?= $Page->Condition_Of_Asset->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>>
<span<?= $Page->MDA_id->viewAttributes() ?>>
<?= $Page->MDA_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>>
<span<?= $Page->Location_id->viewAttributes() ?>>
<?= $Page->Location_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>>
<span<?= $Page->Custodian_id->viewAttributes() ?>>
<?= $Page->Custodian_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>>
<span<?= $Page->Category->viewAttributes() ?>>
<?= $Page->Category->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>>
<span<?= $Page->Category_Details->viewAttributes() ?>>
<?= $Page->Category_Details->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>>
<span<?= $Page->Date_of_Acquisition->viewAttributes() ?>>
<?= $Page->Date_of_Acquisition->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>>
<span<?= $Page->Aquistion_Cost->viewAttributes() ?>>
<?= $Page->Aquistion_Cost->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>>
<span<?= $Page->Additional_Cost->viewAttributes() ?>>
<?= $Page->Additional_Cost->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>>
<span<?= $Page->Revaluation_Cost->viewAttributes() ?>>
<?= $Page->Revaluation_Cost->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Remarks->Visible) { ?>
        <td data-field="Remarks"<?= $Page->Remarks->cellAttributes() ?>>
<span<?= $Page->Remarks->viewAttributes() ?>>
<?= $Page->Remarks->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Created_By->Visible) { ?>
        <td data-field="Created_By"<?= $Page->Created_By->cellAttributes() ?>>
<span<?= $Page->Created_By->viewAttributes() ?>>
<?= $Page->Created_By->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php if (($Page->StopGroup - $Page->StartGroup + 1) != $Page->TotalGroups) { ?>
<?php
    $Page->resetAttributes();
    $Page->RowType = ROWTYPE_TOTAL;
    $Page->RowTotalType = ROWTOTAL_PAGE;
    $Page->RowTotalSubType = ROWTOTAL_FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-page-summary";
    $Page->renderRow();
?>
<?php if ($Page->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes(); ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptPageSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?= FormatNumber($Page->PageTotalCount, 0); ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate">&nbsp;</td>
<?php } ?>
<?php if ($Page->Created_on->Visible) { ?>
        <td data-field="Created_on"<?= $Page->Created_on->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_id->Visible) { ?>
        <td data-field="Asset_id"<?= $Page->Asset_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { ?>
        <td data-field="Asset_No"<?= $Page->Asset_No->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Aquistion_Cost->viewAttributes() ?>><?= $Page->Aquistion_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Additional_Cost->viewAttributes() ?>><?= $Page->Additional_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Revaluation_Cost->viewAttributes() ?>><?= $Page->Revaluation_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Remarks->Visible) { ?>
        <td data-field="Remarks"<?= $Page->Remarks->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Created_By->Visible) { ?>
        <td data-field="Created_By"<?= $Page->Created_By->cellAttributes() ?>></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes(); ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptPageSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->PageTotalCount, 0); ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Created_on->Visible) { ?>
        <td data-field="Created_on"<?= $Page->Created_on->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_id->Visible) { ?>
        <td data-field="Asset_id"<?= $Page->Asset_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { ?>
        <td data-field="Asset_No"<?= $Page->Asset_No->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Aquistion_Cost->viewAttributes() ?>>
<?= $Page->Aquistion_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Additional_Cost->viewAttributes() ?>>
<?= $Page->Additional_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Revaluation_Cost->viewAttributes() ?>>
<?= $Page->Revaluation_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Remarks->Visible) { ?>
        <td data-field="Remarks"<?= $Page->Remarks->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Created_By->Visible) { ?>
        <td data-field="Created_By"<?= $Page->Created_By->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
    </tr>
<?php } ?>
<?php } ?>
<?php
    $Page->resetAttributes();
    $Page->RowType = ROWTYPE_TOTAL;
    $Page->RowTotalType = ROWTOTAL_GRAND;
    $Page->RowTotalSubType = ROWTOTAL_FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, 0); ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate">&nbsp;</td>
<?php } ?>
<?php if ($Page->Created_on->Visible) { ?>
        <td data-field="Created_on"<?= $Page->Created_on->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_id->Visible) { ?>
        <td data-field="Asset_id"<?= $Page->Asset_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { ?>
        <td data-field="Asset_No"<?= $Page->Asset_No->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Aquistion_Cost->viewAttributes() ?>><?= $Page->Aquistion_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Additional_Cost->viewAttributes() ?>><?= $Page->Additional_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Revaluation_Cost->viewAttributes() ?>><?= $Page->Revaluation_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Remarks->Visible) { ?>
        <td data-field="Remarks"<?= $Page->Remarks->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Created_By->Visible) { ?>
        <td data-field="Created_By"<?= $Page->Created_By->cellAttributes() ?>></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, 0); ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->Created_on->Visible) { ?>
        <td data-field="Created_on"<?= $Page->Created_on->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_id->Visible) { ?>
        <td data-field="Asset_id"<?= $Page->Asset_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_No->Visible) { ?>
        <td data-field="Asset_No"<?= $Page->Asset_No->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Aquistion_Cost->viewAttributes() ?>>
<?= $Page->Aquistion_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Additional_Cost->viewAttributes() ?>>
<?= $Page->Additional_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Revaluation_Cost->viewAttributes() ?>>
<?= $Page->Revaluation_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Remarks->Visible) { ?>
        <td data-field="Remarks"<?= $Page->Remarks->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Created_By->Visible) { ?>
        <td data-field="Created_By"<?= $Page->Created_By->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
<?php if (!$Page->isExport("pdf")) { ?>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php } ?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0)) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?= CurrentPageUrl(false) ?>">
<?= $Page->Pager->render() ?>
</form>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php } ?>
<?php if (!$Page->isExport("pdf")) { ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
<?php } ?>
<?php if (!$Page->isExport("pdf")) { ?>
</div>
<!-- /#report-summary -->
<?php } ?>
<!-- Summary report (end) -->
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /#ew-center -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /.row -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /.ew-report -->
<?php } ?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
