<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class SelectedMdAsSummary extends SelectedMdAs
{
    use MessagesTrait;

    // Page ID
    public $PageID = "summary";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'Selected MDA(s)';

    // Page object name
    public $PageObjName = "SelectedMdAsSummary";

    // Rendering View
    public $RenderingView = false;

    // CSS
    public $ReportTableClass = "";
    public $ReportTableStyle = "";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Export URLs
    public $ExportPrintUrl;
    public $ExportHtmlUrl;
    public $ExportExcelUrl;
    public $ExportWordUrl;
    public $ExportXmlUrl;
    public $ExportCsvUrl;
    public $ExportPdfUrl;

    // Custom export
    public $ExportExcelCustom = false;
    public $ExportWordCustom = false;
    public $ExportPdfCustom = false;
    public $ExportEmailCustom = false;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (SelectedMDAs)
        if (!isset($GLOBALS["SelectedMDAs"]) || get_class($GLOBALS["SelectedMDAs"]) == PROJECT_NAMESPACE . "SelectedMDAs") {
            $GLOBALS["SelectedMDAs"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Initialize URLs
        $this->ExportPrintUrl = $pageUrl . "export=print";
        $this->ExportExcelUrl = $pageUrl . "export=excel";
        $this->ExportWordUrl = $pageUrl . "export=word";
        $this->ExportPdfUrl = $pageUrl . "export=pdf";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'Selected MDA(s)');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions("div");
        $this->ExportOptions->TagClassName = "ew-export-option";

        // Filter options
        $this->FilterOptions = new ListOptions("div");
        $this->FilterOptions->TagClassName = "ew-filter-option fsummary";
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->isExport() && !$this->isExport("print")) {
            $class = PROJECT_NAMESPACE . Config("REPORT_EXPORT_CLASSES." . $this->Export);
            if (class_exists($class)) {
                $content = $this->getContents();
                $doc = new $class();
                $doc($this, $content);
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        if (in_array($lookup->LinkTable, [$this->ReportSourceTable, $this->TableVar])) {
            $lookup->RenderViewFunc = "renderLookup"; // Set up view renderer
        }
        $lookup->RenderEditFunc = ""; // Set up edit renderer

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }

    // Options
    public $HideOptions = false;
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $FilterOptions; // Filter options

    // Records
    public $GroupRecords = [];
    public $DetailRecords = [];
    public $DetailRecordCount = 0;

    // Paging variables
    public $RecordIndex = 0; // Record index
    public $RecordCount = 0; // Record count (start from 1 for each group)
    public $StartGroup = 0; // Start group
    public $StopGroup = 0; // Stop group
    public $TotalGroups = 0; // Total groups
    public $GroupCount = 0; // Group count
    public $GroupCounter = []; // Group counter
    public $DisplayGroups = 10; // Groups per page
    public $GroupRange = 10;
    public $PageSizes = "1,2,3,5,10,-1"; // Page sizes (comma separated)
    public $PageFirstGroupFilter = "";
    public $UserIDFilter = "";
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = "";
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchRowCount = 0; // For extended search
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $DrillDownList = "";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $SearchCommand = false;
    public $ShowHeader;
    public $GroupColumnCount = 0;
    public $SubGroupColumnCount = 0;
    public $DetailColumnCount = 0;
    public $TotalCount;
    public $PageTotalCount;
    public $TopContentClass = "col-sm-12 ew-top";
    public $LeftContentClass = "ew-left";
    public $CenterContentClass = "col-sm-12 ew-center";
    public $RightContentClass = "ew-right";
    public $BottomContentClass = "col-sm-12 ew-bottom";

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $ExportFileName, $Language, $Security, $UserProfile,
            $Security, $DrillDownInPanel, $Breadcrumb,
            $DashboardReport, $CustomExportType, $ReportExportType;

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        }
        $ExportFileName = $this->TableVar; // Get export file, used in header

        // Get custom export parameters
        if ($this->isExport() && $custom != "") {
            $this->CustomExport = $this->Export;
            $this->Export = "print";
        }
        $CustomExportType = $this->CustomExport;
        $ExportType = $this->Export; // Get export parameter, used in header
        $ReportExportType = $ExportType; // Report export type, used in header

        // Update Export URLs
        if ($this->ExportExcelCustom) {
            $this->ExportExcelUrl .= "&amp;custom=1";
        }
        if ($this->ExportWordCustom) {
            $this->ExportWordUrl .= "&amp;custom=1";
        }
        if ($this->ExportPdfCustom) {
            $this->ExportPdfUrl .= "&amp;custom=1";
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up table class
        if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf")) {
            $this->ReportTableClass = "ew-table";
        } else {
            $this->ReportTableClass = "table ew-table";
        }

        // Set field visibility for detail fields
        $this->row_id->setVisibility();
        $this->Assetsid->setVisibility();
        $this->Asset_No->setVisibility();
        $this->MDA_temp->setVisibility();
        $this->Location_id->setVisibility();
        $this->Asset_Status->setVisibility();
        $this->Condition_Of_Asset->setVisibility();
        $this->Details_of_Asset->setVisibility();
        $this->Custodian_id->setVisibility();
        $this->Category->setVisibility();
        $this->Category_Details->setVisibility();
        $this->Date_of_Acquisition->setVisibility();
        $this->Aquistion_Cost->setVisibility();
        $this->Additional_Cost->setVisibility();
        $this->Revaluation_Cost->setVisibility();

        // Set up User ID
        $filter = "";
        $filter = $this->applyUserIDFilters($filter);
        $this->UserIDFilter = $filter;
        $this->Filter = $this->UserIDFilter;

        // Set up groups per page dynamically
        $this->setupDisplayGroups();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Check if search command
        $this->SearchCommand = (Get("cmd", "") == "search");

        // Load custom filters
        $this->pageFilterLoad();

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }

        // Extended filter
        $extendedFilter = "";

        // Restore filter list
        $this->restoreFilterList();

        // Build extended filter
        $extendedFilter = $this->getExtendedFilter();
        AddFilter($this->SearchWhere, $extendedFilter);

        // Call Page Selecting event
        $this->pageSelecting($this->SearchWhere);

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Get sort
        $this->Sort = $this->getSort();

        // Search options
        $this->setupSearchOptions();

        // Update filter
        AddFilter($this->Filter, $this->SearchWhere);

        // Get total count
        $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
        $this->TotalGroups = $this->getRecordCount($sql);
        if ($this->DisplayGroups <= 0 || $this->DrillDown || $DashboardReport) { // Display all groups
            $this->DisplayGroups = $this->TotalGroups;
        }
        $this->StartGroup = 1;

        // Show header
        $this->ShowHeader = ($this->TotalGroups > 0);

        // Set up start position if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->DisplayGroups = $this->TotalGroups;
        } else {
            $this->setupStartGroup();
        }

        // Set no record found message
        if ($this->TotalGroups == 0) {
            if ($Security->canList()) {
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            } else {
                $this->setWarningMessage(DeniedMessage());
            }
        }

        // Hide export options if export/dashboard report/hide options
        if ($this->isExport() || $DashboardReport || $this->HideOptions) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide search/filter options if export/drilldown/dashboard report/hide options
        if ($this->isExport() || $this->DrillDown || $DashboardReport || $this->HideOptions) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }

        // Get current page records
        if ($this->TotalGroups > 0) {
            $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, $this->Sort);
            $rs = $sql->setFirstResult($this->StartGroup - 1)->setMaxResults($this->DisplayGroups)->execute();
            $this->DetailRecords = $rs->fetchAll(); // Get records
            $this->GroupCount = 1;
        }
        $this->setupFieldCount();

        // Set the last group to display if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->StopGroup = $this->TotalGroups;
        } else {
            $this->StopGroup = $this->StartGroup + $this->DisplayGroups - 1;
        }

        // Stop group <= total number of groups
        if (intval($this->StopGroup) > intval($this->TotalGroups)) {
            $this->StopGroup = $this->TotalGroups;
        }
        $this->RecordCount = 0;
        $this->RecordIndex = 0;
        $this->setGroupCount($this->StopGroup - $this->StartGroup + 1, 1);

        // Set up pager
        $this->Pager = new PrevNextPager($this->StartGroup, $this->getGroupPerPage(), $this->TotalGroups, $this->PageSizes, $this->GroupRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Load row values
    public function loadRowValues($record)
    {
        $data = [];
        $data["row_id"] = $record['row_id'];
        $data["Assetsid"] = $record['Assetsid'];
        $data["Asset_No"] = $record['Asset_No'];
        $data["MDA_Parent"] = $record['MDA_Parent'];
        $data["MDA_id"] = $record['MDA_id'];
        $data["MDA_temp"] = $record['MDA_temp'];
        $data["Location_id"] = $record['Location_id'];
        $data["Asset_Status"] = $record['Asset_Status'];
        $data["Condition_Of_Asset"] = $record['Condition_Of_Asset'];
        $data["Details_of_Asset"] = $record['Details_of_Asset'];
        $data["Custodian_id"] = $record['Custodian_id'];
        $data["Category"] = $record['Category'];
        $data["Category_Details"] = $record['Category_Details'];
        $data["Category_Temp"] = $record['Category_Temp'];
        $data["Make"] = $record['Make'];
        $data["Model"] = $record['Model'];
        $data["YearofManufacture"] = $record['Year of Manufacture'];
        $data["Colour"] = $record['Colour'];
        $data["EngineNumber"] = $record['Engine Number'];
        $data["ChasisNumber"] = $record['Chasis Number'];
        $data["CivilianPlateNumber"] = $record['Civilian Plate Number'];
        $data["GovtPlateNumber"] = $record['Govt Plate Number'];
        $data["Date_of_Acquisition"] = $record['Date_of_Acquisition'];
        $data["Aquistion_Cost"] = $record['Aquistion_Cost'];
        $data["Additional_Cost"] = $record['Additional_Cost'];
        $data["Revaluation_Cost"] = $record['Revaluation_Cost'];
        $data["Created_By"] = $record['Created_By'];
        $data["Created_on"] = $record['Created_on'];
        $data["Updated_on"] = $record['Updated_on'];
        $this->Rows[] = $data;
        $this->row_id->setDbValue($record['row_id']);
        $this->Assetsid->setDbValue($record['Assetsid']);
        $this->Asset_No->setDbValue($record['Asset_No']);
        $this->MDA_Parent->setDbValue($record['MDA_Parent']);
        $this->MDA_id->setDbValue($record['MDA_id']);
        $this->MDA_temp->setDbValue($record['MDA_temp']);
        $this->Location_id->setDbValue($record['Location_id']);
        $this->Asset_Status->setDbValue($record['Asset_Status']);
        $this->Condition_Of_Asset->setDbValue($record['Condition_Of_Asset']);
        $this->Details_of_Asset->setDbValue($record['Details_of_Asset']);
        $this->Custodian_id->setDbValue($record['Custodian_id']);
        $this->Category->setDbValue($record['Category']);
        $this->Category_Details->setDbValue($record['Category_Details']);
        $this->Category_Temp->setDbValue($record['Category_Temp']);
        $this->Make->setDbValue($record['Make']);
        $this->Model->setDbValue($record['Model']);
        $this->YearofManufacture->setDbValue($record['Year of Manufacture']);
        $this->Colour->setDbValue($record['Colour']);
        $this->EngineNumber->setDbValue($record['Engine Number']);
        $this->ChasisNumber->setDbValue($record['Chasis Number']);
        $this->CivilianPlateNumber->setDbValue($record['Civilian Plate Number']);
        $this->GovtPlateNumber->setDbValue($record['Govt Plate Number']);
        $this->Date_of_Acquisition->setDbValue($record['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($record['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($record['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($record['Revaluation_Cost']);
        $this->Remarks->setDbValue($record['Remarks']);
        $this->Created_By->setDbValue($record['Created_By']);
        $this->Created_on->setDbValue($record['Created_on']);
        $this->Updated_on->setDbValue($record['Updated_on']);
    }

    // Render row
    public function renderRow()
    {
        global $Security, $Language, $Language;
        $conn = $this->getConnection();
        if ($this->RowType == ROWTYPE_TOTAL && $this->RowTotalSubType == ROWTOTAL_FOOTER && $this->RowTotalType == ROWTOTAL_PAGE) { // Get Page total
            $records = &$this->DetailRecords;
            $this->Aquistion_Cost->getSum($records);
            $this->Additional_Cost->getSum($records);
            $this->Revaluation_Cost->getSum($records);
            $this->PageTotalCount = count($records);
        } elseif ($this->RowType == ROWTYPE_TOTAL && $this->RowTotalSubType == ROWTOTAL_FOOTER && $this->RowTotalType == ROWTOTAL_GRAND) { // Get Grand total
            $hasCount = false;
            $hasSummary = false;

            // Get total count from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectCount(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $rstot = $conn->executeQuery($sql);
            if ($rstot && $cnt = $rstot->fetchColumn()) {
                $rstot->closeCursor();
                $hasCount = true;
            } else {
                $cnt = 0;
            }
            $this->TotalCount = $cnt;

            // Get total from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectAggregate(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $sql = $this->getSqlAggregatePrefix() . $sql . $this->getSqlAggregateSuffix();
            $rsagg = $conn->fetchAssoc($sql);
            if ($rsagg) {
                $this->row_id->Count = $this->TotalCount;
                $this->Assetsid->Count = $this->TotalCount;
                $this->Asset_No->Count = $this->TotalCount;
                $this->MDA_temp->Count = $this->TotalCount;
                $this->Location_id->Count = $this->TotalCount;
                $this->Asset_Status->Count = $this->TotalCount;
                $this->Condition_Of_Asset->Count = $this->TotalCount;
                $this->Details_of_Asset->Count = $this->TotalCount;
                $this->Custodian_id->Count = $this->TotalCount;
                $this->Category->Count = $this->TotalCount;
                $this->Category_Details->Count = $this->TotalCount;
                $this->Date_of_Acquisition->Count = $this->TotalCount;
                $this->Aquistion_Cost->Count = $this->TotalCount;
                $this->Aquistion_Cost->SumValue = $rsagg["sum_aquistion_cost"];
                $this->Additional_Cost->Count = $this->TotalCount;
                $this->Additional_Cost->SumValue = $rsagg["sum_additional_cost"];
                $this->Revaluation_Cost->Count = $this->TotalCount;
                $this->Revaluation_Cost->SumValue = $rsagg["sum_revaluation_cost"];
                $hasSummary = true;
            }

            // Accumulate grand summary from detail records
            if (!$hasCount || !$hasSummary) {
                $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
                $rs = $sql->execute();
                $this->DetailRecords = $rs ? $rs->fetchAll() : [];
                $this->Aquistion_Cost->getSum($this->DetailRecords);
                $this->Additional_Cost->getSum($this->DetailRecords);
                $this->Revaluation_Cost->getSum($this->DetailRecords);
            }
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // row_id

        // Assetsid

        // Asset_No

        // MDA_temp

        // Location_id

        // Asset_Status

        // Condition_Of_Asset

        // Details_of_Asset

        // Custodian_id

        // Category

        // Category_Details

        // Date_of_Acquisition

        // Aquistion_Cost

        // Additional_Cost

        // Revaluation_Cost
        if ($this->RowType == ROWTYPE_SEARCH) {
            // MDA_temp
            $this->MDA_temp->EditAttrs["class"] = "form-control";
            $this->MDA_temp->EditCustomAttributes = "";
            $curVal = $this->MDA_temp->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->MDA_temp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->MDA_temp->AdvancedSearch->ViewValue = $this->MDA_temp->lookupCacheOption($curVal);
            } else {
                $this->MDA_temp->AdvancedSearch->ViewValue = $this->MDA_temp->Lookup !== null && is_array($this->MDA_temp->Lookup->Options) ? $curVal : null;
            }
            if ($this->MDA_temp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->MDA_temp->EditValue = array_values($this->MDA_temp->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`MDA_temp`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
                    }
                }
                $sqlWrk = $this->MDA_temp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->MDA_temp->EditValue = $arwrk;
            }
            $this->MDA_temp->PlaceHolder = RemoveHtml($this->MDA_temp->caption());
        } elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
            $this->RowAttrs->prependClass(($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class

            // Aquistion_Cost
            $this->Aquistion_Cost->SumViewValue = $this->Aquistion_Cost->SumValue;
            $this->Aquistion_Cost->SumViewValue = FormatNumber($this->Aquistion_Cost->SumViewValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";
            $this->Aquistion_Cost->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // Additional_Cost
            $this->Additional_Cost->SumViewValue = $this->Additional_Cost->SumValue;
            $this->Additional_Cost->SumViewValue = FormatNumber($this->Additional_Cost->SumViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";
            $this->Additional_Cost->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // Revaluation_Cost
            $this->Revaluation_Cost->SumViewValue = $this->Revaluation_Cost->SumValue;
            $this->Revaluation_Cost->SumViewValue = FormatNumber($this->Revaluation_Cost->SumViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";
            $this->Revaluation_Cost->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // row_id
            $this->row_id->HrefValue = "";

            // Assetsid
            $this->Assetsid->HrefValue = "";

            // Asset_No
            $this->Asset_No->HrefValue = "";

            // MDA_temp
            $this->MDA_temp->HrefValue = "";

            // Location_id
            $this->Location_id->HrefValue = "";

            // Asset_Status
            $this->Asset_Status->HrefValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->HrefValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->HrefValue = "";

            // Custodian_id
            $this->Custodian_id->HrefValue = "";

            // Category
            $this->Category->HrefValue = "";

            // Category_Details
            $this->Category_Details->HrefValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->HrefValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->HrefValue = "";

            // Additional_Cost
            $this->Additional_Cost->HrefValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->HrefValue = "";
        } else {
            if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
            } else {
            }

            // row_id
            $this->row_id->ViewValue = $this->row_id->CurrentValue;
            $this->row_id->ViewValue = FormatNumber($this->row_id->ViewValue, 0, -2, -2, -2);
            $this->row_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->row_id->ViewCustomAttributes = "";

            // Assetsid
            $this->Assetsid->ViewValue = $this->Assetsid->CurrentValue;
            $this->Assetsid->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Assetsid->CellCssStyle .= "text-align: right;";
            $this->Assetsid->ViewCustomAttributes = "";

            // Asset_No
            $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
            $this->Asset_No->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Asset_No->ViewCustomAttributes = "";

            // MDA_temp
            $this->MDA_temp->ViewValue = $this->MDA_temp->CurrentValue;
            $this->MDA_temp->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->MDA_temp->ViewCustomAttributes = "";

            // Location_id
            $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
            $curVal = $this->Location_id->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->ViewValue = null;
            }
            $this->Location_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Location_id->ViewCustomAttributes = "";

            // Asset_Status
            $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
            $this->Asset_Status->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Asset_Status->ViewCustomAttributes = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
            $this->Condition_Of_Asset->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Condition_Of_Asset->ViewCustomAttributes = "";

            // Details_of_Asset
            $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Custodian_id
            $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
            $curVal = $this->Custodian_id->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
                if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                    } else {
                        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                    }
                }
            } else {
                $this->Custodian_id->ViewValue = null;
            }
            $this->Custodian_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Custodian_id->ViewCustomAttributes = "";

            // Category
            $this->Category->ViewValue = $this->Category->CurrentValue;
            $curVal = $this->Category->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Category->Lookup->renderViewRow($row);
                            $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                        }
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }
            $this->Category->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Category->ViewCustomAttributes = "";

            // Category_Details
            $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
            $this->Category_Details->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Category_Details->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
            $this->Date_of_Acquisition->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // row_id
            $this->row_id->LinkCustomAttributes = "";
            $this->row_id->HrefValue = "";
            $this->row_id->TooltipValue = "";

            // Assetsid
            $this->Assetsid->LinkCustomAttributes = "";
            $this->Assetsid->HrefValue = "";
            $this->Assetsid->TooltipValue = "";

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";
            $this->Asset_No->TooltipValue = "";

            // MDA_temp
            $this->MDA_temp->LinkCustomAttributes = "";
            $this->MDA_temp->HrefValue = "";
            $this->MDA_temp->TooltipValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";
            $this->Asset_Status->TooltipValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";
            $this->Condition_Of_Asset->TooltipValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";
            $this->Custodian_id->TooltipValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";
        }

        // Call Cell_Rendered event
        if ($this->RowType == ROWTYPE_TOTAL) {
            // Aquistion_Cost
            $currentValue = $this->Aquistion_Cost->SumValue;
            $viewValue = &$this->Aquistion_Cost->SumViewValue;
            $viewAttrs = &$this->Aquistion_Cost->ViewAttrs;
            $cellAttrs = &$this->Aquistion_Cost->CellAttrs;
            $hrefValue = &$this->Aquistion_Cost->HrefValue;
            $linkAttrs = &$this->Aquistion_Cost->LinkAttrs;
            $this->cellRendered($this->Aquistion_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Additional_Cost
            $currentValue = $this->Additional_Cost->SumValue;
            $viewValue = &$this->Additional_Cost->SumViewValue;
            $viewAttrs = &$this->Additional_Cost->ViewAttrs;
            $cellAttrs = &$this->Additional_Cost->CellAttrs;
            $hrefValue = &$this->Additional_Cost->HrefValue;
            $linkAttrs = &$this->Additional_Cost->LinkAttrs;
            $this->cellRendered($this->Additional_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Revaluation_Cost
            $currentValue = $this->Revaluation_Cost->SumValue;
            $viewValue = &$this->Revaluation_Cost->SumViewValue;
            $viewAttrs = &$this->Revaluation_Cost->ViewAttrs;
            $cellAttrs = &$this->Revaluation_Cost->CellAttrs;
            $hrefValue = &$this->Revaluation_Cost->HrefValue;
            $linkAttrs = &$this->Revaluation_Cost->LinkAttrs;
            $this->cellRendered($this->Revaluation_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        } else {
            // row_id
            $currentValue = $this->row_id->CurrentValue;
            $viewValue = &$this->row_id->ViewValue;
            $viewAttrs = &$this->row_id->ViewAttrs;
            $cellAttrs = &$this->row_id->CellAttrs;
            $hrefValue = &$this->row_id->HrefValue;
            $linkAttrs = &$this->row_id->LinkAttrs;
            $this->cellRendered($this->row_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Assetsid
            $currentValue = $this->Assetsid->CurrentValue;
            $viewValue = &$this->Assetsid->ViewValue;
            $viewAttrs = &$this->Assetsid->ViewAttrs;
            $cellAttrs = &$this->Assetsid->CellAttrs;
            $hrefValue = &$this->Assetsid->HrefValue;
            $linkAttrs = &$this->Assetsid->LinkAttrs;
            $this->cellRendered($this->Assetsid, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Asset_No
            $currentValue = $this->Asset_No->CurrentValue;
            $viewValue = &$this->Asset_No->ViewValue;
            $viewAttrs = &$this->Asset_No->ViewAttrs;
            $cellAttrs = &$this->Asset_No->CellAttrs;
            $hrefValue = &$this->Asset_No->HrefValue;
            $linkAttrs = &$this->Asset_No->LinkAttrs;
            $this->cellRendered($this->Asset_No, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // MDA_temp
            $currentValue = $this->MDA_temp->CurrentValue;
            $viewValue = &$this->MDA_temp->ViewValue;
            $viewAttrs = &$this->MDA_temp->ViewAttrs;
            $cellAttrs = &$this->MDA_temp->CellAttrs;
            $hrefValue = &$this->MDA_temp->HrefValue;
            $linkAttrs = &$this->MDA_temp->LinkAttrs;
            $this->cellRendered($this->MDA_temp, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Location_id
            $currentValue = $this->Location_id->CurrentValue;
            $viewValue = &$this->Location_id->ViewValue;
            $viewAttrs = &$this->Location_id->ViewAttrs;
            $cellAttrs = &$this->Location_id->CellAttrs;
            $hrefValue = &$this->Location_id->HrefValue;
            $linkAttrs = &$this->Location_id->LinkAttrs;
            $this->cellRendered($this->Location_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Asset_Status
            $currentValue = $this->Asset_Status->CurrentValue;
            $viewValue = &$this->Asset_Status->ViewValue;
            $viewAttrs = &$this->Asset_Status->ViewAttrs;
            $cellAttrs = &$this->Asset_Status->CellAttrs;
            $hrefValue = &$this->Asset_Status->HrefValue;
            $linkAttrs = &$this->Asset_Status->LinkAttrs;
            $this->cellRendered($this->Asset_Status, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Condition_Of_Asset
            $currentValue = $this->Condition_Of_Asset->CurrentValue;
            $viewValue = &$this->Condition_Of_Asset->ViewValue;
            $viewAttrs = &$this->Condition_Of_Asset->ViewAttrs;
            $cellAttrs = &$this->Condition_Of_Asset->CellAttrs;
            $hrefValue = &$this->Condition_Of_Asset->HrefValue;
            $linkAttrs = &$this->Condition_Of_Asset->LinkAttrs;
            $this->cellRendered($this->Condition_Of_Asset, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Details_of_Asset
            $currentValue = $this->Details_of_Asset->CurrentValue;
            $viewValue = &$this->Details_of_Asset->ViewValue;
            $viewAttrs = &$this->Details_of_Asset->ViewAttrs;
            $cellAttrs = &$this->Details_of_Asset->CellAttrs;
            $hrefValue = &$this->Details_of_Asset->HrefValue;
            $linkAttrs = &$this->Details_of_Asset->LinkAttrs;
            $this->cellRendered($this->Details_of_Asset, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Custodian_id
            $currentValue = $this->Custodian_id->CurrentValue;
            $viewValue = &$this->Custodian_id->ViewValue;
            $viewAttrs = &$this->Custodian_id->ViewAttrs;
            $cellAttrs = &$this->Custodian_id->CellAttrs;
            $hrefValue = &$this->Custodian_id->HrefValue;
            $linkAttrs = &$this->Custodian_id->LinkAttrs;
            $this->cellRendered($this->Custodian_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Category
            $currentValue = $this->Category->CurrentValue;
            $viewValue = &$this->Category->ViewValue;
            $viewAttrs = &$this->Category->ViewAttrs;
            $cellAttrs = &$this->Category->CellAttrs;
            $hrefValue = &$this->Category->HrefValue;
            $linkAttrs = &$this->Category->LinkAttrs;
            $this->cellRendered($this->Category, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Category_Details
            $currentValue = $this->Category_Details->CurrentValue;
            $viewValue = &$this->Category_Details->ViewValue;
            $viewAttrs = &$this->Category_Details->ViewAttrs;
            $cellAttrs = &$this->Category_Details->CellAttrs;
            $hrefValue = &$this->Category_Details->HrefValue;
            $linkAttrs = &$this->Category_Details->LinkAttrs;
            $this->cellRendered($this->Category_Details, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Date_of_Acquisition
            $currentValue = $this->Date_of_Acquisition->CurrentValue;
            $viewValue = &$this->Date_of_Acquisition->ViewValue;
            $viewAttrs = &$this->Date_of_Acquisition->ViewAttrs;
            $cellAttrs = &$this->Date_of_Acquisition->CellAttrs;
            $hrefValue = &$this->Date_of_Acquisition->HrefValue;
            $linkAttrs = &$this->Date_of_Acquisition->LinkAttrs;
            $this->cellRendered($this->Date_of_Acquisition, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Aquistion_Cost
            $currentValue = $this->Aquistion_Cost->CurrentValue;
            $viewValue = &$this->Aquistion_Cost->ViewValue;
            $viewAttrs = &$this->Aquistion_Cost->ViewAttrs;
            $cellAttrs = &$this->Aquistion_Cost->CellAttrs;
            $hrefValue = &$this->Aquistion_Cost->HrefValue;
            $linkAttrs = &$this->Aquistion_Cost->LinkAttrs;
            $this->cellRendered($this->Aquistion_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Additional_Cost
            $currentValue = $this->Additional_Cost->CurrentValue;
            $viewValue = &$this->Additional_Cost->ViewValue;
            $viewAttrs = &$this->Additional_Cost->ViewAttrs;
            $cellAttrs = &$this->Additional_Cost->CellAttrs;
            $hrefValue = &$this->Additional_Cost->HrefValue;
            $linkAttrs = &$this->Additional_Cost->LinkAttrs;
            $this->cellRendered($this->Additional_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Revaluation_Cost
            $currentValue = $this->Revaluation_Cost->CurrentValue;
            $viewValue = &$this->Revaluation_Cost->ViewValue;
            $viewAttrs = &$this->Revaluation_Cost->ViewAttrs;
            $cellAttrs = &$this->Revaluation_Cost->CellAttrs;
            $hrefValue = &$this->Revaluation_Cost->HrefValue;
            $linkAttrs = &$this->Revaluation_Cost->LinkAttrs;
            $this->cellRendered($this->Revaluation_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        }

        // Call Row_Rendered event
        $this->rowRendered();
        $this->setupFieldCount();
    }
    private $groupCounts = [];

    // Get group count
    public function getGroupCount(...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return -1;
        } elseif ($key == "0") { // Number of first level groups
            $i = 1;
            while (isset($this->groupCounts[strval($i)])) {
                $i++;
            }
            return $i - 1;
        }
        return isset($this->groupCounts[$key]) ? $this->groupCounts[$key] : -1;
    }

    // Set group count
    public function setGroupCount($value, ...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return;
        }
        $this->groupCounts[$key] = $value;
    }

    // Setup field count
    protected function setupFieldCount()
    {
        $this->GroupColumnCount = 0;
        $this->SubGroupColumnCount = 0;
        $this->DetailColumnCount = 0;
        if ($this->row_id->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Assetsid->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Asset_No->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->MDA_temp->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Location_id->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Asset_Status->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Condition_Of_Asset->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Details_of_Asset->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Custodian_id->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Category->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Category_Details->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Date_of_Acquisition->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Aquistion_Cost->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Additional_Cost->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Revaluation_Cost->Visible) {
            $this->DetailColumnCount += 1;
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        $pageUrl = $this->pageUrl();
        if (SameText($type, "excel")) {
            return '<a class="ew-export-link ew-excel" title="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" href="#" onclick="return ew.exportWithCharts(event, \'' . $this->ExportExcelUrl . '\', \'' . session_id() . '\');">' . $Language->phrase("ExportToExcel") . '</a>';
        } elseif (SameText($type, "word")) {
            return '<a class="ew-export-link ew-word" title="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" href="#" onclick="return ew.exportWithCharts(event, \'' . $this->ExportWordUrl . '\', \'' . session_id() . '\');">' . $Language->phrase("ExportToWord") . '</a>';
        } elseif (SameText($type, "pdf")) {
            return '<a class="ew-export-link ew-pdf" title="' . HtmlEncode($Language->phrase("ExportToPDF", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToPDF", true)) . '" href="#" onclick="return ew.exportWithCharts(event, \'' . $this->ExportPdfUrl . '\', \'' . session_id() . '\');">' . $Language->phrase("ExportToPDF") . '</a>';
        } elseif (SameText($type, "email")) {
            $url = $pageUrl . "export=email" . ($custom ? "&amp;custom=1" : "");
            return '<a class="ew-export-link ew-email" title="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" id="emf_SelectedMDAs" href="#" onclick="return ew.emailDialogShow({ lnk: \'emf_SelectedMDAs\', hdr: ew.language.phrase(\'ExportToEmailText\'), url: \'' . $url . '\', exportid: \'' . session_id() . '\', el: this });">' . $Language->phrase("ExportToEmail") . '</a>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to Pdf
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl();
        $this->SearchOptions = new ListOptions("div");
        $this->SearchOptions->TagClassName = "ew-search-option";

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fsummary\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MDA_temp":
                    break;
                case "x_Location_id":
                    break;
                case "x_Custodian_id":
                    break;
                case "x_Category":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fsummary\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fsummary\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"), "");
        $pageNo = Param("pageno", "");

        // Check for a 'start' parameter
        if ($startGrp != "") {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo != "") {
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || $this->StartGroup == "") { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Set up number of groups displayed per page
    protected function setupDisplayGroups()
    {
        $this->DisplayGroups = 10; // Load default
        if (Param(Config("TABLE_GROUP_PER_PAGE")) !== null) {
            $wrk = Param(Config("TABLE_GROUP_PER_PAGE"));
            if (is_numeric($wrk)) {
                $this->DisplayGroups = intval($wrk);
            } elseif (strtoupper($wrk) == "ALL") { // Display all groups
                $this->DisplayGroups = -1;
            }

            // Reset start position (reset command)
            $this->StartGroup = 1;
            $this->setStartGroup($this->StartGroup);
        } elseif ($this->getGroupPerPage() != "") {
            $this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
        }
        $this->setGroupPerPage($this->DisplayGroups); // Save to session
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "`Date_of_Acquisition` DESC,`Category_Details` ASC";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->row_id->setSort("");
            $this->Assetsid->setSort("");
            $this->Asset_No->setSort("");
            $this->MDA_temp->setSort("");
            $this->Location_id->setSort("");
            $this->Asset_Status->setSort("");
            $this->Condition_Of_Asset->setSort("");
            $this->Details_of_Asset->setSort("");
            $this->Custodian_id->setSort("");
            $this->Category->setSort("");
            $this->Category_Details->setSort("");
            $this->Date_of_Acquisition->setSort("");
            $this->Aquistion_Cost->setSort("");
            $this->Additional_Cost->setSort("");
            $this->Revaluation_Cost->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->row_id); // row_id
            $this->updateSort($this->Assetsid); // Assetsid
            $this->updateSort($this->Asset_No); // Asset_No
            $this->updateSort($this->MDA_temp); // MDA_temp
            $this->updateSort($this->Location_id); // Location_id
            $this->updateSort($this->Asset_Status); // Asset_Status
            $this->updateSort($this->Condition_Of_Asset); // Condition_Of_Asset
            $this->updateSort($this->Details_of_Asset); // Details_of_Asset
            $this->updateSort($this->Custodian_id); // Custodian_id
            $this->updateSort($this->Category); // Category
            $this->updateSort($this->Category_Details); // Category_Details
            $this->updateSort($this->Date_of_Acquisition); // Date_of_Acquisition
            $this->updateSort($this->Aquistion_Cost); // Aquistion_Cost
            $this->updateSort($this->Additional_Cost); // Additional_Cost
            $this->updateSort($this->Revaluation_Cost); // Revaluation_Cost
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }

        // Set up default sort
        if ($this->getOrderBy() == "") {
            $useDefaultSort = true;
            if ($this->Date_of_Acquisition->getSort() != "") {
                $useDefaultSort = false;
            }
            if ($this->Category_Details->getSort() != "") {
                $useDefaultSort = false;
            }
            if ($useDefaultSort) {
                $this->Date_of_Acquisition->setSort("DESC");
                $this->Category_Details->setSort("ASC");
                $this->setOrderBy("`Date_of_Acquisition` DESC,`Category_Details` ASC");
            }
        }
        return $this->getOrderBy();
    }

    // Return extended filter
    protected function getExtendedFilter()
    {
        $filter = "";
        if ($this->DrillDown) {
            return "";
        }
        $restoreSession = false;
        $restoreDefault = false;
        // Reset search command
        if (Get("cmd", "") == "reset") {
            // Set default values
            $this->MDA_temp->AdvancedSearch->unsetSession();
            $restoreDefault = true;
        } else {
            $restoreSession = !$this->SearchCommand;

            // Field MDA_temp
            $this->getDropDownValue($this->MDA_temp);
            if (!$this->validateForm()) {
                return $filter;
            }
        }

        // Restore session
        if ($restoreSession) {
            $restoreDefault = true;
            if ($this->MDA_temp->AdvancedSearch->issetSession()) { // Field MDA_temp
                $this->MDA_temp->AdvancedSearch->load();
                $restoreDefault = false;
            }
        }

        // Restore default
        if ($restoreDefault) {
            $this->loadDefaultFilters();
        }

        // Call page filter validated event
        $this->pageFilterValidated();

        // Build SQL and save to session
        $this->buildDropDownFilter($this->MDA_temp, $filter, $this->MDA_temp->AdvancedSearch->SearchOperator, false, true); // Field MDA_temp
        $this->MDA_temp->AdvancedSearch->save();

        // Field MDA_temp
        LoadDropDownList($this->MDA_temp->EditValue, $this->MDA_temp->AdvancedSearch->SearchValue);
        return $filter;
    }

    // Build dropdown filter
    protected function buildDropDownFilter(&$fld, &$filterClause, $fldOpr, $default = false, $saveFilter = false)
    {
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $sql = "";
        if (is_array($fldVal)) {
            foreach ($fldVal as $val) {
                $wrk = $this->getDropDownFilter($fld, $val, $fldOpr);
                if ($wrk != "") {
                    if ($sql != "") {
                        $sql .= " OR " . $wrk;
                    } else {
                        $sql = $wrk;
                    }
                }
            }
        } else {
            $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
            $sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr, $fldVal2);
        }
        if ($sql != "") {
            AddFilter($filterClause, $sql);
            if ($saveFilter) {
                $fld->CurrentFilter = $sql;
            }
        }
    }

    // Get dropdown filter
    protected function getDropDownFilter(&$fld, $fldVal, $fldOpr, $fldVal2 = "")
    {
        $fldName = $fld->Name;
        $fldExpression = $fld->Expression;
        $fldDataType = $fld->DataType;
        $isMultiple = $fld->HtmlTag == "CHECKBOX" || $fld->HtmlTag == "SELECT" && $fld->SelectMultiple;
        $fldVal = strval($fldVal);
        if ($fldOpr == "") {
            $fldOpr = "=";
        }
        $wrk = "";
        if (SameString($fldVal, Config("NULL_VALUE"))) {
            $wrk = $fldExpression . " IS NULL";
        } elseif (SameString($fldVal, Config("NOT_NULL_VALUE"))) {
            $wrk = $fldExpression . " IS NOT NULL";
        } elseif (SameString($fldVal, EMPTY_VALUE)) {
            $wrk = $fldExpression . " = ''";
        } elseif (SameString($fldVal, ALL_VALUE)) {
            $wrk = "1 = 1";
        } else {
            if ($fld->GroupSql != "") { // Use grouping SQL for search if exists
                $fldExpression = str_replace("%s", $fldExpression, $fld->GroupSql);
            }
            if (StartsString("@@", $fldVal)) {
                $wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
            } elseif ($isMultiple && IsMultiSearchOperator($fldOpr) && trim($fldVal) != "" && $fldVal != INIT_VALUE && ($fldDataType == DATATYPE_NUMBER || $fldDataType == DATATYPE_STRING || $fldDataType == DATATYPE_MEMO)) {
                $wrk = GetMultiSearchSql($fld, $fldOpr, trim($fldVal), $this->Dbid);
            } elseif ($fldOpr == "BETWEEN" && $fldVal != "" && $fldVal != INIT_VALUE && $fldVal2 != "" && $fldVal2 != INIT_VALUE) {
                $wrk = $fldExpression ." " . $fldOpr . " " . QuotedValue($fldVal, $fldDataType, $this->Dbid) . " AND " . QuotedValue($fldVal2, $fldDataType, $this->Dbid);
            } else {
                if ($fldVal != "" && $fldVal != INIT_VALUE) {
                    if ($fldDataType == DATATYPE_DATE && $fld->GroupSql == "" && $fldOpr != "") {
                        $wrk = GetDateFilterSql($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
                    } else {
                        $wrk = GetFilterSql($fldOpr, $fldVal, $fldDataType, $this->Dbid);
                        if ($wrk != "") {
                            $wrk = $fldExpression . $wrk;
                        }
                    }
                }
            }
        }

        // Call Page Filtering event
        if (!StartsString("@@", $fldVal)) {
            $this->pageFiltering($fld, $wrk, "dropdown", $fldOpr, $fldVal);
        }
        return $wrk;
    }

    // Get custom filter
    protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
    {
        $wrk = "";
        if (is_array($fld->AdvancedFilters)) {
            foreach ($fld->AdvancedFilters as $filter) {
                if ($filter->ID == $fldVal && $filter->Enabled) {
                    $fldExpr = $fld->Expression;
                    $fn = $filter->FunctionName;
                    $wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
                    $fn = $fn != "" && !function_exists($fn) ? PROJECT_NAMESPACE . $fn : $fn;
                    if (function_exists($fn)) {
                        $wrk = $fn($fldExpr, $dbid);
                    } else {
                        $wrk = "";
                    }
                    $this->pageFiltering($fld, $wrk, "custom", $wrkid);
                    break;
                }
            }
        }
        return $wrk;
    }

    // Build extended filter
    protected function buildExtendedFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $wrk = GetExtendedFilter($fld, $default, $this->Dbid);
        if (!$default) {
            $this->pageFiltering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
        }
        if ($wrk != "") {
            AddFilter($filterClause, $wrk);
            if ($saveFilter) {
                $fld->CurrentFilter = $wrk;
            }
        }
    }

    // Get drop down value from querystring
    protected function getDropDownValue(&$fld)
    {
        $ret = false;
        $parm = $fld->Param;
        if (IsPost()) {
            return false; // Skip post back
        }
        $opr = Get("z_$parm");
        if ($opr !== null) {
            $fld->AdvancedSearch->SearchOperator = $opr;
        }
        $val = Get("x_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val);
            }
            $fld->AdvancedSearch->setSearchValue($val);
            $ret = true;
        }
        $val = Get("y_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val);
            }
            $fld->AdvancedSearch->setSearchValue2($val);
            $ret = true;
        }
        return $ret;
    }

    // Dropdown filter exist
    protected function dropDownFilterExist(&$fld, $fldOpr)
    {
        $wrk = "";
        $this->buildDropDownFilter($fld, $wrk, $fldOpr);
        return ($wrk != "");
    }

    // Extended filter exist
    protected function extendedFilterExist(&$fld)
    {
        $extWrk = "";
        $this->buildExtendedFilter($fld, $extWrk);
        return ($extWrk != "");
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Load default value for filters
    protected function loadDefaultFilters()
    {
        // Field MDA_temp
        $this->MDA_temp->AdvancedSearch->loadDefault();
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field MDA_temp
        $extWrk = "";
        $this->buildDropDownFilter($this->MDA_temp, $extWrk, $this->MDA_temp->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->MDA_temp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"alert alert-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        }
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fsummary");
        }

        // Field MDA_temp
        $wrk = "";
        $wrk = ($this->MDA_temp->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->MDA_temp->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_MDA_temp\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Return filter list in json
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fsummary", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd", "") != "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter", ""), true);
        return $this->setupFilterList($filter);
    }

    // Setup list of filters
    protected function setupFilterList($filter)
    {
        if (!is_array($filter)) {
            return false;
        }

        // Field MDA_temp
        if (!$this->MDA_temp->AdvancedSearch->getFromArray($filter)) {
            $this->MDA_temp->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->MDA_temp->AdvancedSearch->save();
        return true;
    }

    // Page Load event
    public function pageLoad()
    {
    // Update record
    // NOTE: Modify your SQL here, replace the table name, field name and field values
    $myMDAtemp = ExecuteUpdate("UPDATE assetstbl
       SET MDA_temp =(SELECT MDA_Acronym FROM mdatbl WHERE mdatbl.MDAID =assetstbl.MDA_id )");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"page-break-after:always;\">&nbsp;</div>"; // Modify page break content
    }

    // Load Filters event
    public function pageFilterLoad()
    {
        // Enter your code here
        // Example: Register/Unregister Custom Extended Filter
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', 'GetStartsWithAFilter'); // With function, or
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
        //UnregisterFilter($this-><Field>, 'StartsWithA');
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
    }

    // Page Filter Validated event
    public function pageFilterValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Page Filtering event
    public function pageFiltering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "")
    {
        // Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
        //if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
        //    $filter = "..."; // Modify the filter
    }

    // Cell Rendered event
    public function cellRendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs)
    {
        //$ViewValue = "xxx";
        //$ViewAttrs["class"] = "xxx";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
