<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class CustodianmovementtblEdit extends Custodianmovementtbl
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'custodianmovementtbl';

    // Page object name
    public $PageObjName = "CustodianmovementtblEdit";

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (custodianmovementtbl)
        if (!isset($GLOBALS["custodianmovementtbl"]) || get_class($GLOBALS["custodianmovementtbl"]) == PROJECT_NAMESPACE . "custodianmovementtbl") {
            $GLOBALS["custodianmovementtbl"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'custodianmovementtbl');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("custodianmovementtbl"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "custodianmovementtblview") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['verifyassetid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->verifyassetid->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-edit-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->verifyassetid->setVisibility();
        $this->asset_id->setVisibility();
        $this->reassignerid->setVisibility();
        $this->reciverid->setVisibility();
        $this->MDA_id->setVisibility();
        $this->Created_on->setVisibility();
        $this->status->setVisibility();
        $this->transactionid->setVisibility();
        $this->url->setVisibility();
        $this->Prev_Custodian_id->setVisibility();
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->asset_id);
        $this->setupLookupOptions($this->reassignerid);
        $this->setupLookupOptions($this->reciverid);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-edit-form ew-horizontal";
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("verifyassetid") ?? Key(0) ?? Route(2)) !== null) {
                $this->verifyassetid->setQueryStringValue($keyValue);
                $this->verifyassetid->setOldValue($this->verifyassetid->QueryStringValue);
            } elseif (Post("verifyassetid") !== null) {
                $this->verifyassetid->setFormValue(Post("verifyassetid"));
                $this->verifyassetid->setOldValue($this->verifyassetid->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action") !== null) {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("verifyassetid") ?? Route("verifyassetid")) !== null) {
                    $this->verifyassetid->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->verifyassetid->CurrentValue = null;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                // Load current record
                $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$loaded) { // Load record based on key
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("custodianmovementtbllist"); // No matching record, return to list
                    return;
                }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "custodianmovementtbllist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsApi()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'verifyassetid' first before field var 'x_verifyassetid'
        $val = $CurrentForm->hasValue("verifyassetid") ? $CurrentForm->getValue("verifyassetid") : $CurrentForm->getValue("x_verifyassetid");
        if (!$this->verifyassetid->IsDetailKey) {
            $this->verifyassetid->setFormValue($val);
        }

        // Check field name 'asset_id' first before field var 'x_asset_id'
        $val = $CurrentForm->hasValue("asset_id") ? $CurrentForm->getValue("asset_id") : $CurrentForm->getValue("x_asset_id");
        if (!$this->asset_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->asset_id->Visible = false; // Disable update for API request
            } else {
                $this->asset_id->setFormValue($val);
            }
        }

        // Check field name 'reassignerid' first before field var 'x_reassignerid'
        $val = $CurrentForm->hasValue("reassignerid") ? $CurrentForm->getValue("reassignerid") : $CurrentForm->getValue("x_reassignerid");
        if (!$this->reassignerid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reassignerid->Visible = false; // Disable update for API request
            } else {
                $this->reassignerid->setFormValue($val);
            }
        }

        // Check field name 'reciverid' first before field var 'x_reciverid'
        $val = $CurrentForm->hasValue("reciverid") ? $CurrentForm->getValue("reciverid") : $CurrentForm->getValue("x_reciverid");
        if (!$this->reciverid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reciverid->Visible = false; // Disable update for API request
            } else {
                $this->reciverid->setFormValue($val);
            }
        }

        // Check field name 'MDA_id' first before field var 'x_MDA_id'
        $val = $CurrentForm->hasValue("MDA_id") ? $CurrentForm->getValue("MDA_id") : $CurrentForm->getValue("x_MDA_id");
        if (!$this->MDA_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MDA_id->Visible = false; // Disable update for API request
            } else {
                $this->MDA_id->setFormValue($val);
            }
        }

        // Check field name 'Created_on' first before field var 'x_Created_on'
        $val = $CurrentForm->hasValue("Created_on") ? $CurrentForm->getValue("Created_on") : $CurrentForm->getValue("x_Created_on");
        if (!$this->Created_on->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_on->Visible = false; // Disable update for API request
            } else {
                $this->Created_on->setFormValue($val);
            }
            $this->Created_on->CurrentValue = UnFormatDateTime($this->Created_on->CurrentValue, 0);
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'transactionid' first before field var 'x_transactionid'
        $val = $CurrentForm->hasValue("transactionid") ? $CurrentForm->getValue("transactionid") : $CurrentForm->getValue("x_transactionid");
        if (!$this->transactionid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transactionid->Visible = false; // Disable update for API request
            } else {
                $this->transactionid->setFormValue($val);
            }
        }

        // Check field name 'url' first before field var 'x_url'
        $val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
        if (!$this->url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->url->Visible = false; // Disable update for API request
            } else {
                $this->url->setFormValue($val);
            }
        }

        // Check field name 'Prev_Custodian_id' first before field var 'x_Prev_Custodian_id'
        $val = $CurrentForm->hasValue("Prev_Custodian_id") ? $CurrentForm->getValue("Prev_Custodian_id") : $CurrentForm->getValue("x_Prev_Custodian_id");
        if (!$this->Prev_Custodian_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Prev_Custodian_id->Visible = false; // Disable update for API request
            } else {
                $this->Prev_Custodian_id->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->verifyassetid->CurrentValue = $this->verifyassetid->FormValue;
        $this->asset_id->CurrentValue = $this->asset_id->FormValue;
        $this->reassignerid->CurrentValue = $this->reassignerid->FormValue;
        $this->reciverid->CurrentValue = $this->reciverid->FormValue;
        $this->MDA_id->CurrentValue = $this->MDA_id->FormValue;
        $this->Created_on->CurrentValue = $this->Created_on->FormValue;
        $this->Created_on->CurrentValue = UnFormatDateTime($this->Created_on->CurrentValue, 0);
        $this->status->CurrentValue = $this->status->FormValue;
        $this->transactionid->CurrentValue = $this->transactionid->FormValue;
        $this->url->CurrentValue = $this->url->FormValue;
        $this->Prev_Custodian_id->CurrentValue = $this->Prev_Custodian_id->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("edit");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->verifyassetid->setDbValue($row['verifyassetid']);
        $this->asset_id->setDbValue($row['asset_id']);
        $this->reassignerid->setDbValue($row['reassignerid']);
        $this->reciverid->setDbValue($row['reciverid']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->status->setDbValue($row['status']);
        $this->transactionid->setDbValue($row['transactionid']);
        $this->url->setDbValue($row['url']);
        $this->Prev_Custodian_id->setDbValue($row['Prev_Custodian_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['verifyassetid'] = null;
        $row['asset_id'] = null;
        $row['reassignerid'] = null;
        $row['reciverid'] = null;
        $row['MDA_id'] = null;
        $row['Created_on'] = null;
        $row['status'] = null;
        $row['transactionid'] = null;
        $row['url'] = null;
        $row['Prev_Custodian_id'] = null;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // verifyassetid

        // asset_id

        // reassignerid

        // reciverid

        // MDA_id

        // Created_on

        // status

        // transactionid

        // url

        // Prev_Custodian_id
        if ($this->RowType == ROWTYPE_VIEW) {
            // verifyassetid
            $this->verifyassetid->ViewValue = $this->verifyassetid->CurrentValue;
            $this->verifyassetid->ViewCustomAttributes = "";

            // asset_id
            $curVal = trim(strval($this->asset_id->CurrentValue));
            if ($curVal != "") {
                $this->asset_id->ViewValue = $this->asset_id->lookupCacheOption($curVal);
                if ($this->asset_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Assetsid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->asset_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->asset_id->Lookup->renderViewRow($rswrk[0]);
                        $this->asset_id->ViewValue = $this->asset_id->displayValue($arwrk);
                    } else {
                        $this->asset_id->ViewValue = $this->asset_id->CurrentValue;
                    }
                }
            } else {
                $this->asset_id->ViewValue = null;
            }
            $this->asset_id->ViewCustomAttributes = "";

            // reassignerid
            $curVal = trim(strval($this->reassignerid->CurrentValue));
            if ($curVal != "") {
                $this->reassignerid->ViewValue = $this->reassignerid->lookupCacheOption($curVal);
                if ($this->reassignerid->ViewValue === null) { // Lookup from database
                    $filterWrk = "`userid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->reassignerid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reassignerid->Lookup->renderViewRow($rswrk[0]);
                        $this->reassignerid->ViewValue = $this->reassignerid->displayValue($arwrk);
                    } else {
                        $this->reassignerid->ViewValue = $this->reassignerid->CurrentValue;
                    }
                }
            } else {
                $this->reassignerid->ViewValue = null;
            }
            $this->reassignerid->ViewCustomAttributes = "";

            // reciverid
            $curVal = trim(strval($this->reciverid->CurrentValue));
            if ($curVal != "") {
                $this->reciverid->ViewValue = $this->reciverid->lookupCacheOption($curVal);
                if ($this->reciverid->ViewValue === null) { // Lookup from database
                    $filterWrk = "`userid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->reciverid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reciverid->Lookup->renderViewRow($rswrk[0]);
                        $this->reciverid->ViewValue = $this->reciverid->displayValue($arwrk);
                    } else {
                        $this->reciverid->ViewValue = $this->reciverid->CurrentValue;
                    }
                }
            } else {
                $this->reciverid->ViewValue = null;
            }
            $this->reciverid->ViewCustomAttributes = "";

            // MDA_id
            $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
            $this->MDA_id->ViewValue = FormatNumber($this->MDA_id->ViewValue, 0, -2, -2, -2);
            $this->MDA_id->ViewCustomAttributes = "";

            // Created_on
            $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
            $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
            $this->Created_on->ViewCustomAttributes = "";

            // status
            if (ConvertToBool($this->status->CurrentValue)) {
                $this->status->ViewValue = $this->status->tagCaption(1) != "" ? $this->status->tagCaption(1) : "Yes";
            } else {
                $this->status->ViewValue = $this->status->tagCaption(2) != "" ? $this->status->tagCaption(2) : "No";
            }
            $this->status->ViewCustomAttributes = "";

            // transactionid
            $this->transactionid->ViewValue = $this->transactionid->CurrentValue;
            $this->transactionid->ViewCustomAttributes = "";

            // url
            $this->url->ViewValue = $this->url->CurrentValue;
            $this->url->ViewCustomAttributes = "";

            // Prev_Custodian_id
            $this->Prev_Custodian_id->ViewValue = $this->Prev_Custodian_id->CurrentValue;
            $this->Prev_Custodian_id->ViewValue = FormatNumber($this->Prev_Custodian_id->ViewValue, 0, -2, -2, -2);
            $this->Prev_Custodian_id->ViewCustomAttributes = "";

            // verifyassetid
            $this->verifyassetid->LinkCustomAttributes = "";
            $this->verifyassetid->HrefValue = "";
            $this->verifyassetid->TooltipValue = "";

            // asset_id
            $this->asset_id->LinkCustomAttributes = "";
            $this->asset_id->HrefValue = "";
            $this->asset_id->TooltipValue = "";

            // reassignerid
            $this->reassignerid->LinkCustomAttributes = "";
            $this->reassignerid->HrefValue = "";
            $this->reassignerid->TooltipValue = "";

            // reciverid
            $this->reciverid->LinkCustomAttributes = "";
            $this->reciverid->HrefValue = "";
            $this->reciverid->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
            $this->Created_on->TooltipValue = "";

            // status
            $this->status->LinkCustomAttributes = "";
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // transactionid
            $this->transactionid->LinkCustomAttributes = "";
            $this->transactionid->HrefValue = "";
            $this->transactionid->TooltipValue = "";

            // url
            $this->url->LinkCustomAttributes = "";
            $this->url->HrefValue = "";
            $this->url->TooltipValue = "";

            // Prev_Custodian_id
            $this->Prev_Custodian_id->LinkCustomAttributes = "";
            $this->Prev_Custodian_id->HrefValue = "";
            $this->Prev_Custodian_id->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // verifyassetid
            $this->verifyassetid->EditAttrs["class"] = "form-control";
            $this->verifyassetid->EditCustomAttributes = "";
            $this->verifyassetid->EditValue = $this->verifyassetid->CurrentValue;
            $this->verifyassetid->ViewCustomAttributes = "";

            // asset_id
            $this->asset_id->EditAttrs["class"] = "form-control";
            $this->asset_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->asset_id->CurrentValue));
            if ($curVal != "") {
                $this->asset_id->ViewValue = $this->asset_id->lookupCacheOption($curVal);
            } else {
                $this->asset_id->ViewValue = $this->asset_id->Lookup !== null && is_array($this->asset_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->asset_id->ViewValue !== null) { // Load from cache
                $this->asset_id->EditValue = array_values($this->asset_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Assetsid`" . SearchString("=", $this->asset_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->asset_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->asset_id->EditValue = $arwrk;
            }
            $this->asset_id->PlaceHolder = RemoveHtml($this->asset_id->caption());

            // reassignerid
            $this->reassignerid->EditAttrs["class"] = "form-control";
            $this->reassignerid->EditCustomAttributes = "";
            $curVal = trim(strval($this->reassignerid->CurrentValue));
            if ($curVal != "") {
                $this->reassignerid->ViewValue = $this->reassignerid->lookupCacheOption($curVal);
            } else {
                $this->reassignerid->ViewValue = $this->reassignerid->Lookup !== null && is_array($this->reassignerid->Lookup->Options) ? $curVal : null;
            }
            if ($this->reassignerid->ViewValue !== null) { // Load from cache
                $this->reassignerid->EditValue = array_values($this->reassignerid->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`userid`" . SearchString("=", $this->reassignerid->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->reassignerid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reassignerid->EditValue = $arwrk;
            }
            $this->reassignerid->PlaceHolder = RemoveHtml($this->reassignerid->caption());

            // reciverid
            $this->reciverid->EditAttrs["class"] = "form-control";
            $this->reciverid->EditCustomAttributes = "";
            $curVal = trim(strval($this->reciverid->CurrentValue));
            if ($curVal != "") {
                $this->reciverid->ViewValue = $this->reciverid->lookupCacheOption($curVal);
            } else {
                $this->reciverid->ViewValue = $this->reciverid->Lookup !== null && is_array($this->reciverid->Lookup->Options) ? $curVal : null;
            }
            if ($this->reciverid->ViewValue !== null) { // Load from cache
                $this->reciverid->EditValue = array_values($this->reciverid->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`userid`" . SearchString("=", $this->reciverid->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->reciverid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reciverid->EditValue = $arwrk;
            }
            $this->reciverid->PlaceHolder = RemoveHtml($this->reciverid->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("edit")) { // Non system admin
                $this->MDA_id->CurrentValue = CurrentUserID();
                $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                $this->MDA_id->EditValue = FormatNumber($this->MDA_id->EditValue, 0, -2, -2, -2);
                $this->MDA_id->ViewCustomAttributes = "";
            } else {
                $this->MDA_id->EditValue = HtmlEncode($this->MDA_id->CurrentValue);
                $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
            }

            // Created_on
            $this->Created_on->EditAttrs["class"] = "form-control";
            $this->Created_on->EditCustomAttributes = "";
            $this->Created_on->EditValue = HtmlEncode(FormatDateTime($this->Created_on->CurrentValue, 8));
            $this->Created_on->PlaceHolder = RemoveHtml($this->Created_on->caption());

            // status
            $this->status->EditCustomAttributes = "";
            $this->status->EditValue = $this->status->options(false);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // transactionid
            $this->transactionid->EditAttrs["class"] = "form-control";
            $this->transactionid->EditCustomAttributes = "";
            if (!$this->transactionid->Raw) {
                $this->transactionid->CurrentValue = HtmlDecode($this->transactionid->CurrentValue);
            }
            $this->transactionid->EditValue = HtmlEncode($this->transactionid->CurrentValue);
            $this->transactionid->PlaceHolder = RemoveHtml($this->transactionid->caption());

            // url
            $this->url->EditAttrs["class"] = "form-control";
            $this->url->EditCustomAttributes = "";
            if (!$this->url->Raw) {
                $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
            }
            $this->url->EditValue = HtmlEncode($this->url->CurrentValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());

            // Prev_Custodian_id
            $this->Prev_Custodian_id->EditAttrs["class"] = "form-control";
            $this->Prev_Custodian_id->EditCustomAttributes = "";
            $this->Prev_Custodian_id->EditValue = HtmlEncode($this->Prev_Custodian_id->CurrentValue);
            $this->Prev_Custodian_id->PlaceHolder = RemoveHtml($this->Prev_Custodian_id->caption());

            // Edit refer script

            // verifyassetid
            $this->verifyassetid->LinkCustomAttributes = "";
            $this->verifyassetid->HrefValue = "";

            // asset_id
            $this->asset_id->LinkCustomAttributes = "";
            $this->asset_id->HrefValue = "";

            // reassignerid
            $this->reassignerid->LinkCustomAttributes = "";
            $this->reassignerid->HrefValue = "";

            // reciverid
            $this->reciverid->LinkCustomAttributes = "";
            $this->reciverid->HrefValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";

            // status
            $this->status->LinkCustomAttributes = "";
            $this->status->HrefValue = "";

            // transactionid
            $this->transactionid->LinkCustomAttributes = "";
            $this->transactionid->HrefValue = "";

            // url
            $this->url->LinkCustomAttributes = "";
            $this->url->HrefValue = "";

            // Prev_Custodian_id
            $this->Prev_Custodian_id->LinkCustomAttributes = "";
            $this->Prev_Custodian_id->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->verifyassetid->Required) {
            if (!$this->verifyassetid->IsDetailKey && EmptyValue($this->verifyassetid->FormValue)) {
                $this->verifyassetid->addErrorMessage(str_replace("%s", $this->verifyassetid->caption(), $this->verifyassetid->RequiredErrorMessage));
            }
        }
        if ($this->asset_id->Required) {
            if (!$this->asset_id->IsDetailKey && EmptyValue($this->asset_id->FormValue)) {
                $this->asset_id->addErrorMessage(str_replace("%s", $this->asset_id->caption(), $this->asset_id->RequiredErrorMessage));
            }
        }
        if ($this->reassignerid->Required) {
            if (!$this->reassignerid->IsDetailKey && EmptyValue($this->reassignerid->FormValue)) {
                $this->reassignerid->addErrorMessage(str_replace("%s", $this->reassignerid->caption(), $this->reassignerid->RequiredErrorMessage));
            }
        }
        if ($this->reciverid->Required) {
            if (!$this->reciverid->IsDetailKey && EmptyValue($this->reciverid->FormValue)) {
                $this->reciverid->addErrorMessage(str_replace("%s", $this->reciverid->caption(), $this->reciverid->RequiredErrorMessage));
            }
        }
        if ($this->MDA_id->Required) {
            if (!$this->MDA_id->IsDetailKey && EmptyValue($this->MDA_id->FormValue)) {
                $this->MDA_id->addErrorMessage(str_replace("%s", $this->MDA_id->caption(), $this->MDA_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->MDA_id->FormValue)) {
            $this->MDA_id->addErrorMessage($this->MDA_id->getErrorMessage(false));
        }
        if ($this->Created_on->Required) {
            if (!$this->Created_on->IsDetailKey && EmptyValue($this->Created_on->FormValue)) {
                $this->Created_on->addErrorMessage(str_replace("%s", $this->Created_on->caption(), $this->Created_on->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->Created_on->FormValue)) {
            $this->Created_on->addErrorMessage($this->Created_on->getErrorMessage(false));
        }
        if ($this->status->Required) {
            if ($this->status->FormValue == "") {
                $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
            }
        }
        if ($this->transactionid->Required) {
            if (!$this->transactionid->IsDetailKey && EmptyValue($this->transactionid->FormValue)) {
                $this->transactionid->addErrorMessage(str_replace("%s", $this->transactionid->caption(), $this->transactionid->RequiredErrorMessage));
            }
        }
        if ($this->url->Required) {
            if (!$this->url->IsDetailKey && EmptyValue($this->url->FormValue)) {
                $this->url->addErrorMessage(str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
            }
        }
        if ($this->Prev_Custodian_id->Required) {
            if (!$this->Prev_Custodian_id->IsDetailKey && EmptyValue($this->Prev_Custodian_id->FormValue)) {
                $this->Prev_Custodian_id->addErrorMessage(str_replace("%s", $this->Prev_Custodian_id->caption(), $this->Prev_Custodian_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->Prev_Custodian_id->FormValue)) {
            $this->Prev_Custodian_id->addErrorMessage($this->Prev_Custodian_id->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssoc($sql);
        $editRow = false;
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            $editRow = false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
            $rsnew = [];

            // asset_id
            $this->asset_id->setDbValueDef($rsnew, $this->asset_id->CurrentValue, 0, $this->asset_id->ReadOnly);

            // reassignerid
            $this->reassignerid->setDbValueDef($rsnew, $this->reassignerid->CurrentValue, 0, $this->reassignerid->ReadOnly);

            // reciverid
            $this->reciverid->setDbValueDef($rsnew, $this->reciverid->CurrentValue, 0, $this->reciverid->ReadOnly);

            // MDA_id
            $this->MDA_id->setDbValueDef($rsnew, $this->MDA_id->CurrentValue, 0, $this->MDA_id->ReadOnly);

            // Created_on
            $this->Created_on->setDbValueDef($rsnew, UnFormatDateTime($this->Created_on->CurrentValue, 0), null, $this->Created_on->ReadOnly);

            // status
            $tmpBool = $this->status->CurrentValue;
            if ($tmpBool != "1" && $tmpBool != "0") {
                $tmpBool = !empty($tmpBool) ? "1" : "0";
            }
            $this->status->setDbValueDef($rsnew, $tmpBool, 0, $this->status->ReadOnly);

            // transactionid
            $this->transactionid->setDbValueDef($rsnew, $this->transactionid->CurrentValue, "", $this->transactionid->ReadOnly);

            // url
            $this->url->setDbValueDef($rsnew, $this->url->CurrentValue, "", $this->url->ReadOnly);

            // Prev_Custodian_id
            $this->Prev_Custodian_id->setDbValueDef($rsnew, $this->Prev_Custodian_id->CurrentValue, 0, $this->Prev_Custodian_id->ReadOnly);

            // Call Row Updating event
            $updateRow = $this->rowUpdating($rsold, $rsnew);
            if ($updateRow) {
                if (count($rsnew) > 0) {
                    try {
                        $editRow = $this->update($rsnew, "", $rsold);
                    } catch (\Exception $e) {
                        $this->setFailureMessage($e->getMessage());
                    }
                } else {
                    $editRow = true; // No field to update
                }
                if ($editRow) {
                }
            } else {
                if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                    // Use the message, do nothing
                } elseif ($this->CancelMessage != "") {
                    $this->setFailureMessage($this->CancelMessage);
                    $this->CancelMessage = "";
                } else {
                    $this->setFailureMessage($Language->phrase("UpdateCancelled"));
                }
                $editRow = false;
            }
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($editRow) {
        }

        // Write JSON for API request
        if (IsApi() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $editRow;
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->MDA_id->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("custodianmovementtbllist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_asset_id":
                    break;
                case "x_reassignerid":
                    break;
                case "x_reciverid":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
