<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class AssetstblSearch extends Assetstbl
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'assetstbl';

    // Page object name
    public $PageObjName = "AssetstblSearch";

    // Rendering View
    public $RenderingView = false;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (assetstbl)
        if (!isset($GLOBALS["assetstbl"]) || get_class($GLOBALS["assetstbl"]) == PROJECT_NAMESPACE . "assetstbl") {
            $GLOBALS["assetstbl"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'assetstbl');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("assetstbl"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "assetstblview") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['Assetsid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->Assetsid->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->Assetsid->setVisibility();
        $this->MDA_Parent->setVisibility();
        $this->MDA_id->setVisibility();
        $this->Location_id->setVisibility();
        $this->Asset_Status->setVisibility();
        $this->Category_Temp->setVisibility();
        $this->Make->setVisibility();
        $this->Model->setVisibility();
        $this->YearofManufacture->setVisibility();
        $this->Colour->setVisibility();
        $this->EngineNumber->setVisibility();
        $this->ChasisNumber->setVisibility();
        $this->CivilianPlateNumber->setVisibility();
        $this->GovtPlateNumber->setVisibility();
        $this->Asset_No->setVisibility();
        $this->Details_of_Asset->setVisibility();
        $this->Condition_Of_Asset->setVisibility();
        $this->Custodian_id->setVisibility();
        $this->Category->setVisibility();
        $this->Category_Details->setVisibility();
        $this->Date_of_Acquisition->setVisibility();
        $this->Aquistion_Cost->setVisibility();
        $this->Additional_Cost->setVisibility();
        $this->Revaluation_Cost->setVisibility();
        $this->Remarks->setVisibility();
        $this->Created_on->setVisibility();
        $this->Updated_on->setVisibility();
        $this->Created_By->setVisibility();
        $this->MDA_temp->setVisibility();
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->MDA_Parent);
        $this->setupLookupOptions($this->MDA_id);
        $this->setupLookupOptions($this->Location_id);
        $this->setupLookupOptions($this->Asset_Status);
        $this->setupLookupOptions($this->Category_Temp);
        $this->setupLookupOptions($this->Make);
        $this->setupLookupOptions($this->Model);
        $this->setupLookupOptions($this->Condition_Of_Asset);
        $this->setupLookupOptions($this->Custodian_id);
        $this->setupLookupOptions($this->Category);
        $this->setupLookupOptions($this->Category_Details);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        if ($this->isPageRequest()) {
            // Get action
            $this->CurrentAction = Post("action");
            if ($this->isSearch()) {
                // Build search string for advanced search, remove blank field
                $this->loadSearchValues(); // Get search values
                if ($this->validateSearch()) {
                    $srchStr = $this->buildAdvancedSearch();
                } else {
                    $srchStr = "";
                }
                if ($srchStr != "") {
                    $srchStr = $this->getUrlParm($srchStr);
                    $srchStr = "assetstbllist" . "?" . $srchStr;
                    $this->terminate($srchStr); // Go to list page
                    return;
                }
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = ROWTYPE_SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->Assetsid); // Assetsid
        $this->buildSearchUrl($srchUrl, $this->MDA_Parent); // MDA_Parent
        $this->buildSearchUrl($srchUrl, $this->MDA_id); // MDA_id
        $this->buildSearchUrl($srchUrl, $this->Location_id); // Location_id
        $this->buildSearchUrl($srchUrl, $this->Asset_Status); // Asset_Status
        $this->buildSearchUrl($srchUrl, $this->Category_Temp); // Category_Temp
        $this->buildSearchUrl($srchUrl, $this->Make); // Make
        $this->buildSearchUrl($srchUrl, $this->Model); // Model
        $this->buildSearchUrl($srchUrl, $this->YearofManufacture); // Year of Manufacture
        $this->buildSearchUrl($srchUrl, $this->Colour); // Colour
        $this->buildSearchUrl($srchUrl, $this->EngineNumber); // Engine Number
        $this->buildSearchUrl($srchUrl, $this->ChasisNumber); // Chasis Number
        $this->buildSearchUrl($srchUrl, $this->CivilianPlateNumber); // Civilian Plate Number
        $this->buildSearchUrl($srchUrl, $this->GovtPlateNumber); // Govt Plate Number
        $this->buildSearchUrl($srchUrl, $this->Asset_No); // Asset_No
        $this->buildSearchUrl($srchUrl, $this->Details_of_Asset); // Details_of_Asset
        $this->buildSearchUrl($srchUrl, $this->Condition_Of_Asset); // Condition_Of_Asset
        $this->buildSearchUrl($srchUrl, $this->Custodian_id); // Custodian_id
        $this->buildSearchUrl($srchUrl, $this->Category); // Category
        $this->buildSearchUrl($srchUrl, $this->Category_Details); // Category_Details
        $this->buildSearchUrl($srchUrl, $this->Date_of_Acquisition); // Date_of_Acquisition
        $this->buildSearchUrl($srchUrl, $this->Aquistion_Cost); // Aquistion_Cost
        $this->buildSearchUrl($srchUrl, $this->Additional_Cost); // Additional_Cost
        $this->buildSearchUrl($srchUrl, $this->Revaluation_Cost); // Revaluation_Cost
        $this->buildSearchUrl($srchUrl, $this->Remarks); // Remarks
        $this->buildSearchUrl($srchUrl, $this->Created_on); // Created_on
        $this->buildSearchUrl($srchUrl, $this->Updated_on); // Updated_on
        $this->buildSearchUrl($srchUrl, $this->Created_By); // Created_By
        $this->buildSearchUrl($srchUrl, $this->MDA_temp); // MDA_temp
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, &$fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        $fldVal = $CurrentForm->getValue("x_$fldParm");
        $fldOpr = $CurrentForm->getValue("z_$fldParm");
        $fldCond = $CurrentForm->getValue("v_$fldParm");
        $fldVal2 = $CurrentForm->getValue("y_$fldParm");
        $fldOpr2 = $CurrentForm->getValue("w_$fldParm");
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldOpr = strtoupper(trim($fldOpr));
        $fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
        if ($fldOpr == "BETWEEN") {
            $isValidValue = ($fldDataType != DATATYPE_NUMBER) ||
                ($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
                    "&y_" . $fldParm . "=" . urlencode($fldVal2) .
                    "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = ($fldDataType != DATATYPE_NUMBER) ||
                ($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr, $fldDataType)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
                    "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr, $fldDataType))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = ($fldDataType != DATATYPE_NUMBER) ||
                ($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2, $fldDataType)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
                    "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2, $fldDataType))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Check if search value is numeric
    protected function searchValueIsNumeric($fld, $value)
    {
        if (IsFloatFormat($fld->Type)) {
            $value = ConvertToFloatString($value);
        }
        return is_numeric($value);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;
        if ($this->Assetsid->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->MDA_Parent->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->MDA_id->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Location_id->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Asset_Status->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Category_Temp->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Make->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Model->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->YearofManufacture->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Colour->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->EngineNumber->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->ChasisNumber->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->CivilianPlateNumber->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->GovtPlateNumber->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Asset_No->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Details_of_Asset->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Condition_Of_Asset->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Custodian_id->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Category->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if (is_array($this->Category->AdvancedSearch->SearchValue)) {
            $this->Category->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue);
        }
        if (is_array($this->Category->AdvancedSearch->SearchValue2)) {
            $this->Category->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue2);
        }
        if ($this->Category_Details->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Date_of_Acquisition->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Aquistion_Cost->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Additional_Cost->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Revaluation_Cost->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Remarks->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Created_on->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Updated_on->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->Created_By->AdvancedSearch->post()) {
            $hasValue = true;
        }
        if ($this->MDA_temp->AdvancedSearch->post()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Convert decimal values if posted back
        if ($this->Aquistion_Cost->FormValue == $this->Aquistion_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Aquistion_Cost->CurrentValue))) {
            $this->Aquistion_Cost->CurrentValue = ConvertToFloatString($this->Aquistion_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Additional_Cost->FormValue == $this->Additional_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Additional_Cost->CurrentValue))) {
            $this->Additional_Cost->CurrentValue = ConvertToFloatString($this->Additional_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Revaluation_Cost->FormValue == $this->Revaluation_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Revaluation_Cost->CurrentValue))) {
            $this->Revaluation_Cost->CurrentValue = ConvertToFloatString($this->Revaluation_Cost->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Assetsid

        // MDA_Parent

        // MDA_id

        // Location_id

        // Asset_Status

        // Category_Temp

        // Make

        // Model

        // Year of Manufacture

        // Colour

        // Engine Number

        // Chasis Number

        // Civilian Plate Number

        // Govt Plate Number

        // Asset_No

        // Details_of_Asset

        // Condition_Of_Asset

        // Custodian_id

        // Category

        // Category_Details

        // Date_of_Acquisition

        // Aquistion_Cost

        // Additional_Cost

        // Revaluation_Cost

        // Remarks

        // Created_on

        // Updated_on

        // Created_By

        // MDA_temp
        if ($this->RowType == ROWTYPE_VIEW) {
            // Assetsid
            $this->Assetsid->ViewValue = $this->Assetsid->CurrentValue;
            $this->Assetsid->CellCssStyle .= "text-align: right;";
            $this->Assetsid->ViewCustomAttributes = "";

            // MDA_Parent
            $curVal = strval($this->MDA_Parent->CurrentValue);
            if ($curVal != "") {
                $this->MDA_Parent->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
                if ($this->MDA_Parent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Parent`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->MDA_Parent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_Parent->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_Parent->ViewValue = $this->MDA_Parent->displayValue($arwrk);
                    } else {
                        $this->MDA_Parent->ViewValue = $this->MDA_Parent->CurrentValue;
                    }
                }
            } else {
                $this->MDA_Parent->ViewValue = null;
            }
            $this->MDA_Parent->ViewCustomAttributes = "";

            // MDA_id
            $curVal = strval($this->MDA_id->CurrentValue);
            if ($curVal != "") {
                $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->ViewValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";

            // Location_id
            $curVal = strval($this->Location_id->CurrentValue);
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->ViewValue = null;
            }
            $this->Location_id->ViewCustomAttributes = "";

            // Asset_Status
            $curVal = strval($this->Asset_Status->CurrentValue);
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
                if ($this->Asset_Status->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Asset_Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Asset_Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Asset_Status->ViewValue = $this->Asset_Status->displayValue($arwrk);
                    } else {
                        $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
                    }
                }
            } else {
                $this->Asset_Status->ViewValue = null;
            }
            $this->Asset_Status->ViewCustomAttributes = "";

            // Category_Temp
            $curVal = strval($this->Category_Temp->CurrentValue);
            if ($curVal != "") {
                $this->Category_Temp->ViewValue = $this->Category_Temp->lookupCacheOption($curVal);
                if ($this->Category_Temp->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Category_Temp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category_Temp->Lookup->renderViewRow($rswrk[0]);
                        $this->Category_Temp->ViewValue = $this->Category_Temp->displayValue($arwrk);
                    } else {
                        $this->Category_Temp->ViewValue = $this->Category_Temp->CurrentValue;
                    }
                }
            } else {
                $this->Category_Temp->ViewValue = null;
            }
            $this->Category_Temp->ViewCustomAttributes = "";

            // Make
            $curVal = strval($this->Make->CurrentValue);
            if ($curVal != "") {
                $this->Make->ViewValue = $this->Make->lookupCacheOption($curVal);
                if ($this->Make->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Make->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Make->Lookup->renderViewRow($rswrk[0]);
                        $this->Make->ViewValue = $this->Make->displayValue($arwrk);
                    } else {
                        $this->Make->ViewValue = $this->Make->CurrentValue;
                    }
                }
            } else {
                $this->Make->ViewValue = null;
            }
            $this->Make->ViewCustomAttributes = "";

            // Model
            $curVal = strval($this->Model->CurrentValue);
            if ($curVal != "") {
                $this->Model->ViewValue = $this->Model->lookupCacheOption($curVal);
                if ($this->Model->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Model->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Model->Lookup->renderViewRow($rswrk[0]);
                        $this->Model->ViewValue = $this->Model->displayValue($arwrk);
                    } else {
                        $this->Model->ViewValue = $this->Model->CurrentValue;
                    }
                }
            } else {
                $this->Model->ViewValue = null;
            }
            $this->Model->ViewCustomAttributes = "";

            // Year of Manufacture
            $this->YearofManufacture->ViewValue = $this->YearofManufacture->CurrentValue;
            $this->YearofManufacture->ViewCustomAttributes = "";

            // Colour
            $this->Colour->ViewValue = $this->Colour->CurrentValue;
            $this->Colour->ViewCustomAttributes = "";

            // Engine Number
            $this->EngineNumber->ViewValue = $this->EngineNumber->CurrentValue;
            $this->EngineNumber->ViewCustomAttributes = "";

            // Chasis Number
            $this->ChasisNumber->ViewValue = $this->ChasisNumber->CurrentValue;
            $this->ChasisNumber->ViewCustomAttributes = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->ViewValue = $this->CivilianPlateNumber->CurrentValue;
            $this->CivilianPlateNumber->ViewCustomAttributes = "";

            // Govt Plate Number
            $this->GovtPlateNumber->ViewValue = $this->GovtPlateNumber->CurrentValue;
            $this->GovtPlateNumber->ViewCustomAttributes = "";

            // Asset_No
            $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
            $this->Asset_No->ViewCustomAttributes = "";

            // Details_of_Asset
            $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->CellCssStyle .= "text-align: left;";
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Condition_Of_Asset
            $curVal = strval($this->Condition_Of_Asset->CurrentValue);
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
                if ($this->Condition_Of_Asset->ViewValue === null) { // Lookup from database
                    $filterWrk = "`status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Condition_Of_Asset->Lookup->renderViewRow($rswrk[0]);
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->displayValue($arwrk);
                    } else {
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
                    }
                }
            } else {
                $this->Condition_Of_Asset->ViewValue = null;
            }
            $this->Condition_Of_Asset->ViewCustomAttributes = "";

            // Custodian_id
            $curVal = strval($this->Custodian_id->CurrentValue);
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
                if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                    } else {
                        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                    }
                }
            } else {
                $this->Custodian_id->ViewValue = null;
            }
            $this->Custodian_id->ViewCustomAttributes = "";

            // Category
            $curVal = strval($this->Category->CurrentValue);
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Category->Lookup->renderViewRow($row);
                            $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                        }
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }
            $this->Category->CellCssStyle .= "text-align: left;";
            $this->Category->ViewCustomAttributes = "";

            // Category_Details
            $curVal = strval($this->Category_Details->CurrentValue);
            if ($curVal != "") {
                $this->Category_Details->ViewValue = $this->Category_Details->lookupCacheOption($curVal);
                if ($this->Category_Details->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Category_Details->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category_Details->Lookup->renderViewRow($rswrk[0]);
                        $this->Category_Details->ViewValue = $this->Category_Details->displayValue($arwrk);
                    } else {
                        $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
                    }
                }
            } else {
                $this->Category_Details->ViewValue = null;
            }
            $this->Category_Details->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -1, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // Remarks
            $this->Remarks->ViewValue = $this->Remarks->CurrentValue;
            $this->Remarks->CellCssStyle .= "text-align: left;";
            $this->Remarks->ViewCustomAttributes = "";

            // Created_on
            $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
            $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
            $this->Created_on->ViewCustomAttributes = "";

            // Updated_on
            $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
            $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
            $this->Updated_on->ViewCustomAttributes = "";

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;
            $this->Created_By->ViewValue = FormatNumber($this->Created_By->ViewValue, 0, -2, -2, -2);
            $this->Created_By->ViewCustomAttributes = "";

            // MDA_temp
            $this->MDA_temp->ViewValue = $this->MDA_temp->CurrentValue;
            $this->MDA_temp->ViewCustomAttributes = "";

            // Assetsid
            $this->Assetsid->LinkCustomAttributes = "";
            $this->Assetsid->HrefValue = "";
            $this->Assetsid->TooltipValue = "";

            // MDA_Parent
            $this->MDA_Parent->LinkCustomAttributes = "";
            $this->MDA_Parent->HrefValue = "";
            $this->MDA_Parent->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";
            $this->Asset_Status->TooltipValue = "";

            // Category_Temp
            $this->Category_Temp->LinkCustomAttributes = "";
            $this->Category_Temp->HrefValue = "";
            $this->Category_Temp->TooltipValue = "";

            // Make
            $this->Make->LinkCustomAttributes = "";
            $this->Make->HrefValue = "";
            $this->Make->TooltipValue = "";

            // Model
            $this->Model->LinkCustomAttributes = "";
            $this->Model->HrefValue = "";
            $this->Model->TooltipValue = "";

            // Year of Manufacture
            $this->YearofManufacture->LinkCustomAttributes = "";
            $this->YearofManufacture->HrefValue = "";
            $this->YearofManufacture->TooltipValue = "";

            // Colour
            $this->Colour->LinkCustomAttributes = "";
            $this->Colour->HrefValue = "";
            $this->Colour->TooltipValue = "";

            // Engine Number
            $this->EngineNumber->LinkCustomAttributes = "";
            $this->EngineNumber->HrefValue = "";
            $this->EngineNumber->TooltipValue = "";

            // Chasis Number
            $this->ChasisNumber->LinkCustomAttributes = "";
            $this->ChasisNumber->HrefValue = "";
            $this->ChasisNumber->TooltipValue = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->LinkCustomAttributes = "";
            $this->CivilianPlateNumber->HrefValue = "";
            $this->CivilianPlateNumber->TooltipValue = "";

            // Govt Plate Number
            $this->GovtPlateNumber->LinkCustomAttributes = "";
            $this->GovtPlateNumber->HrefValue = "";
            $this->GovtPlateNumber->TooltipValue = "";

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";
            $this->Asset_No->TooltipValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";
            $this->Condition_Of_Asset->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";
            $this->Custodian_id->TooltipValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";

            // Remarks
            $this->Remarks->LinkCustomAttributes = "";
            $this->Remarks->HrefValue = "";
            $this->Remarks->TooltipValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
            $this->Created_on->TooltipValue = "";

            // Updated_on
            $this->Updated_on->LinkCustomAttributes = "";
            $this->Updated_on->HrefValue = "";
            $this->Updated_on->TooltipValue = "";

            // Created_By
            $this->Created_By->LinkCustomAttributes = "";
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // MDA_temp
            $this->MDA_temp->LinkCustomAttributes = "";
            $this->MDA_temp->HrefValue = "";
            $this->MDA_temp->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // Assetsid
            $this->Assetsid->EditAttrs["class"] = "form-control";
            $this->Assetsid->EditCustomAttributes = "";
            $this->Assetsid->EditValue = HtmlEncode($this->Assetsid->AdvancedSearch->SearchValue);
            $this->Assetsid->PlaceHolder = RemoveHtml($this->Assetsid->caption());

            // MDA_Parent
            $this->MDA_Parent->EditAttrs["class"] = "form-control";
            $this->MDA_Parent->EditCustomAttributes = "";
            $curVal = trim(strval($this->MDA_Parent->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->MDA_Parent->AdvancedSearch->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
            } else {
                $this->MDA_Parent->AdvancedSearch->ViewValue = $this->MDA_Parent->Lookup !== null && is_array($this->MDA_Parent->Lookup->Options) ? $curVal : null;
            }
            if ($this->MDA_Parent->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->MDA_Parent->EditValue = array_values($this->MDA_Parent->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Parent`" . SearchString("=", $this->MDA_Parent->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->MDA_Parent->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->MDA_Parent->EditValue = $arwrk;
            }
            $this->MDA_Parent->PlaceHolder = RemoveHtml($this->MDA_Parent->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("search")) { // Non system admin
                $this->MDA_id->AdvancedSearch->SearchValue = CurrentUserID();
                $curVal = strval($this->MDA_id->AdvancedSearch->SearchValue);
                if ($curVal != "") {
                    $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                    if ($this->MDA_id->EditValue === null) { // Lookup from database
                        $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                            $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                        } else {
                            $this->MDA_id->EditValue = $this->MDA_id->AdvancedSearch->SearchValue;
                        }
                    }
                } else {
                    $this->MDA_id->EditValue = null;
                }
                $this->MDA_id->ViewCustomAttributes = "";
            } else {
                $curVal = trim(strval($this->MDA_id->AdvancedSearch->SearchValue));
                if ($curVal != "") {
                    $this->MDA_id->AdvancedSearch->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                } else {
                    $this->MDA_id->AdvancedSearch->ViewValue = $this->MDA_id->Lookup !== null && is_array($this->MDA_id->Lookup->Options) ? $curVal : null;
                }
                if ($this->MDA_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                    $this->MDA_id->EditValue = array_values($this->MDA_id->Lookup->Options);
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = "`MDAID`" . SearchString("=", $this->MDA_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->MDA_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->MDA_id->EditValue = $arwrk;
                }
                $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
            }

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Location_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Location_id->AdvancedSearch->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            } else {
                $this->Location_id->AdvancedSearch->ViewValue = $this->Location_id->Lookup !== null && is_array($this->Location_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Location_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Location_id->EditValue = array_values($this->Location_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Locationid`" . SearchString("=", $this->Location_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Location_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Location_id->EditValue = $arwrk;
            }
            $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            $curVal = trim(strval($this->Asset_Status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Asset_Status->AdvancedSearch->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            } else {
                $this->Asset_Status->AdvancedSearch->ViewValue = $this->Asset_Status->Lookup !== null && is_array($this->Asset_Status->Lookup->Options) ? $curVal : null;
            }
            if ($this->Asset_Status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Asset_Status->EditValue = array_values($this->Asset_Status->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Status`" . SearchString("=", $this->Asset_Status->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Asset_Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Asset_Status->EditValue = $arwrk;
            }
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Category_Temp
            $this->Category_Temp->EditAttrs["class"] = "form-control";
            $this->Category_Temp->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category_Temp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Category_Temp->AdvancedSearch->ViewValue = $this->Category_Temp->lookupCacheOption($curVal);
            } else {
                $this->Category_Temp->AdvancedSearch->ViewValue = $this->Category_Temp->Lookup !== null && is_array($this->Category_Temp->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category_Temp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Category_Temp->EditValue = array_values($this->Category_Temp->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Category_Details`" . SearchString("=", $this->Category_Temp->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Category_Temp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category_Temp->EditValue = $arwrk;
            }
            $this->Category_Temp->PlaceHolder = RemoveHtml($this->Category_Temp->caption());

            // Make
            $this->Make->EditAttrs["class"] = "form-control";
            $this->Make->EditCustomAttributes = "";
            $curVal = trim(strval($this->Make->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Make->AdvancedSearch->ViewValue = $this->Make->lookupCacheOption($curVal);
            } else {
                $this->Make->AdvancedSearch->ViewValue = $this->Make->Lookup !== null && is_array($this->Make->Lookup->Options) ? $curVal : null;
            }
            if ($this->Make->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Make->EditValue = array_values($this->Make->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->Make->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Make->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Make->EditValue = $arwrk;
            }
            $this->Make->PlaceHolder = RemoveHtml($this->Make->caption());

            // Model
            $this->Model->EditAttrs["class"] = "form-control";
            $this->Model->EditCustomAttributes = "";
            $curVal = trim(strval($this->Model->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Model->AdvancedSearch->ViewValue = $this->Model->lookupCacheOption($curVal);
            } else {
                $this->Model->AdvancedSearch->ViewValue = $this->Model->Lookup !== null && is_array($this->Model->Lookup->Options) ? $curVal : null;
            }
            if ($this->Model->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Model->EditValue = array_values($this->Model->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->Model->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Model->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Model->EditValue = $arwrk;
            }
            $this->Model->PlaceHolder = RemoveHtml($this->Model->caption());

            // Year of Manufacture
            $this->YearofManufacture->EditAttrs["class"] = "form-control";
            $this->YearofManufacture->EditCustomAttributes = "";
            $this->YearofManufacture->EditValue = HtmlEncode($this->YearofManufacture->AdvancedSearch->SearchValue);
            $this->YearofManufacture->PlaceHolder = RemoveHtml($this->YearofManufacture->caption());

            // Colour
            $this->Colour->EditAttrs["class"] = "form-control";
            $this->Colour->EditCustomAttributes = "";
            if (!$this->Colour->Raw) {
                $this->Colour->AdvancedSearch->SearchValue = HtmlDecode($this->Colour->AdvancedSearch->SearchValue);
            }
            $this->Colour->EditValue = HtmlEncode($this->Colour->AdvancedSearch->SearchValue);
            $this->Colour->PlaceHolder = RemoveHtml($this->Colour->caption());

            // Engine Number
            $this->EngineNumber->EditAttrs["class"] = "form-control";
            $this->EngineNumber->EditCustomAttributes = "";
            if (!$this->EngineNumber->Raw) {
                $this->EngineNumber->AdvancedSearch->SearchValue = HtmlDecode($this->EngineNumber->AdvancedSearch->SearchValue);
            }
            $this->EngineNumber->EditValue = HtmlEncode($this->EngineNumber->AdvancedSearch->SearchValue);
            $this->EngineNumber->PlaceHolder = RemoveHtml($this->EngineNumber->caption());

            // Chasis Number
            $this->ChasisNumber->EditAttrs["class"] = "form-control";
            $this->ChasisNumber->EditCustomAttributes = "";
            if (!$this->ChasisNumber->Raw) {
                $this->ChasisNumber->AdvancedSearch->SearchValue = HtmlDecode($this->ChasisNumber->AdvancedSearch->SearchValue);
            }
            $this->ChasisNumber->EditValue = HtmlEncode($this->ChasisNumber->AdvancedSearch->SearchValue);
            $this->ChasisNumber->PlaceHolder = RemoveHtml($this->ChasisNumber->caption());

            // Civilian Plate Number
            $this->CivilianPlateNumber->EditAttrs["class"] = "form-control";
            $this->CivilianPlateNumber->EditCustomAttributes = "";
            if (!$this->CivilianPlateNumber->Raw) {
                $this->CivilianPlateNumber->AdvancedSearch->SearchValue = HtmlDecode($this->CivilianPlateNumber->AdvancedSearch->SearchValue);
            }
            $this->CivilianPlateNumber->EditValue = HtmlEncode($this->CivilianPlateNumber->AdvancedSearch->SearchValue);
            $this->CivilianPlateNumber->PlaceHolder = RemoveHtml($this->CivilianPlateNumber->caption());

            // Govt Plate Number
            $this->GovtPlateNumber->EditAttrs["class"] = "form-control";
            $this->GovtPlateNumber->EditCustomAttributes = "";
            if (!$this->GovtPlateNumber->Raw) {
                $this->GovtPlateNumber->AdvancedSearch->SearchValue = HtmlDecode($this->GovtPlateNumber->AdvancedSearch->SearchValue);
            }
            $this->GovtPlateNumber->EditValue = HtmlEncode($this->GovtPlateNumber->AdvancedSearch->SearchValue);
            $this->GovtPlateNumber->PlaceHolder = RemoveHtml($this->GovtPlateNumber->caption());

            // Asset_No
            $this->Asset_No->EditAttrs["class"] = "form-control";
            $this->Asset_No->EditCustomAttributes = "";
            if (!$this->Asset_No->Raw) {
                $this->Asset_No->AdvancedSearch->SearchValue = HtmlDecode($this->Asset_No->AdvancedSearch->SearchValue);
            }
            $this->Asset_No->EditValue = HtmlEncode($this->Asset_No->AdvancedSearch->SearchValue);
            $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

            // Details_of_Asset
            $this->Details_of_Asset->EditAttrs["class"] = "form-control";
            $this->Details_of_Asset->EditCustomAttributes = "";
            if (!$this->Details_of_Asset->Raw) {
                $this->Details_of_Asset->AdvancedSearch->SearchValue = HtmlDecode($this->Details_of_Asset->AdvancedSearch->SearchValue);
            }
            $this->Details_of_Asset->EditValue = HtmlEncode($this->Details_of_Asset->AdvancedSearch->SearchValue);
            $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            $curVal = trim(strval($this->Condition_Of_Asset->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->AdvancedSearch->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            } else {
                $this->Condition_Of_Asset->AdvancedSearch->ViewValue = $this->Condition_Of_Asset->Lookup !== null && is_array($this->Condition_Of_Asset->Lookup->Options) ? $curVal : null;
            }
            if ($this->Condition_Of_Asset->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Condition_Of_Asset->EditValue = array_values($this->Condition_Of_Asset->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`status`" . SearchString("=", $this->Condition_Of_Asset->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Condition_Of_Asset->EditValue = $arwrk;
            }
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Custodian_id
            $this->Custodian_id->EditAttrs["class"] = "form-control";
            $this->Custodian_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Custodian_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Custodian_id->AdvancedSearch->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            } else {
                $this->Custodian_id->AdvancedSearch->ViewValue = $this->Custodian_id->Lookup !== null && is_array($this->Custodian_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Custodian_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Custodian_id->EditValue = array_values($this->Custodian_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->Custodian_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Custodian_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Custodian_id->EditValue = $arwrk;
            }
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Category
            $this->Category->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Category->AdvancedSearch->ViewValue = $this->Category->lookupCacheOption($curVal);
            } else {
                $this->Category->AdvancedSearch->ViewValue = $this->Category->Lookup !== null && is_array($this->Category->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Category->EditValue = array_values($this->Category->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                }
                $sqlWrk = $this->Category->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category->EditValue = $arwrk;
            }
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category_Details->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Category_Details->AdvancedSearch->ViewValue = $this->Category_Details->lookupCacheOption($curVal);
            } else {
                $this->Category_Details->AdvancedSearch->ViewValue = $this->Category_Details->Lookup !== null && is_array($this->Category_Details->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category_Details->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Category_Details->EditValue = array_values($this->Category_Details->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Category_Details`" . SearchString("=", $this->Category_Details->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Category_Details->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category_Details->EditValue = $arwrk;
            }
            $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Date_of_Acquisition->AdvancedSearch->SearchValue, 0), 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Date_of_Acquisition->AdvancedSearch->SearchValue2, 0), 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = HtmlEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue2 = HtmlEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue2);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());

            // Additional_Cost
            $this->Additional_Cost->EditAttrs["class"] = "form-control";
            $this->Additional_Cost->EditCustomAttributes = "";
            $this->Additional_Cost->EditValue = HtmlEncode($this->Additional_Cost->AdvancedSearch->SearchValue);
            $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());

            // Revaluation_Cost
            $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
            $this->Revaluation_Cost->EditCustomAttributes = "";
            $this->Revaluation_Cost->EditValue = HtmlEncode($this->Revaluation_Cost->AdvancedSearch->SearchValue);
            $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());

            // Remarks
            $this->Remarks->EditAttrs["class"] = "form-control";
            $this->Remarks->EditCustomAttributes = "";
            $this->Remarks->EditValue = HtmlEncode($this->Remarks->AdvancedSearch->SearchValue);
            $this->Remarks->PlaceHolder = RemoveHtml($this->Remarks->caption());

            // Created_on
            $this->Created_on->EditAttrs["class"] = "form-control";
            $this->Created_on->EditCustomAttributes = "";
            $this->Created_on->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Created_on->AdvancedSearch->SearchValue, 0), 8));
            $this->Created_on->PlaceHolder = RemoveHtml($this->Created_on->caption());

            // Updated_on
            $this->Updated_on->EditAttrs["class"] = "form-control";
            $this->Updated_on->EditCustomAttributes = "";
            $this->Updated_on->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Updated_on->AdvancedSearch->SearchValue, 0), 8));
            $this->Updated_on->PlaceHolder = RemoveHtml($this->Updated_on->caption());

            // Created_By
            $this->Created_By->EditAttrs["class"] = "form-control";
            $this->Created_By->EditCustomAttributes = "";
            $this->Created_By->EditValue = HtmlEncode($this->Created_By->AdvancedSearch->SearchValue);
            $this->Created_By->PlaceHolder = RemoveHtml($this->Created_By->caption());

            // MDA_temp
            $this->MDA_temp->EditAttrs["class"] = "form-control";
            $this->MDA_temp->EditCustomAttributes = "";
            if (!$this->MDA_temp->Raw) {
                $this->MDA_temp->AdvancedSearch->SearchValue = HtmlDecode($this->MDA_temp->AdvancedSearch->SearchValue);
            }
            $this->MDA_temp->EditValue = HtmlEncode($this->MDA_temp->AdvancedSearch->SearchValue);
            $this->MDA_temp->PlaceHolder = RemoveHtml($this->MDA_temp->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->Assetsid->AdvancedSearch->SearchValue)) {
            $this->Assetsid->addErrorMessage($this->Assetsid->getErrorMessage(false));
        }
        if (!CheckInteger($this->YearofManufacture->AdvancedSearch->SearchValue)) {
            $this->YearofManufacture->addErrorMessage($this->YearofManufacture->getErrorMessage(false));
        }
        if (!CheckDate($this->Date_of_Acquisition->AdvancedSearch->SearchValue)) {
            $this->Date_of_Acquisition->addErrorMessage($this->Date_of_Acquisition->getErrorMessage(false));
        }
        if (!CheckDate($this->Date_of_Acquisition->AdvancedSearch->SearchValue2)) {
            $this->Date_of_Acquisition->addErrorMessage($this->Date_of_Acquisition->getErrorMessage(false));
        }
        if (!CheckNumber($this->Aquistion_Cost->AdvancedSearch->SearchValue)) {
            $this->Aquistion_Cost->addErrorMessage($this->Aquistion_Cost->getErrorMessage(false));
        }
        if (!CheckNumber($this->Aquistion_Cost->AdvancedSearch->SearchValue2)) {
            $this->Aquistion_Cost->addErrorMessage($this->Aquistion_Cost->getErrorMessage(false));
        }
        if (!CheckNumber($this->Additional_Cost->AdvancedSearch->SearchValue)) {
            $this->Additional_Cost->addErrorMessage($this->Additional_Cost->getErrorMessage(false));
        }
        if (!CheckNumber($this->Revaluation_Cost->AdvancedSearch->SearchValue)) {
            $this->Revaluation_Cost->addErrorMessage($this->Revaluation_Cost->getErrorMessage(false));
        }
        if (!CheckDate($this->Created_on->AdvancedSearch->SearchValue)) {
            $this->Created_on->addErrorMessage($this->Created_on->getErrorMessage(false));
        }
        if (!CheckDate($this->Updated_on->AdvancedSearch->SearchValue)) {
            $this->Updated_on->addErrorMessage($this->Updated_on->getErrorMessage(false));
        }
        if (!CheckInteger($this->Created_By->AdvancedSearch->SearchValue)) {
            $this->Created_By->addErrorMessage($this->Created_By->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->Assetsid->AdvancedSearch->load();
        $this->MDA_Parent->AdvancedSearch->load();
        $this->MDA_id->AdvancedSearch->load();
        $this->Location_id->AdvancedSearch->load();
        $this->Asset_Status->AdvancedSearch->load();
        $this->Category_Temp->AdvancedSearch->load();
        $this->Make->AdvancedSearch->load();
        $this->Model->AdvancedSearch->load();
        $this->YearofManufacture->AdvancedSearch->load();
        $this->Colour->AdvancedSearch->load();
        $this->EngineNumber->AdvancedSearch->load();
        $this->ChasisNumber->AdvancedSearch->load();
        $this->CivilianPlateNumber->AdvancedSearch->load();
        $this->GovtPlateNumber->AdvancedSearch->load();
        $this->Asset_No->AdvancedSearch->load();
        $this->Details_of_Asset->AdvancedSearch->load();
        $this->Condition_Of_Asset->AdvancedSearch->load();
        $this->Custodian_id->AdvancedSearch->load();
        $this->Category->AdvancedSearch->load();
        $this->Category_Details->AdvancedSearch->load();
        $this->Date_of_Acquisition->AdvancedSearch->load();
        $this->Aquistion_Cost->AdvancedSearch->load();
        $this->Additional_Cost->AdvancedSearch->load();
        $this->Revaluation_Cost->AdvancedSearch->load();
        $this->Remarks->AdvancedSearch->load();
        $this->Created_on->AdvancedSearch->load();
        $this->Updated_on->AdvancedSearch->load();
        $this->Created_By->AdvancedSearch->load();
        $this->MDA_temp->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("assetstbllist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MDA_Parent":
                    break;
                case "x_MDA_id":
                    break;
                case "x_Location_id":
                    break;
                case "x_Asset_Status":
                    break;
                case "x_Category_Temp":
                    break;
                case "x_Make":
                    break;
                case "x_Model":
                    break;
                case "x_Condition_Of_Asset":
                    break;
                case "x_Custodian_id":
                    break;
                case "x_Category":
                    break;
                case "x_Category_Details":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
