<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

// Page object
$DetailedReportSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentForm, currentPageID;
var fsummary, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready("head", function () {
    var $ = jQuery;
    // Form object for search
    fsummary = currentForm = new ew.Form("fsummary", "summary");
    currentPageID = ew.PAGE_ID = "summary";

    // Add fields
    var currentTable = <?= JsonEncode(GetClientVar("tables", "DetailedReport")) ?>,
        fields = currentTable.fields;
    fsummary.addFields([
        ["_23", [], fields._23.isInvalid],
        ["Assetsid", [], fields.Assetsid.isInvalid],
        ["MDA_Parent", [], fields.MDA_Parent.isInvalid],
        ["MDA_id", [], fields.MDA_id.isInvalid],
        ["Location_id", [], fields.Location_id.isInvalid],
        ["Details_of_Asset", [], fields.Details_of_Asset.isInvalid],
        ["Asset_Status", [], fields.Asset_Status.isInvalid],
        ["Condition_Of_Asset", [], fields.Condition_Of_Asset.isInvalid],
        ["Custodian_id", [], fields.Custodian_id.isInvalid],
        ["Category", [], fields.Category.isInvalid],
        ["Category_Details", [], fields.Category_Details.isInvalid],
        ["Date_of_Acquisition", [ew.Validators.datetime(0)], fields.Date_of_Acquisition.isInvalid],
        ["y_Date_of_Acquisition", [ew.Validators.between], false],
        ["Aquistion_Cost", [ew.Validators.float], fields.Aquistion_Cost.isInvalid],
        ["y_Aquistion_Cost", [ew.Validators.between], false],
        ["Additional_Cost", [], fields.Additional_Cost.isInvalid],
        ["Revaluation_Cost", [], fields.Revaluation_Cost.isInvalid]
    ]);

    // Set invalid fields
    $(function() {
        fsummary.setInvalid();
    });

    // Validate form
    fsummary.validate = function () {
        if (!this.validateRequired)
            return true; // Ignore validation
        var fobj = this.getForm(),
            $fobj = $(fobj),
            rowIndex = "";
        $fobj.data("rowindex", rowIndex);

        // Validate fields
        if (!this.validateFields(rowIndex))
            return false;

        // Call Form_CustomValidate event
        if (!this.customValidate(fobj)) {
            this.focus();
            return false;
        }
        return true;
    }

    // Form_CustomValidate
    fsummary.customValidate = function(fobj) { // DO NOT CHANGE THIS LINE!
        // Your custom validation code here, return false if invalid.
        return true;
    }

    // Use JavaScript validation or not
    fsummary.validateRequired = <?= Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

    // Dynamic selection lists
    fsummary.lists.MDA_Parent = <?= $Page->MDA_Parent->toClientList($Page) ?>;
    fsummary.lists.MDA_id = <?= $Page->MDA_id->toClientList($Page) ?>;
    fsummary.lists.Location_id = <?= $Page->Location_id->toClientList($Page) ?>;
    fsummary.lists.Asset_Status = <?= $Page->Asset_Status->toClientList($Page) ?>;
    fsummary.lists.Condition_Of_Asset = <?= $Page->Condition_Of_Asset->toClientList($Page) ?>;
    fsummary.lists.Custodian_id = <?= $Page->Custodian_id->toClientList($Page) ?>;
    fsummary.lists.Category = <?= $Page->Category->toClientList($Page) ?>;
    fsummary.lists.Category_Details = <?= $Page->Category_Details->toClientList($Page) ?>;

    // Filters
    fsummary.filterList = <?= $Page->getFilterList() ?>;
    loadjs.done("fsummary");
});
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    $("a.ew-export-link.ew-print").attr("target","_blank"),$("[data-name='MDA_Parent']").hide(),$("[data-field='MDA_Parent']").hide();
});
</script>
<?php } ?>
<a id="top"></a>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<div class="row">
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Center Container -->
<div id="ew-center" class="<?= $Page->CenterContentClass ?>">
<?php } ?>
<!-- Summary report (begin) -->
<?php if (!$Page->isExport("pdf")) { ?>
<div id="report_summary">
<?php } ?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !$Page->CurrentAction) { ?>
<form name="fsummary" id="fsummary" class="form-inline ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>">
<div id="fsummary-search-panel" class="<?= $Page->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="DetailedReport">
    <div class="ew-extended-search">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->MDA_Parent->Visible) { // MDA_Parent ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_MDA_Parent" class="ew-cell form-group">
        <label for="x_MDA_Parent" class="ew-search-caption ew-label"><?= $Page->MDA_Parent->caption() ?></label>
        <span id="el_DetailedReport_MDA_Parent" class="ew-search-field">
<?php $Page->MDA_Parent->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x_MDA_Parent"
        name="x_MDA_Parent"
        class="form-control ew-select<?= $Page->MDA_Parent->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_MDA_Parent"
        data-table="DetailedReport"
        data-field="x_MDA_Parent"
        data-value-separator="<?= $Page->MDA_Parent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MDA_Parent->getPlaceHolder()) ?>"
        <?= $Page->MDA_Parent->editAttributes() ?>>
        <?= $Page->MDA_Parent->selectOptionListHtml("x_MDA_Parent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MDA_Parent->getErrorMessage() ?></div>
<?= $Page->MDA_Parent->Lookup->getParamTag($Page, "p_x_MDA_Parent") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_MDA_Parent']"),
        options = { name: "x_MDA_Parent", selectId: "DetailedReport_x_MDA_Parent", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.MDA_Parent.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { // MDA_id ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_MDA_id" class="ew-cell form-group">
        <label for="x_MDA_id" class="ew-search-caption ew-label"><?= $Page->MDA_id->caption() ?></label>
        <span id="el_DetailedReport_MDA_id" class="ew-search-field">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$Page->userIDAllow("summary")) { // Non system admin ?>
<span<?= $Page->MDA_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->MDA_id->getDisplayValue($Page->MDA_id->EditValue))) ?>"></span>
<input type="hidden" data-table="DetailedReport" data-field="x_MDA_id" data-hidden="1" name="x_MDA_id" id="x_MDA_id" value="<?= HtmlEncode($Page->MDA_id->AdvancedSearch->SearchValue) ?>">
<?php } else { ?>
<?php $Page->MDA_id->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x_MDA_id"
        name="x_MDA_id"
        class="form-control ew-select<?= $Page->MDA_id->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_MDA_id"
        data-table="DetailedReport"
        data-field="x_MDA_id"
        data-value-separator="<?= $Page->MDA_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MDA_id->getPlaceHolder()) ?>"
        <?= $Page->MDA_id->editAttributes() ?>>
        <?= $Page->MDA_id->selectOptionListHtml("x_MDA_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MDA_id->getErrorMessage() ?></div>
<?= $Page->MDA_id->Lookup->getParamTag($Page, "p_x_MDA_id") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_MDA_id']"),
        options = { name: "x_MDA_id", selectId: "DetailedReport_x_MDA_id", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.MDA_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Location_id->Visible) { // Location_id ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Location_id" class="ew-cell form-group">
        <label for="x_Location_id" class="ew-search-caption ew-label"><?= $Page->Location_id->caption() ?></label>
        <span id="el_DetailedReport_Location_id" class="ew-search-field">
    <select
        id="x_Location_id"
        name="x_Location_id"
        class="form-control ew-select<?= $Page->Location_id->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_Location_id"
        data-table="DetailedReport"
        data-field="x_Location_id"
        data-value-separator="<?= $Page->Location_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Location_id->getPlaceHolder()) ?>"
        <?= $Page->Location_id->editAttributes() ?>>
        <?= $Page->Location_id->selectOptionListHtml("x_Location_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Location_id->getErrorMessage() ?></div>
<?= $Page->Location_id->Lookup->getParamTag($Page, "p_x_Location_id") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_Location_id']"),
        options = { name: "x_Location_id", selectId: "DetailedReport_x_Location_id", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.Location_id.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { // Asset_Status ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Asset_Status" class="ew-cell form-group">
        <label for="x_Asset_Status" class="ew-search-caption ew-label"><?= $Page->Asset_Status->caption() ?></label>
        <span id="el_DetailedReport_Asset_Status" class="ew-search-field">
    <select
        id="x_Asset_Status"
        name="x_Asset_Status"
        class="form-control ew-select<?= $Page->Asset_Status->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_Asset_Status"
        data-table="DetailedReport"
        data-field="x_Asset_Status"
        data-value-separator="<?= $Page->Asset_Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Asset_Status->getPlaceHolder()) ?>"
        <?= $Page->Asset_Status->editAttributes() ?>>
        <?= $Page->Asset_Status->selectOptionListHtml("x_Asset_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Asset_Status->getErrorMessage() ?></div>
<?= $Page->Asset_Status->Lookup->getParamTag($Page, "p_x_Asset_Status") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_Asset_Status']"),
        options = { name: "x_Asset_Status", selectId: "DetailedReport_x_Asset_Status", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.Asset_Status.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { // Condition_Of_Asset ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Condition_Of_Asset" class="ew-cell form-group">
        <label for="x_Condition_Of_Asset" class="ew-search-caption ew-label"><?= $Page->Condition_Of_Asset->caption() ?></label>
        <span id="el_DetailedReport_Condition_Of_Asset" class="ew-search-field">
    <select
        id="x_Condition_Of_Asset"
        name="x_Condition_Of_Asset"
        class="form-control ew-select<?= $Page->Condition_Of_Asset->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_Condition_Of_Asset"
        data-table="DetailedReport"
        data-field="x_Condition_Of_Asset"
        data-value-separator="<?= $Page->Condition_Of_Asset->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Condition_Of_Asset->getPlaceHolder()) ?>"
        <?= $Page->Condition_Of_Asset->editAttributes() ?>>
        <?= $Page->Condition_Of_Asset->selectOptionListHtml("x_Condition_Of_Asset") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Condition_Of_Asset->getErrorMessage() ?></div>
<?= $Page->Condition_Of_Asset->Lookup->getParamTag($Page, "p_x_Condition_Of_Asset") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_Condition_Of_Asset']"),
        options = { name: "x_Condition_Of_Asset", selectId: "DetailedReport_x_Condition_Of_Asset", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.Condition_Of_Asset.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { // Custodian_id ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Custodian_id" class="ew-cell form-group">
        <label for="x_Custodian_id" class="ew-search-caption ew-label"><?= $Page->Custodian_id->caption() ?></label>
        <span id="el_DetailedReport_Custodian_id" class="ew-search-field">
    <select
        id="x_Custodian_id"
        name="x_Custodian_id"
        class="form-control ew-select<?= $Page->Custodian_id->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_Custodian_id"
        data-table="DetailedReport"
        data-field="x_Custodian_id"
        data-value-separator="<?= $Page->Custodian_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Custodian_id->getPlaceHolder()) ?>"
        <?= $Page->Custodian_id->editAttributes() ?>>
        <?= $Page->Custodian_id->selectOptionListHtml("x_Custodian_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Custodian_id->getErrorMessage() ?></div>
<?= $Page->Custodian_id->Lookup->getParamTag($Page, "p_x_Custodian_id") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_Custodian_id']"),
        options = { name: "x_Custodian_id", selectId: "DetailedReport_x_Custodian_id", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.Custodian_id.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Category->Visible) { // Category ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Category" class="ew-cell form-group">
        <label class="ew-search-caption ew-label"><?= $Page->Category->caption() ?></label>
        <span id="el_DetailedReport_Category" class="ew-search-field">
<template id="tp_x_Category">
    <div class="custom-control custom-checkbox">
        <input type="checkbox" class="custom-control-input" data-table="DetailedReport" data-field="x_Category" name="x_Category" id="x_Category"<?= $Page->Category->editAttributes() ?>>
        <label class="custom-control-label"></label>
    </div>
</template>
<div id="dsl_x_Category" class="ew-item-list"></div>
<?php $Page->Category->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
<input type="hidden"
    is="selection-list"
    id="x_Category[]"
    name="x_Category[]"
    value="<?= HtmlEncode($Page->Category->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_Category"
    data-target="dsl_x_Category"
    data-repeatcolumn="5"
    class="form-control<?= $Page->Category->isInvalidClass() ?>"
    data-table="DetailedReport"
    data-field="x_Category"
    data-value-separator="<?= $Page->Category->displayValueSeparatorAttribute() ?>"
    <?= $Page->Category->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Category->getErrorMessage() ?></div>
<?= $Page->Category->Lookup->getParamTag($Page, "p_x_Category") ?>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { // Category_Details ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Category_Details" class="ew-cell form-group">
        <label for="x_Category_Details" class="ew-search-caption ew-label"><?= $Page->Category_Details->caption() ?></label>
        <span id="el_DetailedReport_Category_Details" class="ew-search-field">
    <select
        id="x_Category_Details"
        name="x_Category_Details"
        class="form-control ew-select<?= $Page->Category_Details->isInvalidClass() ?>"
        data-select2-id="DetailedReport_x_Category_Details"
        data-table="DetailedReport"
        data-field="x_Category_Details"
        data-value-separator="<?= $Page->Category_Details->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Category_Details->getPlaceHolder()) ?>"
        <?= $Page->Category_Details->editAttributes() ?>>
        <?= $Page->Category_Details->selectOptionListHtml("x_Category_Details") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Category_Details->getErrorMessage() ?></div>
<?= $Page->Category_Details->Lookup->getParamTag($Page, "p_x_Category_Details") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='DetailedReport_x_Category_Details']"),
        options = { name: "x_Category_Details", selectId: "DetailedReport_x_Category_Details", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.DetailedReport.fields.Category_Details.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { // Date_of_Acquisition ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Date_of_Acquisition" class="ew-cell form-group">
        <label for="x_Date_of_Acquisition" class="ew-search-caption ew-label"><?= $Page->Date_of_Acquisition->caption() ?></label>
        <span class="ew-search-operator">
<?= $Language->phrase("BETWEEN") ?>
<input type="hidden" name="z_Date_of_Acquisition" id="z_Date_of_Acquisition" value="BETWEEN">
</span>
        <span id="el_DetailedReport_Date_of_Acquisition" class="ew-search-field">
<input type="<?= $Page->Date_of_Acquisition->getInputTextType() ?>" data-table="DetailedReport" data-field="x_Date_of_Acquisition" name="x_Date_of_Acquisition" id="x_Date_of_Acquisition" placeholder="<?= HtmlEncode($Page->Date_of_Acquisition->getPlaceHolder()) ?>" value="<?= $Page->Date_of_Acquisition->EditValue ?>"<?= $Page->Date_of_Acquisition->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date_of_Acquisition->getErrorMessage() ?></div>
<?php if (!$Page->Date_of_Acquisition->ReadOnly && !$Page->Date_of_Acquisition->Disabled && !isset($Page->Date_of_Acquisition->EditAttrs["readonly"]) && !isset($Page->Date_of_Acquisition->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsummary", "datetimepicker"], function() {
    ew.createDateTimePicker("fsummary", "x_Date_of_Acquisition", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
        <span class="ew-search-and"><label><?= $Language->phrase("AND") ?></label></span>
        <span id="el2_DetailedReport_Date_of_Acquisition" class="ew-search-field2">
<input type="<?= $Page->Date_of_Acquisition->getInputTextType() ?>" data-table="DetailedReport" data-field="x_Date_of_Acquisition" name="y_Date_of_Acquisition" id="y_Date_of_Acquisition" placeholder="<?= HtmlEncode($Page->Date_of_Acquisition->getPlaceHolder()) ?>" value="<?= $Page->Date_of_Acquisition->EditValue2 ?>"<?= $Page->Date_of_Acquisition->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date_of_Acquisition->getErrorMessage() ?></div>
<?php if (!$Page->Date_of_Acquisition->ReadOnly && !$Page->Date_of_Acquisition->Disabled && !isset($Page->Date_of_Acquisition->EditAttrs["readonly"]) && !isset($Page->Date_of_Acquisition->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsummary", "datetimepicker"], function() {
    ew.createDateTimePicker("fsummary", "y_Date_of_Acquisition", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { // Aquistion_Cost ?>
    <?php
        $Page->SearchColumnCount++;
        if (($Page->SearchColumnCount - 1) % $Page->SearchFieldsPerRow == 0) {
            $Page->SearchRowCount++;
    ?>
<div id="xsr_<?= $Page->SearchRowCount ?>" class="ew-row d-sm-flex">
    <?php
        }
     ?>
    <div id="xsc_Aquistion_Cost" class="ew-cell form-group">
        <label for="x_Aquistion_Cost" class="ew-search-caption ew-label"><?= $Page->Aquistion_Cost->caption() ?></label>
        <span class="ew-search-operator">
<?= $Language->phrase("BETWEEN") ?>
<input type="hidden" name="z_Aquistion_Cost" id="z_Aquistion_Cost" value="BETWEEN">
</span>
        <span id="el_DetailedReport_Aquistion_Cost" class="ew-search-field">
<input type="<?= $Page->Aquistion_Cost->getInputTextType() ?>" data-table="DetailedReport" data-field="x_Aquistion_Cost" name="x_Aquistion_Cost" id="x_Aquistion_Cost" size="30" placeholder="<?= HtmlEncode($Page->Aquistion_Cost->getPlaceHolder()) ?>" value="<?= $Page->Aquistion_Cost->EditValue ?>"<?= $Page->Aquistion_Cost->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Aquistion_Cost->getErrorMessage() ?></div>
</span>
        <span class="ew-search-and"><label><?= $Language->phrase("AND") ?></label></span>
        <span id="el2_DetailedReport_Aquistion_Cost" class="ew-search-field2">
<input type="<?= $Page->Aquistion_Cost->getInputTextType() ?>" data-table="DetailedReport" data-field="x_Aquistion_Cost" name="y_Aquistion_Cost" id="y_Aquistion_Cost" size="30" placeholder="<?= HtmlEncode($Page->Aquistion_Cost->getPlaceHolder()) ?>" value="<?= $Page->Aquistion_Cost->EditValue2 ?>"<?= $Page->Aquistion_Cost->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Aquistion_Cost->getErrorMessage() ?></div>
</span>
    </div>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow == 0) { ?>
</div>
    <?php } ?>
<?php } ?>
    <?php if ($Page->SearchColumnCount % $Page->SearchFieldsPerRow > 0) { ?>
</div>
    <?php } ?>
<div id="xsr_<?= $Page->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
    <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
</div>
    </div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php } ?>
<?php
while ($Page->RecordCount < count($Page->DetailRecords) && $Page->RecordCount < $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if (!$Page->isExport("pdf")) { ?>
<div class="<?php if (!$Page->isExport("word") && !$Page->isExport("excel")) { ?>card ew-card <?php } ?>ew-grid"<?= $Page->ReportTableStyle ?>>
<?php } ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0)) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?= CurrentPageUrl(false) ?>">
<?= $Page->Pager->render() ?>
</form>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$Page->isExport("pdf")) { ?>
<!-- Report grid (begin) -->
<div id="gmp_DetailedReport" class="<?= ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php } ?>
<table class="<?= $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->_23->Visible) { ?>
    <th data-name="_23" class="<?= $Page->_23->headerCellClass() ?>"><div class="DetailedReport__23"><?= $Page->renderSort($Page->_23) ?></div></th>
<?php } ?>
<?php if ($Page->Assetsid->Visible) { ?>
    <th data-name="Assetsid" class="<?= $Page->Assetsid->headerCellClass() ?>"><div class="DetailedReport_Assetsid"><?= $Page->renderSort($Page->Assetsid) ?></div></th>
<?php } ?>
<?php if ($Page->MDA_Parent->Visible) { ?>
    <th data-name="MDA_Parent" class="<?= $Page->MDA_Parent->headerCellClass() ?>"><div class="DetailedReport_MDA_Parent"><?= $Page->renderSort($Page->MDA_Parent) ?></div></th>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
    <th data-name="MDA_id" class="<?= $Page->MDA_id->headerCellClass() ?>"><div class="DetailedReport_MDA_id"><?= $Page->renderSort($Page->MDA_id) ?></div></th>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
    <th data-name="Location_id" class="<?= $Page->Location_id->headerCellClass() ?>"><div class="DetailedReport_Location_id"><?= $Page->renderSort($Page->Location_id) ?></div></th>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
    <th data-name="Details_of_Asset" class="<?= $Page->Details_of_Asset->headerCellClass() ?>"><div class="DetailedReport_Details_of_Asset"><?= $Page->renderSort($Page->Details_of_Asset) ?></div></th>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
    <th data-name="Asset_Status" class="<?= $Page->Asset_Status->headerCellClass() ?>"><div class="DetailedReport_Asset_Status"><?= $Page->renderSort($Page->Asset_Status) ?></div></th>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
    <th data-name="Condition_Of_Asset" class="<?= $Page->Condition_Of_Asset->headerCellClass() ?>"><div class="DetailedReport_Condition_Of_Asset"><?= $Page->renderSort($Page->Condition_Of_Asset) ?></div></th>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
    <th data-name="Custodian_id" class="<?= $Page->Custodian_id->headerCellClass() ?>"><div class="DetailedReport_Custodian_id"><?= $Page->renderSort($Page->Custodian_id) ?></div></th>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
    <th data-name="Category" class="<?= $Page->Category->headerCellClass() ?>"><div class="DetailedReport_Category"><?= $Page->renderSort($Page->Category) ?></div></th>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
    <th data-name="Category_Details" class="<?= $Page->Category_Details->headerCellClass() ?>"><div class="DetailedReport_Category_Details"><?= $Page->renderSort($Page->Category_Details) ?></div></th>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
    <th data-name="Date_of_Acquisition" class="<?= $Page->Date_of_Acquisition->headerCellClass() ?>"><div class="DetailedReport_Date_of_Acquisition"><?= $Page->renderSort($Page->Date_of_Acquisition) ?></div></th>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
    <th data-name="Aquistion_Cost" class="<?= $Page->Aquistion_Cost->headerCellClass() ?>"><div class="DetailedReport_Aquistion_Cost"><?= $Page->renderSort($Page->Aquistion_Cost) ?></div></th>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
    <th data-name="Additional_Cost" class="<?= $Page->Additional_Cost->headerCellClass() ?>"><div class="DetailedReport_Additional_Cost"><?= $Page->renderSort($Page->Additional_Cost) ?></div></th>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
    <th data-name="Revaluation_Cost" class="<?= $Page->Revaluation_Cost->headerCellClass() ?>"><div class="DetailedReport_Revaluation_Cost"><?= $Page->renderSort($Page->Revaluation_Cost) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php
    $Page->loadRowValues($Page->DetailRecords[$Page->RecordCount]);
    $Page->RecordCount++;
    $Page->RecordIndex++;
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = ROWTYPE_DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->_23->Visible) { ?>
        <td data-field="_23"<?= $Page->_23->cellAttributes() ?>>
<span<?= $Page->_23->viewAttributes() ?>>
<?= $Page->_23->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Assetsid->Visible) { ?>
        <td data-field="Assetsid"<?= $Page->Assetsid->cellAttributes() ?>>
<span<?= $Page->Assetsid->viewAttributes() ?>>
<?= $Page->Assetsid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->MDA_Parent->Visible) { ?>
        <td data-field="MDA_Parent"<?= $Page->MDA_Parent->cellAttributes() ?>>
<span<?= $Page->MDA_Parent->viewAttributes() ?>>
<?= $Page->MDA_Parent->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>>
<span<?= $Page->MDA_id->viewAttributes() ?>>
<?= $Page->MDA_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>>
<span<?= $Page->Location_id->viewAttributes() ?>>
<?= $Page->Location_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>>
<span<?= $Page->Details_of_Asset->viewAttributes() ?>>
<?= $Page->Details_of_Asset->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>>
<span<?= $Page->Asset_Status->viewAttributes() ?>>
<?= $Page->Asset_Status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>>
<span<?= $Page->Condition_Of_Asset->viewAttributes() ?>>
<?= $Page->Condition_Of_Asset->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>>
<span<?= $Page->Custodian_id->viewAttributes() ?>>
<?= $Page->Custodian_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>>
<span<?= $Page->Category->viewAttributes() ?>>
<?= $Page->Category->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>>
<span<?= $Page->Category_Details->viewAttributes() ?>>
<?= $Page->Category_Details->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>>
<span<?= $Page->Date_of_Acquisition->viewAttributes() ?>>
<?= $Page->Date_of_Acquisition->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>>
<span<?= $Page->Aquistion_Cost->viewAttributes() ?>>
<?= $Page->Aquistion_Cost->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>>
<span<?= $Page->Additional_Cost->viewAttributes() ?>>
<?= $Page->Additional_Cost->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>>
<span<?= $Page->Revaluation_Cost->viewAttributes() ?>>
<?= $Page->Revaluation_Cost->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php
    $Page->resetAttributes();
    $Page->RowType = ROWTYPE_TOTAL;
    $Page->RowTotalType = ROWTOTAL_GRAND;
    $Page->RowTotalSubType = ROWTOTAL_FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, 0); ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate">&nbsp;</td>
<?php } ?>
<?php if ($Page->_23->Visible) { ?>
        <td data-field="_23"<?= $Page->_23->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Assetsid->Visible) { ?>
        <td data-field="Assetsid"<?= $Page->Assetsid->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->MDA_Parent->Visible) { ?>
        <td data-field="MDA_Parent"<?= $Page->MDA_Parent->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Aquistion_Cost->viewAttributes() ?>><?= $Page->Aquistion_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Additional_Cost->viewAttributes() ?>><?= $Page->Additional_Cost->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?= $Page->Revaluation_Cost->viewAttributes() ?>><?= $Page->Revaluation_Cost->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, 0); ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->_23->Visible) { ?>
        <td data-field="_23"<?= $Page->_23->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Assetsid->Visible) { ?>
        <td data-field="Assetsid"<?= $Page->Assetsid->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->MDA_Parent->Visible) { ?>
        <td data-field="MDA_Parent"<?= $Page->MDA_Parent->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->MDA_id->Visible) { ?>
        <td data-field="MDA_id"<?= $Page->MDA_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Location_id->Visible) { ?>
        <td data-field="Location_id"<?= $Page->Location_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Details_of_Asset->Visible) { ?>
        <td data-field="Details_of_Asset"<?= $Page->Details_of_Asset->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Asset_Status->Visible) { ?>
        <td data-field="Asset_Status"<?= $Page->Asset_Status->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Condition_Of_Asset->Visible) { ?>
        <td data-field="Condition_Of_Asset"<?= $Page->Condition_Of_Asset->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Custodian_id->Visible) { ?>
        <td data-field="Custodian_id"<?= $Page->Custodian_id->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Category->Visible) { ?>
        <td data-field="Category"<?= $Page->Category->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Category_Details->Visible) { ?>
        <td data-field="Category_Details"<?= $Page->Category_Details->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Date_of_Acquisition->Visible) { ?>
        <td data-field="Date_of_Acquisition"<?= $Page->Date_of_Acquisition->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Page->Aquistion_Cost->Visible) { ?>
        <td data-field="Aquistion_Cost"<?= $Page->Aquistion_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Aquistion_Cost->viewAttributes() ?>>
<?= $Page->Aquistion_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Additional_Cost->Visible) { ?>
        <td data-field="Additional_Cost"<?= $Page->Additional_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Additional_Cost->viewAttributes() ?>>
<?= $Page->Additional_Cost->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->Revaluation_Cost->Visible) { ?>
        <td data-field="Revaluation_Cost"<?= $Page->Revaluation_Cost->cellAttributes() ?>><span class="ew-aggregate"><?= $Language->phrase("RptSum") ?></span><?= $Language->phrase("AggregateColon") ?>
<span<?= $Page->Revaluation_Cost->viewAttributes() ?>>
<?= $Page->Revaluation_Cost->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
<?php if (!$Page->isExport("pdf")) { ?>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php } ?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0)) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?= CurrentPageUrl(false) ?>">
<?= $Page->Pager->render() ?>
</form>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php } ?>
<?php if (!$Page->isExport("pdf")) { ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
<?php } ?>
<?php if (!$Page->isExport("pdf")) { ?>
</div>
<!-- /#report-summary -->
<?php } ?>
<!-- Summary report (end) -->
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /#ew-center -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /.row -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /.ew-report -->
<?php } ?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
