<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for summary report 3
 */
class Summaryreport3 extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $_23;
    public $Date_of_Acquisition;
    public $MDA_id;
    public $MDA_Acronym;
    public $MDA;
    public $Total_Asset;
    public $Total_Cost;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'summaryreport3';
        $this->TableName = 'summary report 3';
        $this->TableType = 'VIEW';

        // Update Table
        $this->UpdateTable = "`summary report 3`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // #
        $this->_23 = new DbField('summaryreport3', 'summary report 3', 'x__23', '#', '`#`', '`#`', 20, 21, -1, false, '`#`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->_23->Nullable = false; // NOT NULL field
        $this->_23->Required = true; // Required field
        $this->_23->Sortable = true; // Allow sort
        $this->_23->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_23->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_23->Param, "CustomMsg");
        $this->Fields['#'] = &$this->_23;

        // Date_of_Acquisition
        $this->Date_of_Acquisition = new DbField('summaryreport3', 'summary report 3', 'x_Date_of_Acquisition', 'Date_of_Acquisition', '`Date_of_Acquisition`', CastDateFieldForLike("`Date_of_Acquisition`", 0, "DB"), 133, 10, 0, false, '`Date_of_Acquisition`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Date_of_Acquisition->Nullable = false; // NOT NULL field
        $this->Date_of_Acquisition->Required = true; // Required field
        $this->Date_of_Acquisition->Sortable = true; // Allow sort
        $this->Date_of_Acquisition->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Date_of_Acquisition->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Date_of_Acquisition->Param, "CustomMsg");
        $this->Fields['Date_of_Acquisition'] = &$this->Date_of_Acquisition;

        // MDA_id
        $this->MDA_id = new DbField('summaryreport3', 'summary report 3', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 11, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // MDA_Acronym
        $this->MDA_Acronym = new DbField('summaryreport3', 'summary report 3', 'x_MDA_Acronym', 'MDA_Acronym', '`MDA_Acronym`', '`MDA_Acronym`', 200, 100, -1, false, '`MDA_Acronym`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA_Acronym->Nullable = false; // NOT NULL field
        $this->MDA_Acronym->Required = true; // Required field
        $this->MDA_Acronym->Sortable = true; // Allow sort
        $this->MDA_Acronym->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_Acronym->Param, "CustomMsg");
        $this->Fields['MDA_Acronym'] = &$this->MDA_Acronym;

        // MDA
        $this->MDA = new DbField('summaryreport3', 'summary report 3', 'x_MDA', 'MDA', '`MDA`', '`MDA`', 200, 255, -1, false, '`MDA`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA->Nullable = false; // NOT NULL field
        $this->MDA->Required = true; // Required field
        $this->MDA->Sortable = true; // Allow sort
        $this->MDA->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA->Param, "CustomMsg");
        $this->Fields['MDA'] = &$this->MDA;

        // Total_Asset
        $this->Total_Asset = new DbField('summaryreport3', 'summary report 3', 'x_Total_Asset', 'Total_Asset', '`Total_Asset`', '`Total_Asset`', 20, 21, -1, false, '`Total_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Total_Asset->Nullable = false; // NOT NULL field
        $this->Total_Asset->Required = true; // Required field
        $this->Total_Asset->Sortable = true; // Allow sort
        $this->Total_Asset->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Total_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Total_Asset->Param, "CustomMsg");
        $this->Fields['Total_Asset'] = &$this->Total_Asset;

        // Total_Cost
        $this->Total_Cost = new DbField('summaryreport3', 'summary report 3', 'x_Total_Cost', 'Total_Cost', '`Total_Cost`', '`Total_Cost`', 5, 23, -1, false, '`Total_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Total_Cost->Sortable = true; // Allow sort
        $this->Total_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Total_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Total_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Total_Cost->Param, "CustomMsg");
        $this->Fields['Total_Cost'] = &$this->Total_Cost;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`summary report 3`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->_23->DbValue = $row['#'];
        $this->Date_of_Acquisition->DbValue = $row['Date_of_Acquisition'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->MDA_Acronym->DbValue = $row['MDA_Acronym'];
        $this->MDA->DbValue = $row['MDA'];
        $this->Total_Asset->DbValue = $row['Total_Asset'];
        $this->Total_Cost->DbValue = $row['Total_Cost'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("summaryreport3list");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "summaryreport3view") {
            return $Language->phrase("View");
        } elseif ($pageName == "summaryreport3edit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "summaryreport3add") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "Summaryreport3View";
            case Config("API_ADD_ACTION"):
                return "Summaryreport3Add";
            case Config("API_EDIT_ACTION"):
                return "Summaryreport3Edit";
            case Config("API_DELETE_ACTION"):
                return "Summaryreport3Delete";
            case Config("API_LIST_ACTION"):
                return "Summaryreport3List";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "summaryreport3list";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("summaryreport3view", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("summaryreport3view", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "summaryreport3add?" . $this->getUrlParm($parm);
        } else {
            $url = "summaryreport3add";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("summaryreport3edit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("summaryreport3add", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("summaryreport3delete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->_23->setDbValue($row['#']);
        $this->Date_of_Acquisition->setDbValue($row['Date_of_Acquisition']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->MDA_Acronym->setDbValue($row['MDA_Acronym']);
        $this->MDA->setDbValue($row['MDA']);
        $this->Total_Asset->setDbValue($row['Total_Asset']);
        $this->Total_Cost->setDbValue($row['Total_Cost']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // #

        // Date_of_Acquisition

        // MDA_id

        // MDA_Acronym

        // MDA

        // Total_Asset

        // Total_Cost

        // #
        $this->_23->ViewValue = $this->_23->CurrentValue;
        $this->_23->ViewValue = FormatNumber($this->_23->ViewValue, 0, -2, -2, -2);
        $this->_23->ViewCustomAttributes = "";

        // Date_of_Acquisition
        $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
        $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
        $this->Date_of_Acquisition->ViewCustomAttributes = "";

        // MDA_id
        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->ViewValue = FormatNumber($this->MDA_id->ViewValue, 0, -2, -2, -2);
        $this->MDA_id->ViewCustomAttributes = "";

        // MDA_Acronym
        $this->MDA_Acronym->ViewValue = $this->MDA_Acronym->CurrentValue;
        $this->MDA_Acronym->ViewCustomAttributes = "";

        // MDA
        $this->MDA->ViewValue = $this->MDA->CurrentValue;
        $this->MDA->ViewCustomAttributes = "";

        // Total_Asset
        $this->Total_Asset->ViewValue = $this->Total_Asset->CurrentValue;
        $this->Total_Asset->ViewValue = FormatNumber($this->Total_Asset->ViewValue, 0, -2, -2, -2);
        $this->Total_Asset->ViewCustomAttributes = "";

        // Total_Cost
        $this->Total_Cost->ViewValue = $this->Total_Cost->CurrentValue;
        $this->Total_Cost->ViewValue = FormatNumber($this->Total_Cost->ViewValue, 2, -2, -2, -2);
        $this->Total_Cost->ViewCustomAttributes = "";

        // #
        $this->_23->LinkCustomAttributes = "";
        $this->_23->HrefValue = "";
        $this->_23->TooltipValue = "";

        // Date_of_Acquisition
        $this->Date_of_Acquisition->LinkCustomAttributes = "";
        $this->Date_of_Acquisition->HrefValue = "";
        $this->Date_of_Acquisition->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // MDA_Acronym
        $this->MDA_Acronym->LinkCustomAttributes = "";
        $this->MDA_Acronym->HrefValue = "";
        $this->MDA_Acronym->TooltipValue = "";

        // MDA
        $this->MDA->LinkCustomAttributes = "";
        $this->MDA->HrefValue = "";
        $this->MDA->TooltipValue = "";

        // Total_Asset
        $this->Total_Asset->LinkCustomAttributes = "";
        $this->Total_Asset->HrefValue = "";
        $this->Total_Asset->TooltipValue = "";

        // Total_Cost
        $this->Total_Cost->LinkCustomAttributes = "";
        $this->Total_Cost->HrefValue = "";
        $this->Total_Cost->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // #
        $this->_23->EditAttrs["class"] = "form-control";
        $this->_23->EditCustomAttributes = "";
        $this->_23->EditValue = $this->_23->CurrentValue;
        $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

        // Date_of_Acquisition
        $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
        $this->Date_of_Acquisition->EditCustomAttributes = "";
        $this->Date_of_Acquisition->EditValue = FormatDateTime($this->Date_of_Acquisition->CurrentValue, 8);
        $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());

        // MDA_Acronym
        $this->MDA_Acronym->EditAttrs["class"] = "form-control";
        $this->MDA_Acronym->EditCustomAttributes = "";
        if (!$this->MDA_Acronym->Raw) {
            $this->MDA_Acronym->CurrentValue = HtmlDecode($this->MDA_Acronym->CurrentValue);
        }
        $this->MDA_Acronym->EditValue = $this->MDA_Acronym->CurrentValue;
        $this->MDA_Acronym->PlaceHolder = RemoveHtml($this->MDA_Acronym->caption());

        // MDA
        $this->MDA->EditAttrs["class"] = "form-control";
        $this->MDA->EditCustomAttributes = "";
        if (!$this->MDA->Raw) {
            $this->MDA->CurrentValue = HtmlDecode($this->MDA->CurrentValue);
        }
        $this->MDA->EditValue = $this->MDA->CurrentValue;
        $this->MDA->PlaceHolder = RemoveHtml($this->MDA->caption());

        // Total_Asset
        $this->Total_Asset->EditAttrs["class"] = "form-control";
        $this->Total_Asset->EditCustomAttributes = "";
        $this->Total_Asset->EditValue = $this->Total_Asset->CurrentValue;
        $this->Total_Asset->PlaceHolder = RemoveHtml($this->Total_Asset->caption());

        // Total_Cost
        $this->Total_Cost->EditAttrs["class"] = "form-control";
        $this->Total_Cost->EditCustomAttributes = "";
        $this->Total_Cost->EditValue = $this->Total_Cost->CurrentValue;
        $this->Total_Cost->PlaceHolder = RemoveHtml($this->Total_Cost->caption());
        if (strval($this->Total_Cost->EditValue) != "" && is_numeric($this->Total_Cost->EditValue)) {
            $this->Total_Cost->EditValue = FormatNumber($this->Total_Cost->EditValue, -2, -2, -2, -2);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->_23);
                    $doc->exportCaption($this->Date_of_Acquisition);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->MDA_Acronym);
                    $doc->exportCaption($this->MDA);
                    $doc->exportCaption($this->Total_Asset);
                    $doc->exportCaption($this->Total_Cost);
                } else {
                    $doc->exportCaption($this->_23);
                    $doc->exportCaption($this->Date_of_Acquisition);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->MDA_Acronym);
                    $doc->exportCaption($this->MDA);
                    $doc->exportCaption($this->Total_Asset);
                    $doc->exportCaption($this->Total_Cost);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->_23);
                        $doc->exportField($this->Date_of_Acquisition);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->MDA_Acronym);
                        $doc->exportField($this->MDA);
                        $doc->exportField($this->Total_Asset);
                        $doc->exportField($this->Total_Cost);
                    } else {
                        $doc->exportField($this->_23);
                        $doc->exportField($this->Date_of_Acquisition);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->MDA_Acronym);
                        $doc->exportField($this->MDA);
                        $doc->exportField($this->Total_Asset);
                        $doc->exportField($this->Total_Cost);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
